/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsEditor;
import com.hifiremote.jp1.NumberDeviceParm;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.TableSorter;
import com.hifiremote.jp1.Value;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DeviceUpgradeTableModel
extends JP1TableModel<DeviceUpgrade>
implements PropertyChangeListener {
    private static final String[] colNames = new String[]{"#", "<html>Device<br>Type</html>", "<html>Setup<br>Code</html>", "<html>Specific to<br>Device Button</html>", "<html>Available on<br>Other Buttons?</html>", "Device Codes", "PID", "Variant", "Protocol", "Description", "<html>Dev.<br>Size &amp<br>Color</html>", "<html>Prot.<br>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "CBL/SAT__", "Setup_____", "Device Button__", "Other Buttons?__", "Device Code List_______", "0000__", "Variant_____", "Panasonic Mixed Combo___", "A relatively long description and then some more___", "Color_", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, String.class, Boolean.class, String.class, Protocol.class, Protocol.class, Protocol.class, String.class, Color.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private SelectAllCellEditor descriptionEditor = new SelectAllCellEditor();
    private JComboBox deviceButtonBox = new JComboBox();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            for (DeviceUpgrade upgrade : remoteConfig.getDeviceUpgrades()) {
                upgrade.removePropertyChangeListener(this);
            }
            for (DeviceUpgrade upgrade : remoteConfig.getDeviceUpgrades()) {
                upgrade.addPropertyChangeListener(this);
            }
            this.setData(remoteConfig.getDeviceUpgrades());
            Remote remote = remoteConfig.getRemote();
            if (remote.hasDeviceDependentUpgrades() > 0) {
                DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
                if (remote.hasDeviceDependentUpgrades() == 2 || remote.getDeviceButtons().length == 0) {
                    comboModel.insertElementAt(DeviceButton.noButton, 0);
                }
                this.deviceButtonBox.setModel(comboModel);
            }
        }
    }

    @Override
    public int getColumnCount() {
        int count = 8;
        if (this.remoteConfig != null) {
            if (this.remoteConfig.getNoSetup() != null) {
                --count;
            }
            Remote remote = this.remoteConfig.getRemote();
            count += remote.hasDeviceDependentUpgrades();
            if (this.remoteConfig.allowHighlighting()) {
                count += 2;
            }
        }
        return count;
    }

    public int getEffectiveColumn(int col) {
        if (this.remoteConfig != null && this.remoteConfig.getNoSetup() != null) {
            col += col > 2 ? 3 : 0;
        } else if ((this.remoteConfig == null || this.remoteConfig.getRemote().hasDeviceDependentUpgrades() == 0) && col > 2) {
            col += 2;
        } else if (this.remoteConfig != null && this.remoteConfig.getRemote().hasDeviceDependentUpgrades() == 1 && col > 3) {
            ++col;
        }
        return col;
    }

    @Override
    public String getColumnName(int col) {
        col = this.getEffectiveColumn(col);
        if (this.remoteConfig != null && this.remoteConfig.getNoSetup() != null && col == 2) {
            return "<html>Serial/<br>Dev Code</html>";
        }
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return (col = this.getEffectiveColumn(col)) < 5 || col == 6 || col == 7 || col > 9;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if ((col = this.getEffectiveColumn(col)) == 11) {
            return ((DeviceUpgrade)this.getRow(row)).needsProtocolCode();
        }
        return col > 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        DeviceUpgrade device = (DeviceUpgrade)this.getRow(row);
        switch (this.getEffectiveColumn(column)) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                if (device.hasSerial()) {
                    return "";
                }
                return device.getDeviceTypeAliasName();
            }
            case 2: {
                SetupCode sc;
                int value = device.getSetupCode();
                SetupCode setupCode = sc = value < 0 ? null : new SetupCode(device.getSetupCode());
                if (device.hasSerial()) {
                    return value;
                }
                return sc;
            }
            case 3: {
                return device.getButtonRestriction().getName();
            }
            case 4: {
                return device.getButtonIndependent();
            }
            case 5: {
                DeviceUpgrade cloneDu = new DeviceUpgrade(device, null);
                if (cloneDu.getProtocol() == null) {
                    return null;
                }
                Value[] parmValues = cloneDu.getParmValues();
                String[] parmValueArray = DeviceUpgrade.valueArrayToString(parmValues).split(" ");
                DeviceParameter[] devParms = cloneDu.getProtocol().getDeviceParameters();
                String valuesOut = "";
                String devVal = null;
                String subVal = null;
                int count = 0;
                boolean allNull = true;
                for (int i = devParms.length - 1; i >= 0; --i) {
                    DeviceParameter dp = devParms[i];
                    if (!(dp instanceof NumberDeviceParm) || (parmValueArray[i] == null || parmValueArray[i].equals("null")) && allNull) continue;
                    allNull = false;
                    valuesOut = parmValueArray[i] + " " + valuesOut;
                    if (i == 0 && devParms[0].getName().toLowerCase().startsWith("dev")) {
                        devVal = parmValueArray[0];
                    }
                    if (i == 1 && devParms[1].getName().toLowerCase().startsWith("sub")) {
                        subVal = parmValueArray[1];
                    }
                    ++count;
                }
                if (count == 2 && devVal != null && subVal != null) {
                    valuesOut = devVal + (!subVal.equals("null") ? "." + subVal : "");
                }
                return valuesOut.trim();
            }
            case 6: 
            case 7: 
            case 8: {
                return device.getSetupCode() < 0 ? null : device.getProtocol();
            }
            case 9: {
                return device.getDescription();
            }
            case 10: {
                return device.getHighlight();
            }
            case 11: {
                return device.getProtocolHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        DeviceUpgrade device = (DeviceUpgrade)this.getRow(row);
        Remote remote = this.remoteConfig.getRemote();
        switch (this.getEffectiveColumn(col)) {
            case 3: {
                DeviceButton devBtn = (DeviceButton)value;
                device.setButtonRestriction(devBtn);
                if (devBtn != DeviceButton.noButton) {
                    devBtn.setUpgrade(device);
                }
                this.propertyChangeSupport.firePropertyChange("device", null, null);
                break;
            }
            case 4: {
                device.setButtonIndependent((Boolean)value);
                this.propertyChangeSupport.firePropertyChange("device", null, null);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Protocol temp;
                Protocol p = (Protocol)value;
                device.setProtocol(p, false);
                String proc = remote.getProcessor().getEquivalentName();
                Hex code = p.customCode.get(proc);
                if (code != null) {
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        if (du == device || !(temp = du.getProtocol()).getID(remote).equals(p.getID(remote))) continue;
                        temp.customCode.put(proc, code);
                    }
                } else {
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        if (du == device || !(temp = du.getProtocol()).getID(remote).equals(p.getID(remote))) continue;
                        temp.customCode.remove(proc);
                    }
                }
                if (p instanceof ManualProtocol) {
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        temp = du.getProtocol();
                        if (!(temp instanceof ManualProtocol) || !temp.getName().equals(p.getName()) || temp == p) continue;
                        du.setProtocol(p, false);
                    }
                }
                this.propertyChangeSupport.firePropertyChange("device", null, null);
                this.fireTableDataChanged();
                break;
            }
            case 9: {
                device.setDescription((String)value);
                this.propertyChangeSupport.firePropertyChange("device", null, null);
                break;
            }
            case 10: {
                device.setHighlight((Color)value);
                this.propertyChangeSupport.firePropertyChange("highlight", null, null);
                break;
            }
            case 11: {
                device.setProtocolHighlight((Color)value);
                boolean updateRequired = false;
                if (device.getButtonIndependent().booleanValue() && device.needsProtocolCode()) {
                    Hex pid = device.getProtocol().getID(remote);
                    Hex pCode = device.getCode();
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        if (!du.getButtonIndependent().booleanValue() || !du.needsProtocolCode() || !du.getProtocol().getID(remote).equals(pid) || !du.getCode().equals(pCode)) continue;
                        du.setProtocolHighlight((Color)value);
                        updateRequired = true;
                    }
                }
                if (device.getButtonRestriction() != DeviceButton.noButton && device.needsProtocolCode() && remote.hasDeviceDependentUpgrades() == 2) {
                    short[] data = this.remoteConfig.getData();
                    int offset = device.getDependentOffset();
                    int protOffset = offset + data[offset + 1];
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        int duOffset;
                        int duProtOffset;
                        if (du.getButtonRestriction() == DeviceButton.noButton || !du.needsProtocolCode() || (duProtOffset = (duOffset = du.getDependentOffset()) + data[duOffset + 1]) != protOffset) continue;
                        du.setProtocolHighlight((Color)value);
                        updateRequired = true;
                    }
                }
                if (updateRequired) {
                    this.fireTableDataChanged();
                }
                this.propertyChangeSupport.firePropertyChange("highlight", null, null);
            }
        }
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 6) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    TableSorter ts = (TableSorter)table.getModel();
                    row = ts.modelIndex(row);
                    DeviceUpgrade du = (DeviceUpgrade)DeviceUpgradeTableModel.this.getRow(row);
                    String starredID = du.getSetupCode() < 0 ? null : du.getStarredID();
                    return super.getTableCellRendererComponent(table, starredID, isSelected, false, row, col);
                }
            };
        }
        if (col == 7) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    TableSorter ts = (TableSorter)table.getModel();
                    row = ts.modelIndex(row);
                    DeviceUpgrade du = (DeviceUpgrade)DeviceUpgradeTableModel.this.getRow(row);
                    Protocol protocol = du.getSetupCode() < 0 ? null : (Protocol)value;
                    String variant = protocol == null ? null : protocol.getVariantDisplayName(DeviceUpgradeTableModel.this.remoteConfig.getRemote().getProcessor());
                    return super.getTableCellRendererComponent(table, variant, isSelected, false, row, col);
                }
            };
        }
        if (col > 9) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        col = this.getEffectiveColumn(col);
        switch (col) {
            case 3: {
                DefaultCellEditor editor = new DefaultCellEditor(this.deviceButtonBox);
                editor.setClickCountToStart(2);
                return editor;
            }
            case 6: 
            case 7: 
            case 8: {
                if (this.remoteConfig != null) {
                    return new ManualSettingsEditor(this.remoteConfig.getRemote(), col);
                }
                return null;
            }
            case 9: {
                return this.descriptionEditor;
            }
            case 10: 
            case 11: {
                return this.colorEditor;
            }
        }
        return null;
    }

    @Override
    public void removeRow(int row) {
        Remote remote;
        DeviceButton db;
        String title;
        String message;
        DeviceUpgrade du = (DeviceUpgrade)this.getRow(row);
        int devTypeIndex = du.getDeviceType().getNumber();
        int setupCode = du.getSetupCode();
        boolean hasLinkedKeyMoves = false;
        for (KeyMove km : this.remoteConfig.getKeyMoves()) {
            if (km.getDeviceType() != devTypeIndex || km.getSetupCode() != setupCode) continue;
            hasLinkedKeyMoves = true;
            break;
        }
        if (hasLinkedKeyMoves && JOptionPane.showConfirmDialog(null, message = "There are key moves that send signals of the device upgrade that you are\ndeleteing.  Do you also want to delete these key moves?", title = "Key Moves of a Device Upgrade", 0, 3) == 0) {
            ListIterator<KeyMove> li = this.remoteConfig.getKeyMoves().listIterator();
            while (li.hasNext()) {
                KeyMove km = li.next();
                if (km.getDeviceType() != devTypeIndex || km.getSetupCode() != setupCode) continue;
                li.remove();
            }
        }
        if ((db = du.getButtonRestriction()) != null && db != DeviceButton.noButton) {
            db.setUpgrade(null);
        }
        if ((remote = this.remoteConfig.getRemote()).usesEZRC()) {
            this.remoteConfig.getDeviceButtonList().remove(db);
            db.setDefaultName();
            Hex hex = new Hex(12);
            short[] data = hex.getData();
            Arrays.fill(data, (short)255);
            data[0] = (short)db.getButtonIndex();
            data[1] = 0;
            if (remote.isSSD()) {
                db.setSegment(null);
            } else {
                db.setSegment(new Segment(0, 255, hex));
            }
        }
        this.checkProtocolRemoval(du, true);
        du.removePropertyChangeListener(this);
        super.removeRow(row);
    }

    public void checkProtocolRemoval(DeviceUpgrade du, boolean isDeletion) {
        Protocol p = du.getProtocol();
        Remote remote = this.remoteConfig.getRemote();
        if (p != null) {
            boolean pidUsed = false;
            boolean pUsed = false;
            for (DeviceUpgrade temp : this.remoteConfig.getDeviceUpgrades()) {
                if (temp.getProtocol() == null) continue;
                if (temp != du && p == temp.getProtocol()) {
                    pUsed = true;
                    pidUsed = true;
                    break;
                }
                if (temp == du || !temp.getProtocol().getID(remote).equals(p.getID(remote))) continue;
                pidUsed = true;
            }
            if (du.needsProtocolCode() && !pidUsed) {
                int confirm = 0;
                if (isDeletion) {
                    if (!this.remoteConfig.hasSegments() || remote.getSegmentTypes().contains(15)) {
                        String title = "Device Upgrade Deletion";
                        String message = "The protocol used by the device upgrade being deleted is a protocol\nupgrade that is not used by any other device upgrade and so will \nnormally also be deleted.  Do you wish to keep the protocol upgrade?";
                        confirm = JOptionPane.showConfirmDialog(null, message, title, 1, 3);
                    } else {
                        confirm = 1;
                    }
                }
                if (confirm == 2) {
                    return;
                }
                if (confirm == 0) {
                    p.saveCode(this.remoteConfig, du.getCode());
                } else if (p instanceof ManualProtocol) {
                    ProtocolManager.getProtocolManager().remove(p);
                }
                p.customCode.clear();
            }
            if (!pUsed) {
                p.removeAltPID(remote);
            }
        }
    }

    @Override
    public void insertRow(int row, DeviceUpgrade upgrade) {
        upgrade.addPropertyChangeListener(this);
        super.insertRow(row, upgrade);
    }

    @Override
    public void addRow(DeviceUpgrade upgrade) {
        upgrade.addPropertyChangeListener(this);
        super.addRow(upgrade);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.fireTableDataChanged();
    }
}

