/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DigitMaps {
    public static short[] data = null;

    public static void load(File file) throws IOException {
        data = new short[(int)file.length()];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        for (int i = 0; i < data.length; ++i) {
            DigitMaps.data[i] = (short)(in.read() & 0xFF);
        }
        in.close();
    }

    public static short findDigitMapIndex(short[] digitMaps, short[] digitKeyCodes) {
        for (int i = 0; i < digitMaps.length; ++i) {
            short mapNum = digitMaps[i];
            if (!DigitMaps.matches(mapNum, digitKeyCodes)) continue;
            return (short)(i + 1);
        }
        return -1;
    }

    public static int findDigitMapNumber(short[] digitKeyCodes) {
        for (int i = 0; i < data.length / 10; ++i) {
            boolean match = true;
            int offset = 10 * i;
            int j = 0;
            while (j < digitKeyCodes.length) {
                if ((data[offset] & 0xFF) != (digitKeyCodes[j] & 0xFF)) {
                    match = false;
                    break;
                }
                ++j;
                ++offset;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(int mapNumber, short[] digitKeyCodes) {
        int offset = 10 * mapNumber;
        int i = 0;
        while (i < digitKeyCodes.length) {
            if (offset >= data.length || (data[offset] & 0xFF) != (digitKeyCodes[i] & 0xFF)) {
                return false;
            }
            ++i;
            ++offset;
        }
        return true;
    }

    public static Hex[] getHexCmds(int mapNumber, int cmdLength) {
        int offset = mapNumber * 10;
        Hex[] rc = new Hex[10];
        int i = 0;
        while (i < rc.length) {
            rc[i] = Hex.subHex(data, offset, cmdLength);
            ++i;
            offset += cmdLength;
        }
        return rc;
    }
}

