/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class DynamicURLClassLoader
extends URLClassLoader {
    protected static DynamicURLClassLoader instance;

    protected DynamicURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public static DynamicURLClassLoader getInstance() {
        if (instance == null) {
            instance = new DynamicURLClassLoader(new URL[0], ClassLoader.getSystemClassLoader());
        }
        return instance;
    }

    public void addURLs(URL url) throws IOException {
        try {
            super.addURL(url);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void addFile(String name) throws IOException {
        this.addFile(new File(name));
    }

    public void addFile(File file) throws IOException {
        this.addURLs(file.toURI().toURL());
    }

    public void addFiles(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        this.addURLs(urls);
    }

    public void addURLs(URL[] urls) throws IOException {
        for (URL url : urls) {
            this.addURLs(url);
        }
    }
}

