/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;

public class EFC
implements Comparable<EFC> {
    protected int value = 0;

    public EFC(String text) {
        this.value = Short.parseShort(text) & 0xFF;
    }

    public EFC(short value) {
        this.value = value & 0xFF;
    }

    public EFC(Hex hex, int index) {
        this.value = EFC.parseHex(hex, index);
    }

    public EFC(Hex hex) {
        this(hex, 0);
    }

    public void fromHex(Hex hex) {
        this.fromHex(hex, 0);
    }

    public void fromHex(Hex hex, int index) {
        this.value = EFC.parseHex(hex.getData()[index]);
    }

    public static int parseHex(Hex hex) {
        return EFC.parseHex(hex, 0);
    }

    public static int parseHex(Hex hex, int index) {
        return EFC.parseHex(hex.getData()[index]);
    }

    public static int parseHex(short hex) {
        short rc = (short)(hex & 0xFF);
        rc = (short)(rc << 3 | rc >> 5);
        rc = (short)((rc ^ 0xAE) - 156);
        return (short)(rc & 0xFF);
    }

    public int getValue() {
        return this.value;
    }

    public Hex toHex(Hex hex, int index) {
        return EFC.toHex(this.value, hex, index);
    }

    public static Hex toHex(int val, Hex hex) {
        return EFC.toHex(val, hex, 0);
    }

    public static Hex toHex(int val, Hex hex, int index) {
        if (hex == null) {
            hex = new Hex(index + 1);
        }
        short temp = (short)(val + 156);
        temp = (short)(temp & 0xFF ^ 0xAE);
        temp = (short)(temp >> 3 | temp << 5);
        hex.getData()[index] = (short)(temp & 0xFF);
        return hex;
    }

    public static Hex toHex(int val) {
        Hex hex = new Hex(1);
        EFC.toHex(val, hex);
        return hex;
    }

    public String toString() {
        return EFC.toString(this.value);
    }

    public static String toString(int efc) {
        StringBuilder buff = new StringBuilder(3);
        if (efc < 100) {
            buff.append('0');
        }
        if (efc < 10) {
            buff.append('0');
        }
        buff.append(Integer.toString(efc));
        return buff.toString();
    }

    @Override
    public int compareTo(EFC efc) {
        int other = efc.value;
        if (this.value < other) {
            return -1;
        }
        if (this.value == other) {
            return 0;
        }
        return 1;
    }
}

