/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.Hex;

public class EFC5
extends EFC {
    public EFC5(String text) {
        super((short)0);
        this.value = Integer.parseInt(text) & 0x1FFFF;
    }

    public EFC5(int value) {
        super((short)value);
        this.value = value & 0x1FFFF;
    }

    public EFC5(Hex hex) {
        this(hex, 0);
    }

    public EFC5(Hex hex, int offset) {
        super((short)0);
        this.value = EFC5.parseHex(hex, offset);
    }

    @Override
    public int getValue() {
        return this.value & 0x1FFFF;
    }

    @Override
    public String toString() {
        return String.format("%1$05d", this.value & 0x1FFFF);
    }

    public Hex toHex(Hex hex) {
        return EFC5.toHex(this.value, hex);
    }

    public static Hex toHex(int val) {
        return EFC5.toHex(val, null);
    }

    public static Hex toHex(int val, Hex hex) {
        short[] data = null;
        if (hex != null) {
            data = hex.getData();
        }
        if (val < 1000) {
            if (hex == null) {
                hex = new Hex(1);
                data = hex.getData();
            }
            int temp = val & 0xFF;
            EFC.toHex(temp, hex, 0);
            if (data.length > 1) {
                data[1] = (short)temp;
            }
        } else {
            if (hex == null) {
                hex = new Hex(2);
                data = hex.getData();
            }
            short byte1 = (short)(val >> 8 & 0xFF);
            byte1 = (short)(byte1 + 100);
            byte1 = (short)(byte1 & 0xFF);
            byte1 = (short)(byte1 << 5 | byte1 >> 3);
            byte1 = (short)(byte1 ^ 0xD5);
            data[0] = (short)(byte1 & 0xFF);
            data[1] = (short)(val & 0xFF ^ 0xC5);
        }
        return hex;
    }

    @Override
    public void fromHex(Hex hex) {
        this.value = EFC5.parseHex(hex) & 0x1FFFF;
    }

    public static int parseHex(Hex hex) {
        return EFC5.parseHex(hex, 0);
    }

    public static int parseHex(Hex hex, int offset) {
        short[] data = hex.getData();
        if (data.length == offset + 2) {
            short byte1 = (short)(data[offset] & 0xFF);
            byte1 = (short)(byte1 ^ 0xD5);
            byte1 = (short)((byte1 >> 5 | byte1 << 3) & 0xFF);
            short byte2 = (short)(data[offset + 1] & 0xFF ^ 0xC5);
            int rc = ((byte1 = (short)(byte1 - 100 & 0xFF)) << 8) + byte2;
            if (rc < 1000) {
                rc += 65536;
            }
            return rc;
        }
        return EFC.parseHex(hex, offset);
    }
}

