/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class EndingFileFilter
extends FileFilter {
    private String description;
    private String[] endings = null;
    private boolean ignoreCase = true;

    public EndingFileFilter(String description, String[] endings) {
        this.description = description;
        this.endings = endings;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fileName = f.getName();
        if (this.ignoreCase) {
            fileName = fileName.toLowerCase();
        }
        for (int i = 0; i < this.endings.length; ++i) {
            String ending = this.endings[i];
            if (this.ignoreCase) {
                ending = ending.toLowerCase();
            }
            if (!fileName.endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getEndings() {
        return this.endings;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

