/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Protocol;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Executor {
    public Protocol protocol = null;
    public ExecutorWrapper wrapper = null;
    public Parameters parms = new Parameters();
    public String name = null;
    public LinkedHashMap<String, List<Integer>> selectorList = new LinkedHashMap();
    public List<int[]> choiceList = new ArrayList<int[]>();
    public List<String> nameList = new ArrayList<String>();
    public String qualifier = null;
    public String sequencer = null;

    public static Selector getSelector(String parm) {
        int ndx = parm.lastIndexOf("?");
        if (ndx < 0) {
            return null;
        }
        String selString = parm.substring(ndx + 1);
        if (selString.indexOf(":") >= 0) {
            return null;
        }
        Selector selector = new Selector();
        Pattern p = Pattern.compile("([0-9]|\\s)*");
        Matcher m = p.matcher(selString);
        if (m.find()) {
            String s = selString.substring(0, m.end()).replaceAll("\\s", "");
            selector.index = Integer.parseInt(s);
        }
        selString = selString.substring(m.end());
        p = Pattern.compile("([0-9A-Z]|\\s)*");
        m = p.matcher(selString);
        if (m.find()) {
            if (m.end() != selString.length()) {
                System.err.println("Warning: the name of the selector " + selString + " includes illegal characters and will be truncated");
            }
            selector.name = selString.substring(0, m.end()).replaceAll("\\s", "");
        }
        return selector;
    }

    public void setSelectors() {
        int[] choices;
        this.selectorList.clear();
        if (this.parms == null || this.parms.devParms == null) {
            return;
        }
        for (String parm : this.parms.devParms) {
            Selector sel = Executor.getSelector(parm);
            if (sel == null) continue;
            String name = sel.name == null ? "null" : sel.name;
            List<Integer> list = this.selectorList.get(name);
            if (list == null) {
                this.selectorList.put(name, new ArrayList());
                list = this.selectorList.get(name);
            }
            if (list.contains(sel.index)) continue;
            list.add(sel.index);
        }
        this.nameList.clear();
        this.choiceList.clear();
        boolean andOthers = false;
        ArrayList<String> givenChoices = new ArrayList<String>();
        if (this.sequencer != null) {
            int ndx = this.sequencer.indexOf("=");
            String nameStr = "";
            String valStr = this.sequencer;
            if (ndx >= 0) {
                nameStr = this.sequencer.substring(0, ndx);
                valStr = this.sequencer.substring(ndx + 1);
            }
            StringTokenizer st1 = null;
            if (!nameStr.isEmpty()) {
                st1 = new StringTokenizer(nameStr, ".");
                while (st1.hasMoreTokens()) {
                    this.nameList.add(st1.nextToken());
                }
            } else {
                this.nameList.add("");
            }
            if ((ndx = valStr.indexOf("..")) >= 0) {
                andOthers = true;
                valStr = valStr.substring(0, ndx);
            }
            st1 = new StringTokenizer(valStr, ",");
            while (st1.hasMoreTokens()) {
                String st1Token = st1.nextToken();
                StringTokenizer st2 = new StringTokenizer(st1Token, ".");
                if (st2.countTokens() != this.nameList.size()) {
                    System.err.println("*** Error: sequencer has invalid syntax");
                    continue;
                }
                if (andOthers) {
                    givenChoices.add(st1Token);
                }
                int n = 0;
                choices = new int[this.nameList.size()];
                while (st2.hasMoreTokens()) {
                    choices[n++] = Integer.valueOf(st2.nextToken());
                }
                this.choiceList.add(choices);
            }
        }
        if (this.sequencer == null || andOthers) {
            if (!andOthers) {
                for (String sn : this.selectorList.keySet()) {
                    this.nameList.add(sn);
                }
            }
            int[] sizes = new int[this.nameList.size()];
            long count = 1L;
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = this.selectorList.get(this.nameList.get(i)).size();
                count *= (long)sizes[i];
            }
            for (long n = 0L; n < count; ++n) {
                long m = n;
                choices = new int[sizes.length];
                for (int i = 0; i < sizes.length; ++i) {
                    choices[i] = (int)(m % (long)sizes[i]);
                    m /= (long)sizes[i];
                }
                String choiceStr = null;
                if (andOthers) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < choices.length; ++i) {
                        if (i > 0) {
                            sb.append(".");
                        }
                        sb.append(choices[i]);
                    }
                    choiceStr = sb.toString();
                }
                if (andOthers && givenChoices.contains(choiceStr)) continue;
                this.choiceList.add(choices);
            }
        }
    }

    public Parameters preprocessParms(int index) {
        Parameters p = new Parameters();
        p.newParms = this.preprocess(this.parms.newParms, index);
        if (this.parms.devParms != null) {
            p.devParms = new ArrayList<String>();
            for (String s : this.parms.devParms) {
                p.devParms.add(this.preprocess(s, index));
            }
        }
        if (this.parms.cmdParms != null) {
            p.cmdParms = new ArrayList<String>();
            for (String s : this.parms.cmdParms) {
                p.cmdParms.add(this.preprocess(s, index));
            }
        }
        return p;
    }

    public String preprocess(String expr, int index) {
        if (expr == null) {
            return null;
        }
        Pattern p1 = Pattern.compile("\\?\\s*\\?\\s*");
        Pattern p2 = Pattern.compile("\\?\\s*\\?\\s*[A-Z]");
        Pattern p3 = Pattern.compile("\\?\\s*\\?([0-9A-Z]|\\s)*");
        Matcher m1 = p1.matcher(expr);
        Matcher m2 = p2.matcher(expr);
        Matcher m3 = p3.matcher(expr);
        int start = 0;
        int end = 0;
        while (m1.find()) {
            String name;
            Integer value;
            start = m1.start();
            end = m1.end();
            if (m2.find()) {
                m3.find();
                end = m3.end();
            }
            if ((value = this.getIndexValue(name = expr.substring(start, end).replaceAll("\\s", "").substring(2), index)) == null) {
                System.err.println("*** Error: Unable to replace indexer question marks");
                return "";
            }
            expr = expr.substring(0, start) + value + expr.substring(end);
            m1 = p1.matcher(expr);
            m2 = p2.matcher(expr);
            m3 = p3.matcher(expr);
        }
        Selector s = Executor.getSelector(expr);
        Integer sValue = null;
        if (s != null && (sValue = this.getIndexValue(s.name, index)) != null) {
            if (this.selectorList.get(s.name) == null || s.index != sValue) {
                return "";
            }
            expr = expr.substring(0, expr.lastIndexOf("?")).trim();
        }
        return expr;
    }

    private Integer getIndexValue(String name, int index) {
        if (index >= this.choiceList.size()) {
            return null;
        }
        List<Integer> vals = this.selectorList.get(name);
        int[] choices = this.choiceList.get(index);
        int nameIndex = this.nameList.indexOf(name);
        if (vals == null || choices == null || nameIndex < 0 || nameIndex >= choices.length) {
            return null;
        }
        return vals.get(choices[nameIndex]);
    }

    public static class ExecutorWrapper {
        private static final String RM_NAMESPACE = "https://sourceforge.net/projects/controlremote/files/RemoteMaster";
        public String protocolName = null;
        public String executorDescriptor = null;
        public String commentItem = null;
        public final Map<String, Expression> assignments;
        public final Map<String, List<String>> translators;

        public BracketData getBrackettedData(int start) {
            int ndx;
            BracketData bracketID;
            String brackets;
            block4: {
                brackets = "()[]{}";
                bracketID = null;
                if (this.executorDescriptor == null || start >= this.executorDescriptor.length()) {
                    return null;
                }
                do {
                    char ch;
                    if ((ndx = brackets.indexOf(ch = this.executorDescriptor.charAt(start))) >= 0 && (ndx & 1) == 0) break block4;
                } while (++start != this.executorDescriptor.length());
                return null;
            }
            bracketID = new BracketData();
            bracketID.type = ndx >> 1;
            bracketID.start = start;
            int count = 0;
            do {
                char ch;
                int ndx2;
                if ((ndx2 = brackets.indexOf(ch = this.executorDescriptor.charAt(start))) >= 0 && ndx2 >> 1 == bracketID.type) {
                    count += 1 - 2 * (ndx2 & 1);
                }
                if (count != 0) continue;
                bracketID.end = start;
                bracketID.text = this.executorDescriptor.substring(bracketID.start + 1, bracketID.end);
                return bracketID;
            } while (++start != this.executorDescriptor.length());
            return null;
        }

        public ExecutorWrapper(String executorDescriptor) {
            this.executorDescriptor = executorDescriptor;
            this.translators = null;
            this.assignments = null;
        }

        private ExecutorWrapper(DocumentFragment fragment) {
            Element e;
            this.assignments = new LinkedHashMap<String, Expression>(4);
            this.translators = new LinkedHashMap<String, List<String>>();
            this.protocolName = null;
            NodeList children = fragment.getChildNodes();
            Element deployment = null;
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1 || !(e = (Element)node).getLocalName().equals("deployment")) continue;
                deployment = e;
                break;
            }
            if (deployment == null) {
                return;
            }
            NodeList assignmentNodes = deployment.getElementsByTagNameNS(RM_NAMESPACE, "assignment");
            for (int i = 0; i < assignmentNodes.getLength(); ++i) {
                e = (Element)assignmentNodes.item(i);
                Expression exp = Expression.newExpression(e.getTextContent());
                String paramName = e.getAttribute("target");
                this.assignments.put(paramName, exp);
            }
            NodeList translatorNodes = deployment.getElementsByTagNameNS(RM_NAMESPACE, "translator");
            for (int i = 0; i < translatorNodes.getLength(); ++i) {
                Element e2 = (Element)translatorNodes.item(i);
                StringTokenizer st = new StringTokenizer(e2.getTextContent(), "=|");
                ArrayList<String> values = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    values.add(st.nextToken().trim());
                }
                String paramName = e2.getAttribute("target");
                this.translators.put(paramName, values);
            }
            this.executorDescriptor = deployment.getAttribute("executor");
            NodeList nl = deployment.getElementsByTagNameNS(RM_NAMESPACE, "protocolName");
            if (nl.getLength() > 0) {
                this.protocolName = nl.item(0).getTextContent();
            }
            if ((nl = deployment.getElementsByTagNameNS(RM_NAMESPACE, "commentItem")).getLength() > 0) {
                this.commentItem = nl.item(0).getTextContent();
            }
        }

        private void fixParameters(NameEngine nameEngine) {
            for (Map.Entry<String, Expression> assgnmnt : this.assignments.entrySet()) {
                try {
                    String paramName = assgnmnt.getKey();
                    long value = assgnmnt.getValue().toLong(nameEngine);
                    nameEngine.define(paramName, value);
                }
                catch (InvalidNameException | NameUnassignedException ex) {
                    System.err.println("*** Error: exception in ExecutorWrapper.fixParameters");
                }
            }
        }

        public Decoder.Decode fixDecode(String protocolName, NamedProtocol namedProtocol, NameEngine nameEngine) throws InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
            if (this.protocolName != null) {
                protocolName = this.protocolName;
            }
            this.fixParameters(nameEngine);
            NamedProtocol np = new NamedProtocol(protocolName, namedProtocol.getIrp(), null);
            Decoder.Decode fixedDecode = new Decoder.Decode(np, nameEngine.toMap(), -1, -1, 0);
            return fixedDecode;
        }

        public static class BracketData {
            public int type = 0;
            public int start = 0;
            public int end = 0;
            public String text = null;
        }
    }

    public static class Parameters {
        public String newParms = null;
        public List<String> devParms = null;
        public List<Integer> devIndices = null;
        public List<String> cmdParms = null;
    }

    public static class Selector {
        public int index = 0;
        public String name = null;

        public boolean equals(Object s) {
            if (s == null || !(s instanceof Selector)) {
                return false;
            }
            Selector sel = (Selector)s;
            return sel.index == this.index && sel.name.equals(this.name);
        }

        public String toString() {
            return this.name + " " + this.index;
        }
    }

    public static class ExecutorWrapperDatabase {
        private final Map<String, List<ExecutorWrapper>> map = new LinkedHashMap<String, List<ExecutorWrapper>>(16);

        private static List<ExecutorWrapper> parseList(List<DocumentFragment> exec) {
            ArrayList<ExecutorWrapper> result = new ArrayList<ExecutorWrapper>(16);
            for (DocumentFragment fragment : exec) {
                result.add(new ExecutorWrapper(fragment));
            }
            return result;
        }

        ExecutorWrapperDatabase(IrpDatabase irpDatabase) {
            for (String protName : irpDatabase.getKeys()) {
                List<ExecutorWrapper> lies;
                List<DocumentFragment> exec = null;
                try {
                    exec = irpDatabase.getXmlProperties(protName, "uei-executor");
                }
                catch (UnknownProtocolException e) {
                    e.printStackTrace();
                }
                if (exec == null || (lies = ExecutorWrapperDatabase.parseList(exec)).isEmpty()) continue;
                this.map.put(protName, lies);
            }
        }

        List<ExecutorWrapper> get(String name) {
            return this.map.get(name.toLowerCase(Locale.US));
        }
    }
}

