/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.FixedData;
import com.hifiremote.jp1.ParameterTokenizer;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.util.List;

public class ExtenderVersionParm
extends RDFParameter {
    private int majorVersionAddr = 0;
    private int minorVersionAddr = 0;
    private ExtenderVersionFormat versionFormat = ExtenderVersionFormat.HEX;
    private FixedData.Location location = FixedData.Location.E2;

    @Override
    public void parse(String text, Remote remote) throws Exception {
        List<String> settings = ParameterTokenizer.getTokens(text);
        if (settings.size() < 2) {
            return;
        }
        if (settings.get(0).equals("E2")) {
            this.location = FixedData.Location.E2;
            settings.remove(0);
        } else if (settings.get(0).equals("SIG")) {
            this.location = FixedData.Location.SIGBLK;
            settings.remove(0);
        }
        if (settings.size() < 2) {
            return;
        }
        this.majorVersionAddr = RDFReader.parseNumber(settings.get(0));
        if (settings.get(1).equalsIgnoreCase("Asc")) {
            this.versionFormat = ExtenderVersionFormat.ASC;
        }
        if (settings.size() > 2) {
            this.minorVersionAddr = RDFReader.parseNumber(settings.get(2));
        }
    }

    public boolean displayExtenderVersion() {
        return this.majorVersionAddr > 0;
    }

    public String getExtenderVersion(RemoteConfiguration remoteConfig) {
        short[] data = this.location == FixedData.Location.E2 ? remoteConfig.getData() : remoteConfig.getSigData();
        int majorVersionByte = -1;
        int minorVersionByte = -1;
        String version = null;
        if (data == null || this.majorVersionAddr >= data.length) {
            return "<unknown>";
        }
        majorVersionByte = data[this.majorVersionAddr];
        if (this.minorVersionAddr > 0 && this.minorVersionAddr < data.length) {
            minorVersionByte = data[this.minorVersionAddr];
        }
        if (this.versionFormat == ExtenderVersionFormat.ASC) {
            version = Character.toString((char)majorVersionByte);
            if (minorVersionByte >= 0) {
                version = version + Integer.toString(minorVersionByte);
            }
        } else {
            version = Integer.toString(majorVersionByte);
            if (minorVersionByte >= 0) {
                version = version + String.format(".%02d", minorVersionByte);
            }
        }
        return version;
    }

    public static enum ExtenderVersionFormat {
        HEX,
        ASC;

    }
}

