/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import java.util.Properties;

public class ExternalFunction
extends Function {
    public static final int EFCType = 0;
    public static final int EFC5Type = 2;
    public static final int HexType = 1;
    private String deviceTypeAliasName;
    private int setupCode;
    private int type;

    public ExternalFunction() {
    }

    public ExternalFunction(ExternalFunction base) {
        super(base);
        this.deviceTypeAliasName = base.deviceTypeAliasName;
        this.type = base.type;
        this.setupCode = base.setupCode;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.deviceTypeAliasName == null && this.setupCode == 0 && this.type == 0;
    }

    @Override
    public void store(PropertyWriter out, String prefix) {
        super.store(out, prefix);
        out.print(prefix + ".type", Integer.toString(this.type));
        if (this.deviceTypeAliasName != null) {
            out.print(prefix + ".deviceType", this.deviceTypeAliasName);
        }
        out.print(prefix + ".setupCode", Integer.toString(this.setupCode));
    }

    public void load(Properties props, String prefix, Remote remote) {
        super.load(props, prefix);
        String str = props.getProperty(prefix + ".type");
        if (str != null) {
            this.setType(new Integer(str));
        }
        if ((str = props.getProperty(prefix + ".deviceType")) != null) {
            for (String name : remote.getDeviceTypeAliasNames()) {
                if (!name.equalsIgnoreCase(str)) continue;
                this.setDeviceTypeAliasName(name);
                break;
            }
        }
        if ((str = props.getProperty(prefix + ".setupCode")) != null) {
            this.setSetupCode(Integer.parseInt(str));
        }
    }

    public String getDeviceTypeAliasName() {
        return this.deviceTypeAliasName;
    }

    public void setDeviceTypeAliasName(String name) {
        this.deviceTypeAliasName = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(Integer type) {
        this.setType((int)type);
    }

    public int get_Type() {
        return this.type;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setHex(null);
        } else if (this.type == 0) {
            this.setEFC((EFC)value);
        } else if (this.type == 2) {
            this.setEFC5((EFC5)value);
        } else {
            this.setHex((Hex)value);
        }
    }

    public Object getValue() {
        if (this.type == 0) {
            return this.getEFC();
        }
        if (this.type == 2) {
            return this.getEFC5();
        }
        return this.getHex();
    }

    public void setSetupCode(int code) {
        this.setupCode = code;
    }

    public int getSetupCode() {
        return this.setupCode;
    }

    public EFC getEFC() {
        EFC rc = null;
        if (this.data != null) {
            rc = new EFC(this.data, 0);
        }
        return rc;
    }

    public EFC5 getEFC5() {
        EFC5 rc = null;
        if (this.data != null) {
            rc = new EFC5(this.data, 0);
        }
        return rc;
    }

    public void setEFC(EFC efc) {
        this.data = efc != null ? efc.toHex(null, 0) : null;
    }

    public void setEFC5(EFC5 efc) {
        this.data = efc != null ? efc.toHex(null) : null;
    }
}

