/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ExternalFunctionEditor
extends SelectAllCellEditor {
    private int min;
    private int max;
    private ExternalFunction f;

    public ExternalFunctionEditor() {
        ((JTextField)this.getComponent()).setHorizontalAlignment(2);
        this.min = 0;
        this.max = 255;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.f = (ExternalFunction)value;
        JTextField tf = (JTextField)super.getTableCellEditorComponent(table, this.f.getValue(), isSelected, row, col);
        return tf;
    }

    @Override
    public Object getCellEditorValue() throws NumberFormatException {
        ExternalFunction rc = this.f;
        JTextField tf = (JTextField)this.getComponent();
        String str = tf.getText().trim();
        if (str != null && str.length() != 0) {
            if (this.f.get_Type() == 0) {
                short temp = Short.parseShort(str);
                if (temp < this.min || temp > this.max) {
                    String msg = "Value entered must be between " + this.min + " and " + this.max + '.';
                    JP1Frame.showMessage(msg, tf);
                    throw new NumberFormatException(msg);
                }
                JP1Frame.clearMessage(tf);
                this.f.setEFC(new EFC(temp));
            } else if (this.f.get_Type() == 2) {
                int temp = Integer.parseInt(str);
                if (temp >= 65792) {
                    String msg = "Value entered must be less than 65792.";
                    JP1Frame.showMessage(msg, tf);
                    throw new NumberFormatException(msg);
                }
                JP1Frame.clearMessage(tf);
                this.f.setEFC5(new EFC5(temp));
            } else {
                this.f.setHex(new Hex(str));
            }
        } else {
            this.f.setHex(null);
        }
        JP1Frame.clearMessage(tf);
        return rc;
    }
}

