/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.ExternalFunctionTableModel;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionImportDialog;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.TablePanel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;

public class ExternalFunctionPanel
extends TablePanel<ExternalFunction> {
    private JMenuItem importItem = new JMenuItem("Import");
    private JButton importButton = null;

    public ExternalFunctionPanel(DeviceUpgrade devUpgrade) {
        super("External Functions", devUpgrade, new ExternalFunctionTableModel(devUpgrade));
        this.importItem.setToolTipText("Import function(s) from an existing device upgrade.");
        this.importItem.addActionListener(this);
        this.popup.add(this.importItem);
        this.importButton = new JButton("Import");
        this.importButton.addActionListener(this);
        this.importButton.setToolTipText("Import function(s) from an existing device upgrade.");
        this.buttonPanel.add(this.importButton);
        this.initColumns();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.importItem || source == this.importButton) {
            File file = KeyMapMaster.promptForUpgradeFile(null);
            DeviceUpgrade importedUpgrade = new DeviceUpgrade();
            importedUpgrade.setSkipProtocol(true);
            try {
                List<Function> importedFunctions;
                importedUpgrade.load(file);
                FunctionImportDialog d = new FunctionImportDialog(null, importedUpgrade);
                d.setVisible(true);
                if (d.getUserAction() == 0 && (importedFunctions = d.getSelectedFunctions()).size() > 0) {
                    List<ExternalFunction> externalFunctions = this.deviceUpgrade.getExternalFunctions();
                    int firstRow = externalFunctions.size();
                    for (Function f : importedFunctions) {
                        ExternalFunction ef = null;
                        if (f.isExternal()) {
                            ef = (ExternalFunction)f;
                        } else {
                            ef = new ExternalFunction();
                            ef.setName(f.getName());
                            int digits = this.deviceUpgrade.getRemote().getEFCDigits();
                            Hex hex = f.getHex();
                            ef.setHex(hex);
                            if (hex.length() == 1 && digits == 3) {
                                ef.setType(0);
                            } else if (hex.length() <= 2 && digits == 5) {
                                ef.setType(2);
                            } else {
                                ef.setType(1);
                            }
                            ef.setSetupCode(importedUpgrade.getSetupCode());
                            ef.setDeviceTypeAliasName(importedUpgrade.getDeviceTypeAliasName());
                            ef.setNotes(f.getNotes());
                        }
                        externalFunctions.add(ef);
                    }
                    this.model.fireTableRowsInserted(firstRow, externalFunctions.size() - 1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        super.actionPerformed(event);
    }

    @Override
    public void update() {
        ((ExternalFunctionTableModel)this.model).update();
        super.update();
    }

    @Override
    protected ExternalFunction createRowObject() {
        ExternalFunction f = new ExternalFunction();
        f.setType(((ExternalFunctionTableModel)this.model).remoteUsesEFC5() ? 2 : 0);
        return f;
    }

    @Override
    protected boolean canDelete(ExternalFunction f) {
        return !f.assigned();
    }

    @Override
    protected void delete(ExternalFunction f) {
        ArrayList<GeneralFunction.User> users = new ArrayList<GeneralFunction.User>(f.getUsers());
        for (GeneralFunction.User user : users) {
            this.deviceUpgrade.setFunction(user.button, null, user.state);
        }
    }
}

