/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ByteEditor;
import com.hifiremote.jp1.ByteRenderer;
import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceEditor;
import com.hifiremote.jp1.ChoiceRenderer;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.ExternalFunctionEditor;
import com.hifiremote.jp1.ExternalFunctionRenderer;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KMTableModel;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SetupCode;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ExternalFunctionTableModel
extends KMTableModel<ExternalFunction> {
    private static final int rowCol = 0;
    private static final int nameCol = 1;
    private static final int devTypeCol = 2;
    private static final int setupCodeCol = 3;
    private static final int typeCol = 4;
    private static final int hexCol = 5;
    private static final int notesCol = 6;
    private static final String[] names = new String[]{"#", "Name", "Device Type", "Setup Code", "Type", "EFC/Hex", "Notes"};
    private static final String[] prototypeNames = new String[]{" # ", "Function Name", "Device Type", "Setup Code", "Type", "EFC/Hex", "A reasonanble comment"};
    private static final Class<?>[] classes = new Class[]{Integer.class, String.class, String.class, Integer.class, Choice.class, ExternalFunction.class, String.class};
    private Choice[] choices = new Choice[]{new Choice(0, "EFC"), new Choice(1, "Hex")};
    private boolean usesEFC5 = false;

    public ExternalFunctionTableModel(DeviceUpgrade upgrade) {
        super(upgrade.getExternalFunctions());
        boolean bl = this.usesEFC5 = upgrade.getRemote().getEFCDigits() == 5;
        if (this.usesEFC5) {
            this.choices[0] = new Choice(2, "EFC5");
        }
    }

    public boolean remoteUsesEFC5() {
        return this.usesEFC5;
    }

    public void update() {
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ExternalFunction function = (ExternalFunction)this.getRow(row);
        Object rc = null;
        switch (col) {
            case 0: {
                rc = new Integer(row + 1);
                break;
            }
            case 1: {
                rc = function.getName();
                break;
            }
            case 2: {
                rc = function.getDeviceTypeAliasName();
                break;
            }
            case 3: {
                rc = new Integer(function.getSetupCode());
                break;
            }
            case 4: {
                rc = this.choices[function.get_Type() & 1];
                break;
            }
            case 5: {
                rc = function;
                break;
            }
            case 6: {
                rc = function.getNotes();
                break;
            }
        }
        return rc;
    }

    public void checkFunctionAssigned(Function f, Object value) throws IllegalArgumentException {
        if (value == null && f.assigned()) {
            String msg = "Function " + f.getName() + " is assigned to a button, and must not be cleared!";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ExternalFunction function = (ExternalFunction)this.getRow(row);
        switch (col) {
            case 1: {
                function.setName((String)value);
                break;
            }
            case 2: {
                function.setDeviceTypeAliasName((String)value);
                break;
            }
            case 3: {
                if (value.getClass() == String.class) {
                    value = new Integer((String)value);
                }
                function.setSetupCode((Integer)value);
                break;
            }
            case 4: {
                if (value.getClass() == String.class) {
                    String str = (String)value;
                    for (int i = 0; i < this.choices.length; ++i) {
                        if (!str.equals(this.choices[i].getText())) continue;
                        value = this.choices[i];
                        break;
                    }
                }
                function.setType(((Choice)value).getIndex());
                break;
            }
            case 5: {
                if (value.getClass() != String.class) break;
                String str = (String)value;
                if (function.get_Type() == 0) {
                    function.setEFC(new EFC(str));
                    break;
                }
                if (function.get_Type() == 2) {
                    function.setEFC5(new EFC5(str));
                    break;
                }
                function.setHex(new Hex(str));
                break;
            }
            case 6: {
                function.setNotes((String)value);
                break;
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        DefaultCellEditor rc = null;
        switch (col) {
            case 1: {
                break;
            }
            case 2: {
                rc = new DefaultCellEditor(new JComboBox<String>(DeviceUpgrade.getDeviceTypeAliasNames()));
                break;
            }
            case 3: {
                rc = new ByteEditor(0, SetupCode.getMax(), null);
                break;
            }
            case 4: {
                rc = new ChoiceEditor(this.choices, false);
                break;
            }
            case 5: {
                rc = new ExternalFunctionEditor();
                break;
            }
            case 6: {
                break;
            }
        }
        return rc;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        DefaultTableCellRenderer rc = null;
        switch (col) {
            case 0: {
                rc = new RowNumberRenderer();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                rc = new ByteRenderer();
                break;
            }
            case 4: {
                rc = new ChoiceRenderer(this.choices);
                break;
            }
            case 5: {
                rc = new ExternalFunctionRenderer();
                break;
            }
            case 6: {
                break;
            }
        }
        return rc;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 5 && this.usesEFC5) {
            return "EFC5/Hex";
        }
        return names[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return prototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return classes[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean rc = true;
        if (col == 0) {
            rc = false;
        }
        return rc;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col != 1 && col != 5 && col != 6;
    }
}

