/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.CommandSet;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExternalSignal
implements GeneralSignal {
    public static org.harctoolbox.girr.Remote remote = null;
    private ArrayList<LearnedSignalDecode> decodes = null;
    private LearnedSignalDecode preferredLSDecode = null;
    private String signalName = null;
    private String error = null;
    private String notes = null;

    public static ExternalSignal[] loadExternalFile(File file, Component owner) {
        remote = null;
        if (file == null) {
            return null;
        }
        JP1Frame.preferences.setExternalFilePath(file.getAbsoluteFile().getParentFile());
        try {
            System.err.println("Opening " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filename = file.getName();
        if (RemoteMaster.hasEnding(filename, new String[][]{RemoteMaster.girrEndings})) {
            return ExternalSignal.loadGirrFile(file, owner);
        }
        if (RemoteMaster.hasEnding(filename, new String[][]{RemoteMaster.ictEndings})) {
            return ExternalSignal.loadIctFile(file);
        }
        return null;
    }

    public static RMFileChooser getExternalFileChooser(boolean forImport, boolean girrOnly, boolean ictOnly) {
        File dir;
        RMFileChooser chooser = new RMFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        EndingFileFilter importFilter = new EndingFileFilter("All import files", RemoteMaster.upgradeImportEndings);
        EndingFileFilter girrFilter = new EndingFileFilter("Girr files (*.girr)", RemoteMaster.girrEndings);
        EndingFileFilter ictFilter = new EndingFileFilter("IRScope files (*.ict)", RemoteMaster.ictEndings);
        if (girrOnly) {
            forImport = false;
        }
        if (forImport && !ictOnly) {
            chooser.addChoosableFileFilter(importFilter);
        }
        if (!ictOnly) {
            chooser.addChoosableFileFilter(girrFilter);
        }
        if (!girrOnly) {
            chooser.addChoosableFileFilter(ictFilter);
        }
        chooser.setFileFilter(forImport ? (ictOnly ? ictFilter : importFilter) : girrFilter);
        if (!forImport) {
            chooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    RMIRSetup.fileFilterChangeEvent(event);
                }
            });
        }
        if ((dir = JP1Frame.getProperties().getFileProperty("GirrImportPath")) != null) {
            JP1Frame.getProperties().remove("GirrImportPath");
            JP1Frame.getPreferences().setExternalFilePath(dir);
        }
        if ((dir = JP1Frame.getPreferences().getExternalFilePath()) != null) {
            chooser.setCurrentDirectory(dir);
        }
        return chooser;
    }

    public static File selectExternalFile(Component owner, boolean ictOnly) {
        File file;
        block3: {
            System.err.println("ExternalSignal.selectExternalFile()");
            file = null;
            RMFileChooser chooser = ExternalSignal.getExternalFileChooser(true, false, ictOnly);
            while (chooser.showOpenDialog(owner) == 0) {
                file = chooser.getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(owner, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
                    continue;
                }
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(owner, file.getName() + " is a directory.", "File doesn't exist.", 0);
                    continue;
                }
                break block3;
            }
            return null;
        }
        return file;
    }

    public static ExternalSignal[] loadGirrFile(File file, Component owner) {
        try {
            org.harctoolbox.girr.Remote remote = null;
            Element root = XmlUtils.openXmlFile(file).getDocumentElement();
            switch (root.getLocalName()) {
                case "remotes": {
                    RemoteSet set = new RemoteSet(root, file.toString());
                    if (set.getRemotes().size() == 0) {
                        JOptionPane.showMessageDialog(owner, "There are no Girr Remotes in this file", "Girr file reader", 0);
                        return null;
                    }
                    ArrayList<String> remoteNames = new ArrayList<String>();
                    for (org.harctoolbox.girr.Remote rem : set.getRemotes()) {
                        remoteNames.add(rem.getName());
                    }
                    Object[] selection = remoteNames.toArray(new String[0]);
                    String result = selection[0];
                    if (selection.length > 1) {
                        result = (String)JOptionPane.showInputDialog(owner, "There is more than one Girr Remote in this file.  Please choose the one to import.", "Girr file reader", 3, null, selection, selection[0]);
                    }
                    if (result == null) {
                        return null;
                    }
                    remote = set.getRemote(result);
                    break;
                }
                case "remote": {
                    remote = new org.harctoolbox.girr.Remote(root, file.toString());
                    break;
                }
                case "commandSet": {
                    CommandSet cmdSet = new CommandSet(root);
                    remote = new org.harctoolbox.girr.Remote(cmdSet);
                    remote.setName(file.getName());
                    remote.setNotes("Imported from " + file.toString());
                    break;
                }
                case "command": {
                    Command command = new Command(root);
                    CommandSet cmdSet = new CommandSet(command);
                    remote = new org.harctoolbox.girr.Remote(cmdSet);
                    remote.setName(file.getName());
                    remote.setNotes("Imported from " + file.toString());
                    break;
                }
                default: {
                    throw new GirrException("Invalid root element \"" + root.getTagName() + "\" in " + file.toString());
                }
            }
            ExternalSignal.remote = remote;
            System.err.println("Importing Girr remote named " + remote.getName());
            ArrayList<ExternalSignal> esList = new ArrayList<ExternalSignal>();
            for (CommandSet commandSet : remote) {
                for (Command cmd : commandSet) {
                    ExternalSignal es = ExternalSignal.getExternalSignal(cmd);
                    esList.add(es);
                }
            }
            return esList.toArray(new ExternalSignal[0]);
        }
        catch (IOException | GirrException | SAXException e) {
            JOptionPane.showMessageDialog(owner, e.getMessage(), "Girr file reader", 0);
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExternalSignal getExternalSignal(Command cmd) {
        ExternalSignal es = new ExternalSignal();
        es.setNotes(cmd.getComment());
        Decoder.Decode decode = null;
        try {
            String cmdName;
            es.signalName = cmdName = cmd.getName();
            cmd.checkForParameters();
            if (cmd.getProtocolName() == null) {
                System.err.println("Unable to decode command named " + cmdName);
                es.setError("Unable to decode");
                return es;
            }
            Map<String, Long> parms = new LinkedHashMap<String, Long>(cmd.getParameters());
            LearnedSignal.getTmDecoder();
            NamedProtocol np = LearnedSignal.getTmDatabase().getNamedProtocol(cmd.getProtocolName());
            List<List<String>> paramNames = DeviceUpgradeExporter.getParamNames(np);
            if (paramNames.size() == 2) {
                for (String name : paramNames.get(1)) {
                    if (parms.keySet().contains(name)) continue;
                    parms.put(name, -1L);
                }
            }
            parms = np.fillInDefaults(parms);
            decode = new Decoder.Decode(np, parms, 0, 0, 0);
            LearnedSignalDecode lsd = new LearnedSignalDecode(decode);
            es.decodes = new ArrayList();
            es.decodes.add(lsd);
        }
        catch (IrCoreException | IrpException e) {
            e.printStackTrace();
        }
        return es;
    }

    public static ExternalSignal[] loadIctFile(File file) {
        Collection<Command> coll = null;
        coll = DeviceUpgradeConverter.ictImporter(file);
        if (coll == null) {
            return null;
        }
        ArrayList<ExternalSignal> esList = new ArrayList<ExternalSignal>();
        Decoder decoder = LearnedSignal.getTmDecoder();
        Decoder.DecoderParameters dp = LearnedSignal.getTmDecoderParams();
        dp.setRecursive(true);
        for (Command cmd : coll) {
            try {
                IrSignal signal = cmd.toIrSignal();
                String name = cmd.getName() == null ? "" : cmd.getName();
                ModulatedIrSequence seq = signal.getIntroSequence();
                Decoder.DecodeTree tree = decoder.decode(seq, dp);
                ArrayList<Decoder.Decode> dList = new ArrayList<Decoder.Decode>();
                while (tree.size() > 0) {
                    Decoder.TrunkDecodeTree tdt = (Decoder.TrunkDecodeTree)tree.first();
                    dList.add(tdt.getTrunk());
                    tree.remove(tdt);
                    for (Decoder.TrunkDecodeTree t : tdt.getRest()) {
                        tree.add(t);
                    }
                }
                int n = 0;
                for (Decoder.Decode decode : dList) {
                    ExternalSignal es = new ExternalSignal();
                    LearnedSignalDecode lsd = new LearnedSignalDecode(decode);
                    es.decodes = new ArrayList();
                    es.decodes.add(lsd);
                    es.signalName = name.isEmpty() ? "_" + n++ : name;
                    esList.add(es);
                }
            }
            catch (IrCoreException | IrpException e) {
                e.printStackTrace();
            }
        }
        dp.setRecursive(false);
        return esList.toArray(new ExternalSignal[0]);
    }

    @Override
    public void setPreferredLSDecode(LearnedSignalDecode preferredLSDecode) {
        this.preferredLSDecode = preferredLSDecode;
    }

    @Override
    public LearnedSignalDecode getPreferredLSDecode() {
        return this.preferredLSDecode;
    }

    @Override
    public String getSignalName(Remote remote) {
        return this.signalName;
    }

    @Override
    public ArrayList<LearnedSignalDecode> getDecodes() {
        return this.decodes;
    }

    @Override
    public Integer getIKeyCode() {
        return null;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
}

