/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.List;
import java.util.StringTokenizer;

public class FavKey
extends RDFParameter {
    private int keyCode = 0;
    private int deviceButtonAddress = 0;
    private int maxEntries = -1;
    private int entrySize = -1;
    private boolean segregated = false;
    private Activity activity = null;
    private int favPause = 0;
    private List<Activity> profiles = null;

    @Override
    public void parse(String text, Remote remote) throws Exception {
        StringTokenizer st = new StringTokenizer(text, "=, \t");
        this.keyCode = RDFReader.parseNumber(st.nextToken());
        this.deviceButtonAddress = RDFReader.parseNumber(st.nextToken());
        this.maxEntries = RDFReader.parseNumber(st.nextToken());
        this.entrySize = RDFReader.parseNumber(st.nextToken());
        if (st.hasMoreTokens()) {
            boolean bl = this.segregated = RDFReader.parseNumber(st.nextToken()) != 0;
            if (this.segregated) {
                AddressRange favScanAddr = new AddressRange();
                favScanAddr.setStart(this.deviceButtonAddress - 1);
                favScanAddr.setEnd(this.deviceButtonAddress + this.maxEntries * this.entrySize);
                remote.setFavScanAddress(favScanAddr);
            }
        }
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getDeviceButtonAddress() {
        return this.deviceButtonAddress;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getEntrySize() {
        return this.entrySize;
    }

    public boolean isSegregated() {
        return this.segregated;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder(25);
        temp.append('$').append(Integer.toHexString(this.keyCode)).append(", $").append(Integer.toHexString(this.deviceButtonAddress)).append(", ").append(this.maxEntries).append(", ").append(this.entrySize);
        if (this.segregated) {
            temp.append(", 1");
        }
        return temp.toString();
    }

    public List<Activity> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Activity> profiles) {
        this.profiles = profiles;
    }

    public Activity createProfile(String name, int profileIndex, Remote remote) {
        Button btn = remote.getButton(this.keyCode);
        Activity activity = new Activity(btn, remote);
        activity.setName(name);
        activity.setProfileIndex(profileIndex);
        activity.icon = new GeneralFunction.RMIcon(8);
        this.profiles.add(activity);
        return activity;
    }

    public Activity getProfileByIndex(int profileIndex) {
        for (Activity a : this.profiles) {
            if (a.getProfileIndex() != profileIndex) continue;
            return a;
        }
        return null;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public int getFavPause() {
        return this.favPause;
    }

    public void setFavPause(int favPause) {
        this.favPause = favPause;
    }
}

