/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavKey;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexReader;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FavScan
extends AdvancedCode {
    private DeviceButton deviceButton = null;
    private int deviceIndex = -1;
    private List<Integer> profileIndices = null;
    private String channel = "";

    public FavScan(int keyCode, Hex data, String notes) {
        super(keyCode, data, notes);
    }

    public FavScan(Properties props) {
        super(props);
        String temp = props.getProperty("Channel");
        if (temp != null) {
            this.channel = temp.replace(':', '.');
        }
        this.deviceIndex = (temp = props.getProperty("DeviceIndex")) != null ? Integer.parseInt(temp) : -1;
        temp = props.getProperty("Serial");
        if (temp != null) {
            this.serial = Integer.parseInt(temp);
        }
        if ((temp = props.getProperty("ProfileIndices")) != null) {
            StringTokenizer st = new StringTokenizer(temp, " ");
            this.profileIndices = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.profileIndices.add(Integer.parseInt(token, 16));
            }
        }
    }

    public FavScan(FavScan favScan) {
        super(favScan.getKeyCode(), new Hex(favScan.getData()), favScan.getNotes());
        this.deviceButton = favScan.getDeviceButton();
        this.name = favScan.getName();
        this.icon = favScan.icon;
        this.channel = favScan.channel;
    }

    public static FavScan read(HexReader reader, Remote remote) {
        if (reader.available() < 4 || reader.peek() == remote.getSectionTerminator()) {
            return null;
        }
        FavKey favKey = remote.getFavKey();
        int keyCode = favKey.getKeyCode();
        int length = reader.read();
        length *= favKey.getEntrySize();
        int deviceIndex = reader.read();
        if ((deviceIndex &= 0xF) == 15) {
            deviceIndex = -1;
        }
        Hex hex = new Hex(reader.read(length));
        FavScan favScan = new FavScan(keyCode, hex, null);
        favScan.setDeviceIndex(deviceIndex);
        return favScan;
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] keys = this.data.getData();
        int entrySize = remote.getFavKey().getEntrySize();
        boolean paused = false;
        for (int i = 0; i < keys.length; ++i) {
            if (i != 0) {
                buff.append(';');
            }
            if (paused) {
                buff.append(' ');
                paused = false;
            }
            if (keys[i] != 0) {
                buff.append(remote.getButtonName(keys[i]));
            }
            if (entrySize < 0 || keys[i] != 0 && (i + 1) % entrySize != 0) continue;
            while (i < keys.length && (keys[i] == 0 || i % entrySize != 0)) {
                ++i;
            }
            if (keys[--i] != 0) {
                buff.append(';');
            }
            buff.append("{Pause}");
            paused = true;
        }
        return buff.toString();
    }

    @Override
    public int store(short[] buffer, int offset, Remote remote) {
        FavKey favKey = remote.getFavKey();
        int dataLength = this.data.length();
        if (favKey.isSegregated()) {
            buffer[offset++] = (short)(dataLength / favKey.getEntrySize());
            ++offset;
        } else if (remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
            buffer[offset++] = (short)favKey.getKeyCode();
            buffer[offset++] = (short)(0x30 | dataLength / favKey.getEntrySize());
        } else {
            buffer[offset++] = (short)favKey.getKeyCode();
            int buttonIndex = this.deviceButton.getButtonIndex();
            if (buttonIndex == -1) {
                buttonIndex = 15;
            }
            buffer[offset++] = (short)(0x30 | buttonIndex & 0xF);
            buffer[offset++] = (short)dataLength;
        }
        Hex.put(this.data, buffer, offset);
        return offset + dataLength;
    }

    public void store(PropertyWriter pw, RemoteConfiguration remoteConfig) {
        Remote remote;
        DeviceButton devBtn;
        super.store(pw);
        if (this.channel != null && this.channel.length() > 0) {
            pw.print("Channel", this.channel);
        }
        DeviceButton deviceButton = devBtn = (remote = remoteConfig.getRemote()).getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL ? remoteConfig.getFavKeyDevButton() : this.getDeviceButton();
        if (devBtn != DeviceButton.noButton) {
            pw.print("DeviceIndex", devBtn.getButtonIndex());
        }
        if (this.serial >= 0) {
            pw.print("Serial", this.serial);
        }
        if (this.profileIndices != null) {
            String str = "";
            for (int i = 0; i < this.profileIndices.size(); ++i) {
                if (i > 0) {
                    str = str + " ";
                }
                str = str + this.profileIndices.get(i);
            }
            pw.print("ProfileIndices", str);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public DeviceButton getDeviceButton() {
        return this.deviceButton;
    }

    public void setDeviceButton(DeviceButton deviceButton) {
        this.deviceButton = deviceButton;
    }

    public void setDeviceIndex(int deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public DeviceButton getDeviceButtonFromIndex(Remote remote) {
        if (this.deviceIndex == -1) {
            return DeviceButton.noButton;
        }
        return remote.getDeviceButton(this.deviceIndex);
    }

    public List<Integer> getProfileIndices() {
        return this.profileIndices;
    }

    public void setProfileIndices(List<Integer> profileIndices) {
        this.profileIndices = profileIndices;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }
}

