/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavKey;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.FavScanButtonRenderer;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FavScanDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static FavScanDialog dialog = null;
    private JList macroButtons = new JList();
    private JButton moveUp = new JButton("Move up");
    private JButton moveDown = new JButton("Move down");
    private JButton remove = new JButton("Remove");
    private JButton clear = new JButton("Clear");
    private JButton deselect = new JButton("Clear selection");
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JList availableButtons = new JList();
    private JButton add = new JButton("Add");
    private JButton insert = new JButton("Insert");
    private JButton addShift = new JButton("Add Shift");
    private JButton insertShift = new JButton("Ins Shift");
    private JButton addXShift = new JButton("Add xShift");
    private JButton insertXShift = new JButton("Ins xShift");
    private JButton addPause = new JButton("Add Pause");
    private JButton insertPause = new JButton("Ins Pause");
    private JLabel keysBoxLabel = new JLabel();
    private FavScanButtonRenderer favScanButtonRenderer = new FavScanButtonRenderer();
    private DefaultListModel macroButtonModel = new DefaultListModel();
    private JTextArea notes = new JTextArea(2, 10);
    private RemoteConfiguration config = null;
    private FavKey favKey = null;
    private FavScan favScan;
    private DeviceButton deviceButton;
    private String name = null;
    private JPanel topPanel = null;
    private JPanel grid1 = null;
    private JPanel grid2 = null;
    private JPanel grid3 = null;
    private JPanel grid4 = null;
    private JTextField nameField = null;

    public FavScanDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Fav/Scan");
        this.setModal(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.topPanel = new JPanel(new FlowLayout(0));
        this.topPanel.add(new JLabel("Name: "));
        this.nameField = new JTextField(30);
        this.topPanel.add(this.nameField);
        contentPane.add((Component)this.topPanel, "First");
        Box macroBox = Box.createHorizontalBox();
        macroBox.setBorder(BorderFactory.createTitledBorder("Definition"));
        contentPane.add((Component)macroBox, "Center");
        JPanel availableBox = new JPanel(new BorderLayout());
        macroBox.add(availableBox);
        availableBox.add((Component)new JLabel("Available keys:"), "North");
        this.availableButtons.setFixedCellWidth(100);
        availableBox.add((Component)new JScrollPane(this.availableButtons), "Center");
        this.availableButtons.setSelectionMode(0);
        this.availableButtons.addListSelectionListener(this);
        this.availableButtons.setToolTipText(JTableX.getHtmlToolTip("Double-click to add/insert.<br>Shift/double-click to add/insert shifted.<br>This will insert if a macro key is selected, add otherwise.<br>Right-click (either box) to clear macro key selection."));
        int h = (int)(this.moveDown.getPreferredSize().getHeight() + 0.5);
        this.grid1 = new JPanel(new GridLayout(2, 2, 2, 2));
        this.grid2 = new JPanel(new GridLayout(2, 2, 2, 2));
        this.grid3 = new JPanel(new GridLayout(1, 2, 2, 2));
        this.grid3.add(Box.createVerticalStrut(h));
        JPanel panel = new JPanel(new BorderLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        bottomPanel.add((Component)this.grid2, "First");
        bottomPanel.add((Component)this.grid3, "Last");
        panel.add((Component)this.grid1, "First");
        panel.add((Component)bottomPanel, "Last");
        availableBox.add((Component)panel, "South");
        this.add.addActionListener(this);
        this.grid1.add(this.add);
        this.insert.addActionListener(this);
        this.grid1.add(this.insert);
        this.addShift.addActionListener(this);
        this.grid1.add(this.addShift);
        this.insertShift.addActionListener(this);
        this.grid1.add(this.insertShift);
        this.addXShift.addActionListener(this);
        this.grid2.add(this.addXShift);
        this.insertXShift.addActionListener(this);
        this.grid2.add(this.insertXShift);
        this.addPause.addActionListener(this);
        this.grid2.add(this.addPause);
        this.insertPause.addActionListener(this);
        this.grid2.add(this.insertPause);
        macroBox.add(Box.createHorizontalStrut(20));
        JPanel keysBox = new JPanel(new BorderLayout());
        macroBox.add(keysBox);
        keysBox.add((Component)this.keysBoxLabel, "North");
        this.macroButtons.setFixedCellWidth(100);
        keysBox.add((Component)new JScrollPane(this.macroButtons), "Center");
        this.macroButtons.setModel(this.macroButtonModel);
        this.macroButtons.setSelectionMode(0);
        this.macroButtons.setCellRenderer(this.favScanButtonRenderer);
        this.macroButtons.addListSelectionListener(this);
        double b = 2.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size2 = new double[][]{{pf, b, pf}, {pr, b, pr, b, pr}};
        JPanel buttonBox = new JPanel(new BorderLayout());
        panel = new JPanel(new TableLayout(size2));
        this.moveUp.addActionListener(this);
        panel.add((Component)this.moveUp, "0,0");
        this.moveDown.addActionListener(this);
        panel.add((Component)this.moveDown, "2,0");
        this.remove.addActionListener(this);
        this.remove.setToolTipText("Remove selected item.  Key: DEL");
        this.remove.setFocusable(false);
        panel.add((Component)this.remove, "0,2");
        this.clear.addActionListener(this);
        panel.add((Component)this.clear, "2,2");
        this.deselect.addActionListener(this);
        this.deselect.setToolTipText("Deselects current selection.  Mouse: Right-click box");
        panel.add((Component)this.deselect, "0,4,2,4");
        this.grid4 = new JPanel(new GridLayout(1, 2, 2, 0));
        this.grid4.add(Box.createVerticalStrut(h));
        buttonBox.add((Component)panel, "First");
        buttonBox.add((Component)this.grid4, "Last");
        buttonBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        keysBox.add((Component)buttonBox, "South");
        bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "South");
        panel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        panel = new JPanel(new FlowLayout(2));
        bottomPanel.add((Component)panel, "South");
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
        this.macroButtons.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && FavScanDialog.this.remove.isVisible() && FavScanDialog.this.remove.isEnabled()) {
                    FavScanDialog.this.remove.doClick();
                }
            }
        });
        this.availableButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (FavScanDialog.this.macroButtons.getSelectedValue() != null) {
                        if ((e.getModifiers() & 1) != 0) {
                            if (FavScanDialog.this.insertShift.isVisible() && FavScanDialog.this.insertShift.isEnabled()) {
                                FavScanDialog.this.insertShift.doClick();
                            }
                        } else if (FavScanDialog.this.insert.isVisible() && FavScanDialog.this.insert.isEnabled()) {
                            FavScanDialog.this.insert.doClick();
                        }
                    } else if ((e.getModifiers() & 1) != 0) {
                        if (FavScanDialog.this.addShift.isVisible() && FavScanDialog.this.addShift.isEnabled()) {
                            FavScanDialog.this.addShift.doClick();
                        }
                    } else if (FavScanDialog.this.add.isVisible() && FavScanDialog.this.add.isEnabled()) {
                        FavScanDialog.this.add.doClick();
                    }
                } else if ((e.getButton() == 2 || e.getButton() == 3) && FavScanDialog.this.deselect.isVisible() && FavScanDialog.this.deselect.isEnabled()) {
                    FavScanDialog.this.deselect.doClick();
                }
            }
        });
        this.macroButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getButton() == 2 || e.getButton() == 3) && FavScanDialog.this.deselect.isVisible() && FavScanDialog.this.deselect.isEnabled()) {
                    FavScanDialog.this.deselect.doClick();
                }
            }
        });
        this.macroButtons.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FavScanDialog.this.enableButtons();
            }

            @Override
            public void focusLost(FocusEvent e) {
                FavScanDialog.this.enableButtons();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        if (source == this.okButton) {
            int length = this.macroButtonModel.getSize();
            if (length == 0) {
                this.showWarning("You haven't included any keys in your macro!", 0);
                return;
            }
            String text = this.nameField.getText().trim();
            if (!text.isEmpty()) {
                this.name = text;
            }
            int keyCode = remote.getFavKey().getKeyCode();
            ArrayList<Short> keyList = new ArrayList<Short>();
            int j = 0;
            for (int i = 0; i < length; ++i) {
                short keyValue = ((Number)this.macroButtonModel.elementAt(i)).shortValue();
                if (keyValue != 0) {
                    keyList.add(keyValue);
                    ++j;
                }
                if (keyValue != 0 && i != length - 1) continue;
                while (j % this.favKey.getEntrySize() != 0) {
                    keyList.add((short)0);
                    ++j;
                }
            }
            short[] keyCodes = new short[keyList.size()];
            for (int i = 0; i < keyCodes.length; ++i) {
                keyCodes[i] = (Short)keyList.get(i);
            }
            String notesStr = this.notes.getText();
            this.favScan = new FavScan(keyCode, new Hex(keyCodes), notesStr);
            this.favScan.setDeviceButton(this.deviceButton);
            this.favScan.setName(this.name);
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.favScan = null;
            this.setVisible(false);
        } else if (source == this.add) {
            this.addKey(this.getSelectedKeyCode(), 0);
        } else if (source == this.insert) {
            this.insertKey(this.getSelectedKeyCode(), 0);
        } else if (source == this.addShift) {
            this.addKey(this.getSelectedKeyCode(), remote.getShiftMask());
        } else if (source == this.insertShift) {
            this.insertKey(this.getSelectedKeyCode(), remote.getShiftMask());
        } else if (source == this.addXShift) {
            this.addKey(this.getSelectedKeyCode(), remote.getXShiftMask());
        } else if (source == this.insertXShift) {
            this.insertKey(this.getSelectedKeyCode(), remote.getXShiftMask());
        } else if (source == this.addPause) {
            this.addKey(0, 0);
        } else if (source == this.insertPause) {
            this.insertKey(0, 0);
        } else if (source == this.moveUp) {
            int index = this.macroButtons.getSelectedIndex();
            this.swap(index, index - 1);
        } else if (source == this.moveDown) {
            int index = this.macroButtons.getSelectedIndex();
            this.swap(index, index + 1);
        } else if (source == this.remove) {
            int index = this.macroButtons.getSelectedIndex();
            if (this.canRemove(index)) {
                this.macroButtonModel.removeElementAt(index);
                int last = this.macroButtonModel.getSize() - 1;
                if (index > last) {
                    index = last;
                }
                this.macroButtons.setSelectedIndex(index);
            }
        } else if (source == this.clear) {
            this.macroButtonModel.clear();
        } else if (source == this.deselect) {
            this.macroButtons.clearSelection();
        }
        this.enableButtons();
    }

    private int getEntrySize(int index) {
        while (index > 0 && ((Number)this.macroButtonModel.elementAt(index - 1)).intValue() != 0) {
            --index;
        }
        int start = index;
        while (index < this.macroButtonModel.getSize() && ((Number)this.macroButtonModel.elementAt(index)).intValue() != 0) {
            ++index;
        }
        return index - start;
    }

    private int getEntryCount() {
        int count = 0;
        for (int i = 0; i < this.macroButtonModel.getSize(); ++i) {
            if (((Number)this.macroButtonModel.elementAt(i)).intValue() != 0 && i != this.macroButtonModel.getSize() - 1) continue;
            ++count;
        }
        return count;
    }

    private void addKey(int keyCode, int mask) {
        Integer value = new Integer(keyCode | mask);
        int size = this.macroButtonModel.getSize();
        if (this.canAdd(size, value)) {
            this.macroButtonModel.addElement(value);
        }
    }

    private void insertKey(int keyCode, int mask) {
        int effectiveIndex;
        Integer value = new Integer(keyCode |= mask);
        int index = this.macroButtons.getSelectedIndex();
        int n = effectiveIndex = index == -1 ? 0 : index;
        if (!this.canAdd(effectiveIndex, value)) {
            return;
        }
        this.macroButtonModel.add(effectiveIndex, value);
        this.macroButtons.setSelectedIndex(index + 1);
        this.macroButtons.ensureIndexIsVisible(index + 1);
    }

    private boolean canAdd(int position, int key) {
        boolean createsNewEntry;
        int size = this.macroButtonModel.getSize();
        int prevKey = position > 0 ? ((Number)this.macroButtonModel.elementAt(position - 1)).intValue() : 0;
        boolean bl = createsNewEntry = key == 0 || position == size && prevKey == 0;
        if (this.getEntrySize(position) == this.favKey.getEntrySize() && !createsNewEntry) {
            this.showWarning("This would exceed the maximum number of keys without a Pause", 1);
            return false;
        }
        if (this.getEntryCount() == this.favKey.getMaxEntries() && createsNewEntry) {
            this.showWarning("This would exceed the maximum number of entries", 1);
            return false;
        }
        return true;
    }

    private boolean canRemove(int position) {
        int combinedSize;
        boolean combinesEntries;
        int size = this.macroButtonModel.getSize();
        int key = ((Number)this.macroButtonModel.elementAt(position)).intValue();
        int nextKey = position < size - 1 ? ((Number)this.macroButtonModel.elementAt(position + 1)).intValue() : 0;
        boolean bl = combinesEntries = key == 0 && nextKey != 0;
        if (combinesEntries && (combinedSize = this.getEntrySize(position) + this.getEntrySize(position + 1)) > this.favKey.getEntrySize()) {
            this.showWarning("This would create an entry exceeding maximum size", 1);
            return false;
        }
        return true;
    }

    private void swap(int index1, int index2) {
        Object o1 = this.macroButtonModel.get(index1);
        Object o2 = this.macroButtonModel.get(index2);
        int value1 = ((Number)o1).intValue();
        int value2 = ((Number)o2).intValue();
        if (value1 == 0 && value2 != 0 && (index1 < index2 && !this.canAdd(index1, 1) || index1 > index2 && !this.canAdd(index1 + 1, 1))) {
            return;
        }
        if (value2 == 0 && value1 != 0 && (index2 < index1 && !this.canAdd(index2, 1) || index2 > index2 && !this.canAdd(index2 + 1, 1))) {
            return;
        }
        this.macroButtonModel.set(index1, o2);
        this.macroButtonModel.set(index2, o1);
        this.macroButtons.setSelectedIndex(index2);
        this.macroButtons.ensureIndexIsVisible(index2);
    }

    private int getSelectedKeyCode() {
        return ((Button)this.availableButtons.getSelectedValue()).getKeyCode();
    }

    private void showWarning(String message, int type) {
        String title = type == 0 ? "Missing Information" : "Data Overflow";
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    public static FavScan showDialog(Component locationComp, FavScan favScan, RemoteConfiguration config) {
        if (dialog == null) {
            dialog = new FavScanDialog(locationComp);
        }
        dialog.setRemoteConfiguration(config);
        dialog.setFavKey(config.getRemote().getFavKey());
        dialog.setFavScan(favScan);
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        dialog.setVisible(true);
        return FavScanDialog.dialog.favScan;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private void setFavScan(FavScan favScan) {
        this.favScan = null;
        this.availableButtons.setSelectedIndex(-1);
        this.macroButtonModel.clear();
        if (favScan == null) {
            this.deviceButton = this.config.getFavKeyDevButton();
            this.name = "New Favorite";
            this.nameField.setText(this.name);
            this.notes.setText(null);
            this.enableButtons();
            return;
        }
        this.deviceButton = favScan.getDeviceButton();
        this.name = favScan.getName();
        this.nameField.setText(this.name);
        Remote remote = this.config.getRemote();
        short[] data = favScan.getData().getData();
        int entrySize = remote.getFavKey().getEntrySize();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) {
                this.macroButtonModel.addElement(new Integer(data[i]));
            }
            if (entrySize < 0 || data[i] != 0 && (i + 1) % entrySize != 0) continue;
            while (i < data.length && (data[i] == 0 || i % entrySize != 0)) {
                ++i;
            }
            --i;
            this.macroButtonModel.addElement(new Integer(0));
        }
        this.macroButtons.setSelectedIndex(-1);
        this.notes.setText(favScan.getNotes());
        this.enableButtons();
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        if (this.config == config) {
            return;
        }
        this.config = config;
        Remote remote = config.getRemote();
        List<Button> buttons = remote.getDistinctButtons();
        DefaultListModel<Button> model = new DefaultListModel<Button>();
        for (Button b : buttons) {
            if (!b.canAssignToFav() && !b.canAssignShiftedToFav() && !b.canAssignXShiftedToFav()) continue;
            model.addElement(b);
        }
        this.availableButtons.setModel(model);
        this.favScanButtonRenderer.setRemote(remote);
        boolean showAll = !remote.usesEZRC();
        this.grid2.setVisible(showAll);
        this.grid3.setVisible(!showAll);
        this.grid4.setVisible(showAll);
        this.addShift.setVisible(showAll);
        this.insertShift.setVisible(showAll);
        this.topPanel.setVisible(!showAll);
        this.keysBoxLabel.setText(showAll ? "Fav/Scan Keys:" : "Macro Keys:");
        this.setTitle(showAll ? "Fav/Scan" : "Favorite");
    }

    public void setFavKey(FavKey favKey) {
        this.favKey = favKey;
    }

    private void enableButtons() {
        Button b = (Button)this.availableButtons.getSelectedValue();
        this.add.setEnabled(b != null && b.canAssignToFav());
        this.insert.setEnabled(b != null && b.canAssignToFav());
        this.addShift.setEnabled(b != null && b.canAssignShiftedToFav());
        this.insertShift.setEnabled(b != null && b.canAssignShiftedToFav());
        boolean xShiftEnabled = this.config.getRemote().getXShiftEnabled();
        this.addXShift.setEnabled(xShiftEnabled && b != null && b.canAssignXShiftedToFav());
        this.insertXShift.setEnabled(xShiftEnabled && b != null && b.canAssignXShiftedToFav());
        int selected = this.macroButtons.getSelectedIndex();
        this.moveUp.setEnabled(selected > 0);
        this.moveDown.setEnabled(selected != -1 && selected < this.macroButtonModel.getSize() - 1);
        this.remove.setEnabled(this.macroButtons.isFocusOwner() && selected != -1);
        this.clear.setEnabled(this.macroButtonModel.getSize() > 0);
        this.deselect.setEnabled(selected != -1);
    }
}

