/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.FavScanDialog;
import com.hifiremote.jp1.FavScanTableModel;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class FavScanPanel
extends RMTablePanel<FavScan>
implements ActionListener {
    private JPanel deviceBoxPanel = null;
    private JPanel headerPanel = null;
    private JPanel macroLabelPanel = null;
    protected JComboBox deviceButtonBox = null;

    public FavScanPanel() {
        super(new FavScanTableModel());
        ((FavScanTableModel)this.getModel()).setPanel(this);
        this.headerPanel = new JPanel(new BorderLayout());
        this.deviceBoxPanel = new JPanel(new FlowLayout(0));
        this.deviceBoxPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.macroLabelPanel = new JPanel(new BorderLayout());
        this.deviceButtonBox = new JComboBox();
        this.deviceButtonBox.addActionListener(this);
        Dimension d = this.deviceButtonBox.getPreferredSize();
        d.width = 100;
        this.deviceButtonBox.setPreferredSize(d);
        this.add((Component)this.headerPanel, "First");
        this.headerPanel.add((Component)this.deviceBoxPanel, "First");
        this.headerPanel.add((Component)this.macroLabelPanel, "Last");
        this.deviceBoxPanel.add(new JLabel("Scan device:   "));
        this.deviceBoxPanel.add(this.deviceButtonBox);
        this.macroLabelPanel.add((Component)new JLabel("Scan macros:"), "Before");
        this.macroLabelPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
    }

    @Override
    protected FavScan createRowObject(FavScan baseFavScan) {
        FavScanTableModel favScanTableModel = (FavScanTableModel)this.model;
        RemoteConfiguration config = favScanTableModel.getRemoteConfig();
        if (baseFavScan == null && config.getRemote().getFavKey().isSegregated() && favScanTableModel.getRowCount() == 1) {
            String message = "This remote does not support more than one Fav/Scan entry.";
            String title = "Fav/Scan";
            JOptionPane.showMessageDialog(this, message, title, 0);
            return null;
        }
        return FavScanDialog.showDialog(this, baseFavScan, config);
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        ((FavScanTableModel)this.model).set(remoteConfig);
        this.table.initColumns(this.model);
        if (remoteConfig != null) {
            Remote remote = remoteConfig.getRemote();
            if (!remote.hasFavKey()) {
                return;
            }
            DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
            if (remote.getFavKey() != null && !remote.getFavKey().isSegregated()) {
                comboModel.insertElementAt(DeviceButton.noButton, 0);
            }
            if (remoteConfig.getFavKeyDevButton() == null) {
                remoteConfig.setFavKeyDevButton(comboModel.getElementAt(0));
            }
            this.deviceButtonBox.setModel(comboModel);
            this.deviceButtonBox.setSelectedItem(remoteConfig.getFavKeyDevButton());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.cloneButton.setEnabled(false);
        this.cloneItem.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.deviceButtonBox) {
            RemoteConfiguration config;
            DeviceButton deviceButton = (DeviceButton)this.deviceButtonBox.getSelectedItem();
            if (deviceButton != (config = ((FavScanTableModel)this.model).getRemoteConfig()).getFavKeyDevButton()) {
                config.setFavKeyDevButton(deviceButton);
            }
            return;
        }
        super.actionPerformed(event);
    }
}

