/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.FavoritesPanel;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.RMSetterEditor;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Color;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class FavScanTableModel
extends JP1TableModel<FavScan> {
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Name of a favorite ", "A reasonable length macro with several steps ", "Channel Number_", "A reasonable length note", "Icon?_", "Profile?_", "Color_"};
    private static final boolean[] colWidths = new boolean[]{true, false, false, true, false, true, true, true};
    private static final String[] colNames = new String[]{"#", "Name", "Macro Keys", "Channel Number", "Notes", "Icon?", "<html>In<br>profile&#63;</html>", "<html>Size &amp<br>Color</html>"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, String.class, String.class, GeneralFunction.RMIcon.class, Boolean.class, Color.class};
    private int lastCell = 0;
    private RemoteConfiguration remoteConfig = null;
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private RMSetterEditor<GeneralFunction.RMIcon, GeneralFunction.IconPanel> iconEditor = null;
    private GeneralFunction.IconRenderer iconRenderer = null;
    private RMPanel panel = null;

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.setData(remoteConfig.getFavScans());
        }
        if (remoteConfig.getRemote().isSSD()) {
            this.iconEditor = new RMSetterEditor(GeneralFunction.IconPanel.class);
            this.iconEditor.setRemoteConfiguration(remoteConfig);
            this.iconEditor.setTitle("Icon Editor");
            this.iconRenderer = new GeneralFunction.IconRenderer();
        }
    }

    private int getEffectiveColumn(int col) {
        if (this.remoteConfig != null && !this.remoteConfig.getRemote().usesEZRC() && col > 0) {
            ++col;
        }
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC() && col > 1) {
            ++col;
        }
        if (this.remoteConfig != null && !this.remoteConfig.getRemote().usesEZRC() && col > 2) {
            ++col;
        }
        if (this.remoteConfig != null && !this.remoteConfig.getRemote().isSSD() && col > 4) {
            ++col;
        }
        if (!(this.remoteConfig == null || this.remoteConfig.getRemote().hasProfiles() && this.panel instanceof FavoritesPanel && ((FavoritesPanel)this.panel).showProfile() || col <= 5)) {
            ++col;
        }
        return col;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return (col = this.getEffectiveColumn(col)) == 1 || col >= 3;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[this.getEffectiveColumn(col)];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[this.getEffectiveColumn(col)];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[this.getEffectiveColumn(col)];
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 5;
        if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
            ++count;
        }
        if (this.remoteConfig != null && this.remoteConfig.getRemote().isSSD()) {
            ++count;
        }
        if (this.remoteConfig != null && this.remoteConfig.getRemote().hasProfiles() && this.panel instanceof FavoritesPanel && ((FavoritesPanel)this.panel).showProfile()) {
            ++count;
        }
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 5) {
            return this.iconRenderer;
        }
        if (col == 7) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if ((col = this.getEffectiveColumn(col)) == 1 || col == 3) {
            return this.selectAllEditor;
        }
        if (col == 5) {
            return this.iconEditor;
        }
        if (col == 6) {
            JCheckBox check = new JCheckBox();
            check.setHorizontalAlignment(0);
            DefaultCellEditor e = new DefaultCellEditor(check);
            e.setClickCountToStart(2);
            return e;
        }
        if (col == 7) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        FavScan favScan = this.remoteConfig.getFavScans().get(row);
        column = this.getEffectiveColumn(column);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return favScan.getName();
            }
            case 2: {
                return favScan.getValueString(this.remoteConfig);
            }
            case 3: {
                return favScan.getChannel();
            }
            case 4: {
                return favScan.getNotes();
            }
            case 5: {
                return favScan.icon;
            }
            case 6: {
                if (this.panel instanceof FavoritesPanel) {
                    Activity activity = ((FavoritesPanel)this.panel).getActivity();
                    return activity != null && favScan.getProfileIndices().contains(activity.getProfileIndex());
                }
                return false;
            }
            case 7: {
                return favScan.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        FavScan favScan = (FavScan)this.getRow(row);
        if ((col = this.getEffectiveColumn(col)) == 1) {
            favScan.setName((String)value);
        } else if (col == 3) {
            String s = (String)value;
            String channel = "";
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character ch = Character.valueOf(cArray[i]);
                ch = Character.valueOf(ch.charValue() == '-' ? (char)'.' : (char)ch.charValue());
                if (!Character.isDigit(ch.charValue()) && ch.charValue() != '.') continue;
                channel = channel + ch;
            }
            favScan.setChannel(this.resizeChannel(channel, favScan.getDeviceButton()));
        } else if (col == 4) {
            favScan.setNotes((String)value);
        } else if (col == 5) {
            favScan.icon = (GeneralFunction.RMIcon)value;
        } else if (col == 6) {
            int index = ((FavoritesPanel)this.panel).getActivity().getProfileIndex();
            if (((Boolean)value).booleanValue()) {
                if (!favScan.getProfileIndices().contains(index)) {
                    favScan.getProfileIndices().add(index);
                }
            } else {
                favScan.getProfileIndices().remove((Object)index);
            }
        } else if (col == 7) {
            favScan.setHighlight((Color)value);
        }
        this.propertyChangeSupport.firePropertyChange(col == 3 ? "highlight" : "data", null, null);
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setPanel(RMPanel panel) {
        this.panel = panel;
    }

    public String resizeChannel(String channel, DeviceButton favDb) {
        int favWidth = favDb.getFavoriteWidth();
        Remote remote = this.remoteConfig.getRemote();
        int dot = channel.indexOf(46);
        String body = dot >= 0 ? channel.substring(0, dot) : channel;
        String tail = dot >= 0 ? channel.substring(dot) : "";
        int size = body.length();
        if (size > favWidth) {
            body = body.substring(size - favWidth, size);
        }
        if (remote.usesEZRC() && size < favWidth) {
            body = "00000000".substring(0, favWidth - size) + body;
        }
        return body + tail;
    }

    @Override
    public String getToolTipText(int row, int col) {
        int thisCell = row + (col = this.getEffectiveColumn(col)) * 256;
        if (thisCell == this.lastCell) {
            return null;
        }
        this.lastCell = thisCell;
        if (col == 5) {
            return JTableX.getHtmlToolTip("Double click this column to open Icon Editor to set or<br>remove a user icon from this favorite and/or import an<br>icon from a file or export one to a file.");
        }
        if (col == 6) {
            return JTableX.getHtmlToolTip("Double click this column to add or remove a favorite<br>from the selected profile.");
        }
        return null;
    }
}

