/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityGroupTableModel;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.FavScanTableModel;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyChooser;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.RMSetterDialog;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

public class FavoritesPanel
extends RMPanel
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RemoteConfiguration remoteConfig = null;
    public MouseListener openEditor = null;
    private JP1Table favTable = null;
    private JP1Table activeTable = null;
    private FavScanTableModel favModel = null;
    private JP1Table activityGroupTable = null;
    private ActivityGroupTableModel activityGroupModel = new ActivityGroupTableModel();
    private Button favBtn = null;
    private FavScan favorite = null;
    private JPanel deviceBoxPanel = null;
    private JPanel pausePanel = null;
    private JFormattedTextField duration = null;
    private JComboBox<DeviceButton> deviceButtonBox = null;
    private JButton newButton = null;
    private JButton deleteButton = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JButton newProfile = null;
    private JButton deleteProfile = null;
    private JButton upProfile = null;
    private JButton downProfile = null;
    private JCheckBox addFinal = null;
    private JTextField favWidth = null;
    private JTextField finalKey = null;
    private JLabel finalKeyLabel = null;
    private JPanel profilesPanel = null;
    private JPanel groupPanel = null;
    private JList profiles = new JList();
    private DefaultListModel profilesModel = new DefaultListModel();
    private JSplitPane upperPane = null;
    private JRadioButton allButton = new JRadioButton("Show all favorites");
    private JRadioButton profileButton = new JRadioButton("Show selected profile");
    private JTextField profileField = null;
    private JLabel iconLabel = null;
    private JButton iconButton = null;
    private JLabel profileIconLabel = null;
    private boolean hasSSDset = false;
    private boolean hasFDRAset = false;

    public FavoritesPanel() {
        this.favModel = new FavScanTableModel();
        this.favModel.setPanel(this);
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("0.0"));
        formatter.setValueClass(Float.class);
        this.duration = new JFormattedTextField(formatter){

            @Override
            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                if (e.getID() == 1004) {
                    this.selectAll();
                }
            }
        };
        this.duration.setColumns(4);
        this.duration.addActionListener(this);
        this.pausePanel = new JPanel(new WrapLayout(0));
        this.pausePanel.setVisible(false);
        this.deviceBoxPanel = new JPanel(new WrapLayout(0));
        this.deviceButtonBox = new JComboBox();
        this.deviceButtonBox.addActionListener(this);
        Dimension d = this.deviceButtonBox.getPreferredSize();
        d.width = 100;
        this.deviceButtonBox.setPreferredSize(d);
        this.favWidth = new JTextField(4);
        this.favWidth.setEditable(false);
        this.favWidth.setToolTipText("Double-click to edit.");
        this.finalKey = new JTextField(12);
        this.finalKeyLabel = new JLabel("Enter Key: ");
        this.finalKey.setEditable(false);
        this.finalKey.setToolTipText("Double-click to edit.");
        this.finalKeyLabel.setLabelFor(this.finalKey);
        Box topBox = Box.createVerticalBox();
        topBox.add(this.pausePanel);
        topBox.add(this.deviceBoxPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(" Favorites Macros "));
        panel.add((Component)topBox, "First");
        this.favTable = new JP1Table(this.favModel);
        this.favTable.setSelectionMode(1);
        panel.add((Component)new JScrollPane(this.favTable), "Center");
        JPanel buttonPanel = new JPanel(new WrapLayout(1, 5, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.newButton = new JButton("New");
        this.newButton.addActionListener(this);
        this.newButton.setToolTipText("Add a new item");
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setToolTipText(JTableX.getHtmlToolTip("Delete the selected item. &nbsp&nbsp&nbsp Key: DEL<br>(Table must have the focus.)"));
        this.deleteButton.setEnabled(false);
        buttonPanel.add(this.deleteButton);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.upButton.setToolTipText("Move the selected item up in the list.");
        this.upButton.setEnabled(false);
        buttonPanel.add(this.upButton);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        this.downButton.setToolTipText("Move the selected item down in the list.");
        this.downButton.setEnabled(false);
        buttonPanel.add(this.downButton);
        this.iconLabel = new JLabel("   ");
        this.iconLabel.setPreferredSize(new Dimension(100, 40));
        this.iconLabel.setHorizontalTextPosition(10);
        this.iconLabel.setVisible(false);
        buttonPanel.add(Box.createVerticalStrut(this.iconLabel.getPreferredSize().height));
        buttonPanel.add(this.iconLabel);
        FavoritesPanel.setButtonKeys(this.favTable, this.deleteButton);
        panel.add((Component)buttonPanel, "Last");
        this.profilesPanel = new JPanel(new BorderLayout());
        this.profilesPanel.setBorder(BorderFactory.createTitledBorder(" Profiles "));
        this.profilesPanel.add((Component)new JScrollPane(this.profiles), "Center");
        this.profiles.setSelectionMode(0);
        this.profiles.addListSelectionListener(this);
        this.upperPane = new JSplitPane(1, this.profilesPanel, panel);
        this.upperPane.setResizeWeight(0.5);
        panel = new JPanel(new WrapLayout());
        panel.add(this.allButton);
        panel.add(this.profileButton);
        panel.setSize(new Dimension(40, 1));
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.allButton);
        grp.add(this.profileButton);
        this.allButton.addActionListener(this);
        this.profileButton.addActionListener(this);
        this.allButton.setSelected(true);
        this.profilesPanel.add((Component)panel, "First");
        panel = new JPanel(new BorderLayout());
        this.profilesPanel.add((Component)panel, "Last");
        JPanel p = new JPanel(new WrapLayout(0, 5, 0));
        this.profileField = new JTextField(10);
        this.profileField.getDocument().addDocumentListener(this);
        this.profileField.setToolTipText("Edit this value to rename selected profile");
        p.add(new JLabel("Selected: "));
        p.add(this.profileField);
        this.iconButton = new JButton("Icon:");
        this.iconButton.setToolTipText("Click to change icon for selected profile");
        this.iconButton.addActionListener(this);
        p.add(this.iconButton);
        this.profileIconLabel = new JLabel();
        this.profileIconLabel.setPreferredSize(new Dimension(50, 40));
        this.profileIconLabel.setHorizontalTextPosition(10);
        p.add(this.profileIconLabel);
        panel.add((Component)p, "First");
        buttonPanel = new JPanel(new WrapLayout());
        panel.add((Component)buttonPanel, "Last");
        this.newProfile = new JButton("New");
        this.newProfile.addActionListener(this);
        this.newProfile.setToolTipText("Add a new profile.");
        buttonPanel.add(this.newProfile);
        this.deleteProfile = new JButton("Delete");
        this.deleteProfile.addActionListener(this);
        this.deleteProfile.setToolTipText(JTableX.getHtmlToolTip("Delete the selected profile. &nbsp&nbsp&nbsp Key: DEL<br>(Table must have the focus.)"));
        this.deleteProfile.setEnabled(false);
        buttonPanel.add(this.deleteProfile);
        this.upProfile = new JButton("Up");
        this.upProfile.addActionListener(this);
        this.upProfile.setToolTipText("Move the selected profile up in the list.");
        this.upProfile.setEnabled(false);
        buttonPanel.add(this.upProfile);
        this.downProfile = new JButton("Down");
        this.downProfile.addActionListener(this);
        this.downProfile.setToolTipText("Move the selected profile down in the list.");
        this.downProfile.setEnabled(false);
        buttonPanel.add(this.downProfile);
        FavoritesPanel.setButtonKeys(this.profiles, this.deleteProfile);
        this.add((Component)this.upperPane, "First");
        this.groupPanel = new JPanel(new BorderLayout());
        this.groupPanel.setBorder(BorderFactory.createTitledBorder(" Favorites Group Assignments "));
        this.activityGroupTable = new JP1Table(this.activityGroupModel);
        this.activityGroupTable.setCellEditorModel(this.activityGroupModel);
        this.activityGroupTable.setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane(this.activityGroupTable);
        this.groupPanel.add((Component)scrollPane, "Center");
        this.add((Component)this.groupPanel, "Center");
        d = this.favTable.getPreferredSize();
        d.height = 12 * this.favTable.getRowHeight();
        this.favTable.setPreferredScrollableViewportSize(d);
        this.favTable.getSelectionModel().addListSelectionListener(this);
        this.favTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FavoritesPanel.this.activeTable = FavoritesPanel.this.favTable;
                FavoritesPanel.this.setHighlightAction(FavoritesPanel.this.favTable);
            }
        });
        this.activityGroupTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FavoritesPanel.this.activeTable = FavoritesPanel.this.activityGroupTable;
                FavoritesPanel.this.setHighlightAction(FavoritesPanel.this.activityGroupTable);
            }
        });
        this.duration.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                float f = ((Float)FavoritesPanel.this.duration.getValue()).floatValue();
                try {
                    FavoritesPanel.this.duration.commitEdit();
                }
                catch (ParseException e1) {
                    FavoritesPanel.this.duration.setValue(Float.valueOf(f));
                    return;
                }
                f = ((Float)FavoritesPanel.this.duration.getValue()).floatValue();
                int val = Math.max((int)(10.0 * (double)f + 0.5), 1);
                FavoritesPanel.this.remoteConfig.getRemote().getFavKey().setFavPause(val);
                FavoritesPanel.this.duration.setValue(Float.valueOf((float)val / 10.0f));
                try {
                    FavoritesPanel.this.duration.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                FavoritesPanel.this.propertyChangeSupport.firePropertyChange("data", null, null);
            }
        });
        this.openEditor = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() != 2) {
                    return;
                }
                Component source = e.getComponent();
                Remote remote = FavoritesPanel.this.remoteConfig.getRemote();
                if (source == FavoritesPanel.this.finalKey) {
                    Integer result;
                    Button btn = remote.getButton(FavoritesPanel.this.finalKey.getText());
                    if (btn == null) {
                        btn = Button.noButton;
                    }
                    if ((result = KeyChooser.showDialog(FavoritesPanel.this.finalKey, remote, Integer.valueOf(btn.getKeyCode()), Button.MOVE_BIND, Button.noButton)) != null) {
                        btn = remote.getButton(result);
                        FavoritesPanel.this.finalKey.setText(btn.getName());
                        DeviceButton deviceButton = (DeviceButton)FavoritesPanel.this.deviceButtonBox.getSelectedItem();
                        if (deviceButton != null) {
                            deviceButton.setFavFinalKey(btn);
                            FavoritesPanel.this.propertyChangeSupport.firePropertyChange("data", null, null);
                        }
                    }
                    return;
                }
                if (source == FavoritesPanel.this.favWidth) {
                    Button btn = remote.getButton(FavoritesPanel.this.favWidth.getText());
                    Integer result = KeyChooser.showDialog(FavoritesPanel.this.favWidth, remote, Integer.valueOf(btn.getKeyCode()), -8, null, "Digit Count Chooser", "Count");
                    if (result != null) {
                        String btnName = remote.getButton(result).getName();
                        FavoritesPanel.this.favWidth.setText(btnName);
                        int width = Integer.parseInt(btnName);
                        DeviceButton deviceButton = (DeviceButton)FavoritesPanel.this.deviceButtonBox.getSelectedItem();
                        if (deviceButton != null) {
                            deviceButton.setFavoritewidth(width);
                            for (FavScan fav : FavoritesPanel.this.remoteConfig.getFavScans()) {
                                if (fav.getDeviceButton() != deviceButton) continue;
                                fav.setChannel(FavoritesPanel.this.favModel.resizeChannel(fav.getChannel(), deviceButton));
                            }
                            FavoritesPanel.this.propertyChangeSupport.firePropertyChange("data", null, null);
                            FavoritesPanel.this.favTable.repaint();
                        }
                    }
                }
                if ((row = FavoritesPanel.this.favTable.getSelectedRow()) == -1) {
                    return;
                }
            }
        };
        this.favTable.addMouseListener(this.openEditor);
        this.finalKey.addMouseListener(this.openEditor);
        this.favWidth.addMouseListener(this.openEditor);
        this.activeTable = this.favTable;
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            if (this.favModel != null) {
                this.favModel.addPropertyChangeListener(listener);
            }
            if (this.activityGroupModel != null) {
                this.activityGroupModel.addPropertyChangeListener(listener);
            }
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        Remote remote = remoteConfig.getRemote();
        if (!remote.hasFavorites()) {
            return;
        }
        if (remote.isSSD() && !this.hasSSDset) {
            if (this.hasFDRAset) {
                this.deviceBoxPanel.removeAll();
                this.pausePanel.removeAll();
            }
            this.deviceBoxPanel.setBorder(BorderFactory.createTitledBorder(" Device Info for selected Favorite: "));
            this.deviceBoxPanel.add(new JLabel("Device: "));
            this.deviceBoxPanel.add(this.deviceButtonBox);
            this.deviceBoxPanel.add(Box.createHorizontalStrut(20));
            this.deviceBoxPanel.add(new JLabel("Digits: "));
            this.deviceBoxPanel.add(this.favWidth);
            this.deviceBoxPanel.add(Box.createHorizontalStrut(5));
            this.deviceBoxPanel.add(this.finalKeyLabel);
            this.deviceBoxPanel.add(this.finalKey);
            this.pausePanel.setVisible(true);
            this.pausePanel.add(new JLabel("Interdigit Pause (All Devices):"));
            this.pausePanel.add(this.duration);
            this.pausePanel.add(new JLabel(" secs"));
            this.hasSSDset = true;
            this.hasFDRAset = false;
        } else if (remote.isFDRA() && !this.hasFDRAset) {
            if (this.hasSSDset) {
                this.deviceBoxPanel.removeAll();
                this.pausePanel.removeAll();
            }
            this.deviceBoxPanel.setBorder(BorderFactory.createTitledBorder(" Info for Channel Change Device: "));
            this.deviceBoxPanel.add(new JLabel("Device: "));
            this.deviceBoxPanel.add(this.deviceButtonBox);
            this.deviceBoxPanel.add(Box.createHorizontalStrut(20));
            this.deviceBoxPanel.add(new JLabel("Digits: "));
            this.deviceBoxPanel.add(this.favWidth);
            this.deviceBoxPanel.add(Box.createHorizontalStrut(5));
            this.deviceBoxPanel.add(new JLabel("Interdigit Pause:"));
            this.deviceBoxPanel.add(this.duration);
            this.deviceBoxPanel.add(new JLabel(" secs"));
            this.deviceBoxPanel.add(Box.createHorizontalStrut(5));
            this.deviceBoxPanel.add(this.finalKeyLabel);
            this.deviceBoxPanel.add(this.finalKey);
            this.pausePanel.setVisible(false);
            this.hasSSDset = false;
            this.hasFDRAset = true;
        }
        DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
        this.favorite = null;
        this.favModel.set(remoteConfig);
        this.favTable.initColumns(this.favModel);
        this.activityGroupTable.setVisible(false);
        this.profilesPanel.setVisible(remote.hasProfiles());
        this.iconLabel.setVisible(remote.isSSD());
        this.iconLabel.setIcon(null);
        this.profileIconLabel.setIcon(null);
        this.favBtn = remote.getButton(remote.getFavKey().getKeyCode());
        this.newButton.setEnabled(this.favBtn != null);
        if (this.favTable.getRowCount() > 0) {
            this.duration.setValue(new Float((double)remote.getFavKey().getFavPause() / 10.0));
        } else {
            this.duration.setValue(Float.valueOf(0.3f));
        }
        if (this.favBtn != null) {
            this.activityGroupModel.set(this.favBtn, remoteConfig, this.getActivity());
            this.activityGroupTable.initColumns(this.activityGroupModel);
            this.deviceButtonBox.setModel(comboModel);
            if (remote.isSSD() || this.favTable.getRowCount() == 0) {
                this.deviceButtonBox.setSelectedIndex(-1);
            } else if (remote.isFDRA()) {
                this.deviceButtonBox.setSelectedItem(((FavScan)this.favModel.getRow(0)).getDeviceButton());
            }
        }
        this.finalKey.setVisible(true);
        this.finalKeyLabel.setVisible(true);
        if (remote.hasProfiles()) {
            this.profilesModel.clear();
            for (Activity activity : remote.getFavKey().getProfiles()) {
                this.profilesModel.addElement(activity);
            }
            this.profiles.setModel(this.profilesModel);
        }
        this.profileButton.setEnabled(this.profilesModel.size() > 0);
        if (this.profilesModel.size() == 0) {
            this.allButton.setSelected(true);
        }
        this.upperPane.resetToPreferredSizes();
        this.iconLabel.setVisible(remote.isSSD());
        this.iconLabel.setIcon(null);
    }

    public void finishEditing() {
        if (this.favTable.getCellEditor() != null) {
            this.favTable.getCellEditor().stopCellEditing();
        }
        if (this.activityGroupTable.getCellEditor() != null) {
            this.activityGroupTable.getCellEditor().stopCellEditing();
        }
    }

    private void setHighlightAction(JP1Table table) {
        this.remoteConfig.getOwner().highlightAction.setEnabled(table.getSelectedRowCount() > 0);
    }

    public JP1Table getActiveTable() {
        return this.activeTable;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block46: {
            Object source = event.getSource();
            List<FavScan> favScans = this.remoteConfig.getFavScans();
            this.finishEditing();
            int row = 0;
            Remote remote = this.remoteConfig.getRemote();
            if (source.getClass() == JButton.class) {
                row = this.favTable.getSelectedRow();
            }
            if (source == this.deviceButtonBox) {
                DeviceButton deviceButton = (DeviceButton)this.deviceButtonBox.getSelectedItem();
                if (deviceButton != null) {
                    Button favFinalKey = deviceButton.getFavFinalKey();
                    this.finalKey.setText(favFinalKey.getName());
                    int width = deviceButton.getFavoriteWidth();
                    this.favWidth.setText(Integer.toString(width));
                    if (remote.isSSD() && this.favorite != null) {
                        this.favorite.setDeviceButton(deviceButton);
                    } else if (remote.isFDRA()) {
                        this.remoteConfig.setFavKeyDevButton(deviceButton);
                        if (this.favTable.getRowCount() > 0) {
                            for (FavScan fs : this.favModel.getData()) {
                                fs.setDeviceButton(deviceButton);
                            }
                        }
                    }
                } else {
                    this.finalKey.setText("<none>");
                    this.favWidth.setText("0");
                }
            } else if (source == this.upButton || source == this.downButton) {
                FavScan favScan = favScans.get(row);
                favScans.remove(row);
                int toRow = source == this.upButton ? row - 1 : row + 1;
                favScans.add(toRow, favScan);
                this.favModel.fireTableRowsUpdated(Math.min(row, toRow), Math.max(row, toRow));
                this.favTable.setRowSelectionInterval(toRow, toRow);
            } else if (source == this.deleteButton) {
                int[] rows = this.favTable.getSelectedRows();
                Arrays.sort(rows);
                int row1 = rows[0];
                for (int i = rows.length - 1; i >= 0; --i) {
                    favScans.remove(rows[i]);
                }
                if (favScans.size() == 0) {
                    if (this.remoteConfig.getFavKeyDevButton() != null) {
                        this.remoteConfig.getFavKeyDevButton().setFavoritewidth(0);
                    }
                    this.remoteConfig.setFavKeyDevButton(null);
                }
                this.favModel.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
                int n = row1 = row1 < favScans.size() ? row1 : favScans.size() - 1;
                if (row1 >= 0) {
                    this.favTable.setRowSelectionInterval(row1, row1);
                }
            } else if (source == this.newButton) {
                int width;
                FavScan favScan;
                block45: {
                    this.favTable.clearSelection();
                    favScan = new FavScan(this.favBtn.getKeyCode(), null, null);
                    favScan.setName("New favorite");
                    String title = "New Favorite";
                    width = 0;
                    if (remote.isSSD()) {
                        this.deviceButtonBox.setSelectedIndex(-1);
                        DeviceButton initialDev = this.favTable.getRowCount() > 0 ? ((FavScan)this.favModel.getRow(this.favTable.getRowCount() - 1)).getDeviceButton() : remote.getDeviceButtons()[0];
                        String message = "Please select the Device to be used to select the new Favorite.  If that Device\nis already used for any existing Favorites, the number of digits in its channel\nnumbers and any key that needs to be sent after the channel digits will be\nshown in the Digits and Enter Key boxes.  If this is a new Device for Favorites\nthen these values need also to be set. Double-click the boxes to edit.\n\nIf an  Enter Key is set then the channel number entry may include a decimal point\nfollowed by a sub-channel number.  The Enter Key is sent after the channel and\nbefore the sub-channel.  The Digits value is the size of only the channel part.";
                        DeviceButton result = (DeviceButton)JOptionPane.showInputDialog(this, message, title, -1, null, remote.getDeviceButtons(), initialDev);
                        if (result == null) {
                            return;
                        }
                        this.deviceButtonBox.setSelectedItem(result);
                        favScan.icon = new GeneralFunction.RMIcon(6);
                        favScan.setProfileIndices(new ArrayList<Integer>());
                        ArrayList<Integer> serials = new ArrayList<Integer>();
                        for (FavScan fs : favScans) {
                            if (serials.contains(fs.getSerial())) continue;
                            serials.add(fs.getSerial());
                        }
                        Collections.sort(serials);
                        int i = 0;
                        while (true) {
                            if (!serials.contains(i)) {
                                favScan.setSerial(i);
                                break block45;
                            }
                            ++i;
                        }
                    }
                    if (this.deviceButtonBox.getSelectedIndex() == -1 || this.favWidth.getText().equals("0")) {
                        String message = "Before you can create a new Favorite, you must set both a\nChannel Change Device and a non-zero Digits value as the\nnumber of digits in a channel number on that Device.";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                        return;
                    }
                }
                DeviceButton favDevice = (DeviceButton)this.deviceButtonBox.getSelectedItem();
                width = favDevice.getFavoriteWidth();
                favScan.setSegmentFlags(255);
                favScan.setDeviceButton((DeviceButton)this.deviceButtonBox.getSelectedItem());
                favScan.setChannel("00000000".substring(0, width));
                favScans.add(favScan);
                row = favScans.size() - 1;
                if (this.favTable.getSelectedRowCount() == 0) {
                    this.favTable.setColumnSelectionInterval(1, 1);
                }
                this.favModel.fireTableRowsInserted(row, row);
                this.favTable.setRowSelectionInterval(row, row);
                this.favTable.requestFocusInWindow();
                this.favTable.scrollRectToVisible(this.favTable.getCellRect(row, 0, true));
            } else if (source == this.allButton) {
                this.favModel.fireTableStructureChanged();
                this.favTable.initColumns(this.favModel);
                this.groupPanel.setBorder(BorderFactory.createTitledBorder(" Favorites Group Assignments "));
                this.activityGroupModel.set(this.favBtn, this.remoteConfig, this.getActivity());
                this.activityGroupTable.initColumns(this.activityGroupModel);
                this.repaint();
            } else if (source == this.profileButton) {
                if (this.profilesModel.size() > 0 && this.profiles.getSelectedIndex() < 0) {
                    this.profiles.setSelectedIndex(0);
                }
                this.favModel.fireTableStructureChanged();
                this.favTable.initColumns(this.favModel);
                this.activityGroupModel.set(this.favBtn, this.remoteConfig, this.getActivity());
                this.activityGroupTable.initColumns(this.activityGroupModel);
                this.groupPanel.setBorder(BorderFactory.createTitledBorder(" Profile Group Assignments "));
                this.repaint();
            } else {
                if (source == this.newProfile) {
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (Activity a : remote.getFavKey().getProfiles()) {
                        if (!indices.contains(a.getProfileIndex())) {
                            // empty if block
                        }
                        indices.add(a.getProfileIndex());
                    }
                    Collections.sort(indices);
                    int i = 0;
                    while (true) {
                        if (!indices.contains(i)) {
                            Activity activity = remote.getFavKey().createProfile("New profile", i, remote);
                            this.profilesModel.addElement(activity);
                            this.profiles.setModel(this.profilesModel);
                            this.profiles.setSelectedValue(activity, true);
                            break block46;
                        }
                        ++i;
                    }
                }
                if (source == this.deleteProfile) {
                    Activity activity = (Activity)this.profiles.getSelectedValue();
                    int i = this.profiles.getSelectedIndex();
                    int index = activity.getProfileIndex();
                    for (FavScan favScan : this.remoteConfig.getFavScans()) {
                        favScan.getProfileIndices().remove((Object)index);
                    }
                    remote.getFavKey().getProfiles().remove(activity);
                    this.profilesModel.removeElement(activity);
                    this.profiles.setModel(this.profilesModel);
                    if (!this.profilesModel.isEmpty()) {
                        this.profiles.setSelectedIndex(i < this.profilesModel.size() ? i : i - 1);
                    }
                } else if (source == this.upProfile || source == this.downProfile) {
                    Activity activity = (Activity)this.profiles.getSelectedValue();
                    int i = this.profiles.getSelectedIndex();
                    this.profilesModel.remove(i);
                    remote.getFavKey().getProfiles().remove(i);
                    int toRow = source == this.upProfile ? i - 1 : i + 1;
                    this.profilesModel.add(toRow, activity);
                    remote.getFavKey().getProfiles().add(toRow, activity);
                    this.profiles.setModel(this.profilesModel);
                    this.profiles.setSelectedIndex(toRow);
                } else if (source == this.iconButton) {
                    Activity activity = (Activity)this.profiles.getSelectedValue();
                    GeneralFunction.RMIcon icon = activity.icon;
                    this.iconButton.setPreferredSize(this.iconButton.getSize());
                    this.iconButton.setText(icon.toString());
                    RMSetterDialog<GeneralFunction.RMIcon> dialog = new RMSetterDialog<GeneralFunction.RMIcon>();
                    dialog.setTitle("Icon Editor");
                    GeneralFunction.RMIcon result = dialog.showDialog(this, this.remoteConfig, GeneralFunction.IconPanel.class, icon);
                    if (result != null) {
                        activity.icon = result;
                        this.profileIconLabel.setIcon(result.image);
                    }
                    this.iconButton.setText("Icon:");
                }
            }
        }
        this.activityGroupTable.setVisible(this.favTable.getModel().getRowCount() > 0);
        this.propertyChangeSupport.firePropertyChange("data", null, null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source == this.favTable.getSelectionModel()) {
            if (!e.getValueIsAdjusting()) {
                if (this.favTable.getSelectedRowCount() == 1) {
                    int row = this.favTable.getSelectedRow();
                    boolean selected = row != -1;
                    this.favorite = selected ? (FavScan)this.favModel.getRow(row) : null;
                    DeviceButton db = this.favorite.getDeviceButton();
                    this.deviceButtonBox.setSelectedItem(db);
                    Button favFinalKey = db.getFavFinalKey();
                    if (favFinalKey != null) {
                        this.finalKey.setText(favFinalKey.getName());
                    } else {
                        this.finalKey.setText("");
                    }
                    this.favWidth.setText(Integer.toString(db.getFavoriteWidth()));
                    this.upButton.setEnabled(row > 0);
                    this.downButton.setEnabled(selected && row < this.favTable.getRowCount() - 1);
                    GeneralFunction.RMIcon icon = this.remoteConfig.getFavScans().get((int)row).icon;
                    this.iconLabel.setIcon(icon == null ? null : icon.image);
                } else {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                    this.iconLabel.setIcon(null);
                }
                this.repaint();
                this.deleteButton.setEnabled(this.favTable.isFocusOwner() && this.favTable.getSelectedRowCount() > 0);
            }
        } else if (source == this.profiles) {
            Activity a = (Activity)this.profiles.getSelectedValue();
            int index = this.profiles.getSelectedIndex();
            if (a != null) {
                this.profileField.setText(a.getName());
                this.upProfile.setEnabled(index > 0);
                this.downProfile.setEnabled(index < this.profilesModel.getSize() - 1);
                this.deleteProfile.setEnabled(this.profiles.isFocusOwner());
                GeneralFunction.RMIcon icon = a.icon;
                this.profileIconLabel.setIcon(icon == null ? null : icon.image);
            } else {
                this.profileField.setText("");
                this.upProfile.setEnabled(false);
                this.downProfile.setEnabled(false);
                this.deleteProfile.setEnabled(false);
                this.profileIconLabel.setIcon(null);
            }
            if (this.profileButton.isSelected()) {
                this.activityGroupModel.set(this.favBtn, this.remoteConfig, a);
                this.activityGroupTable.initColumns(this.activityGroupModel);
            }
            this.repaint();
        }
    }

    public Activity getActivity() {
        if (this.profileButton.isSelected()) {
            return (Activity)this.profiles.getSelectedValue();
        }
        Remote remote = this.remoteConfig.getRemote();
        return remote.getFavKey().getActivity();
    }

    public boolean showProfile() {
        return this.profileButton.isSelected();
    }

    private void documentChanged(DocumentEvent e) {
        Activity activity;
        Document doc = e.getDocument();
        if (doc == this.profileField.getDocument() && (activity = (Activity)this.profiles.getSelectedValue()) != null) {
            activity.setName(this.profileField.getText());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public FavScanTableModel getFavModel() {
        return this.favModel;
    }

    public ActivityGroupTableModel getActivityGroupModel() {
        return this.activityGroupModel;
    }

    public JList getProfiles() {
        return this.profiles;
    }

    public FavScan getFavorite() {
        return this.favorite;
    }

    public void setFavorite(FavScan favorite) {
        this.favorite = favorite;
    }
}

