/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class FixedData {
    private int address;
    private short[] data;
    private Location location = Location.E2;

    public FixedData(int addr, short[] data, Location location) {
        this.address = addr;
        this.data = data;
        this.location = location;
    }

    public int getAddress() {
        return this.address;
    }

    public short[] getData() {
        return this.data;
    }

    public Location getLocation() {
        return this.location;
    }

    public static FixedData[] parse(RDFReader rdr) throws Exception {
        String line;
        ArrayList<FixedData> work = new ArrayList<FixedData>();
        ArrayList<Short> temp = new ArrayList<Short>();
        int address = -1;
        int value = -1;
        Location location = Location.E2;
        Location newLocation = Location.E2;
        block0: while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, ",; \t");
            String token = st.nextToken();
            while (true) {
                if (token.equals("E2")) {
                    newLocation = Location.E2;
                } else if (token.equals("SIG")) {
                    newLocation = Location.SIGBLK;
                } else if (token.charAt(0) == '=') {
                    token = token.substring(1);
                    if (address != -1) {
                        short[] b = new short[temp.size()];
                        int i = 0;
                        for (Short val : temp) {
                            b[i++] = val;
                        }
                        work.add(new FixedData(address, b, location));
                        temp.clear();
                    }
                    address = value;
                    location = newLocation;
                    value = -1;
                    if (token.length() != 0) {
                        continue;
                    }
                } else {
                    int equal = token.indexOf(61);
                    String saved = token;
                    if (equal != -1) {
                        token = token.substring(0, equal);
                    }
                    if (value != -1) {
                        temp.add(new Short((short)value));
                    }
                    value = RDFReader.parseNumber(token);
                    if (equal != -1) {
                        token = saved.substring(equal);
                        continue;
                    }
                }
                if (!st.hasMoreTokens()) continue block0;
                token = st.nextToken();
            }
        }
        temp.add(new Short((short)value));
        short[] b = new short[temp.size()];
        int j = 0;
        for (Short by : temp) {
            b[j++] = by;
        }
        if (address != -1) {
            work.add(new FixedData(address, b, location));
        }
        return work.toArray(new FixedData[work.size()]);
    }

    public boolean check(Remote remote, short[] buffer) {
        if (buffer == null) {
            return true;
        }
        if (this.address + this.data.length > buffer.length) {
            return false;
        }
        HashMap<Integer, Integer> masks = remote != null ? remote.getSettingMasks() : null;
        for (int i = 0; i < this.data.length; ++i) {
            int mask;
            int n = mask = remote == null || masks.get(this.address + i) == null ? 255 : masks.get(this.address + i);
            if (buffer[this.address + i] >= 256 || ((this.data[i] ^ buffer[this.address + i]) & mask) == 0) continue;
            return false;
        }
        return true;
    }

    public static Remote[] filter(List<Remote> remotes, short[] buffer, short[] sigData) {
        ArrayList<Remote> passed = new ArrayList<Remote>();
        for (Remote remote : remotes) {
            boolean pass = true;
            for (FixedData fixedData : remote.getRawFixedData()) {
                if (fixedData.location == Location.E2) {
                    if (fixedData.check(remote, buffer)) continue;
                    pass = false;
                    break;
                }
                if (fixedData.check(null, sigData)) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            passed.add(remote);
        }
        return passed.toArray(new Remote[0]);
    }

    public void store(Remote remote, short[] buffer) {
        HashMap<Integer, Integer> masks = remote != null ? remote.getSettingMasks() : null;
        for (int i = 0; i < this.data.length; ++i) {
            int mask = remote == null || masks.get(this.address + i) == null ? 255 : masks.get(this.address + i);
            int val = buffer[this.address + i] & ~mask;
            buffer[this.address + i] = (short)(val |= this.data[i] & mask);
        }
    }

    public String toString() {
        StringBuilder temp = new StringBuilder(200);
        temp.append('$').append(Integer.toHexString(this.address)).append(" =");
        for (int i = 0; i < this.data.length; ++i) {
            temp.append(" $");
            String str = Integer.toHexString(this.data[i]);
            int len = str.length();
            if (len > 2) {
                str = str.substring(len - 2);
            }
            if (len < 2) {
                temp.append('0');
            }
            temp.append(str);
        }
        return temp.toString();
    }

    public static enum Location {
        E2,
        SIGBLK;

    }
}

