/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.RemoteConfiguration;
import java.util.List;
import java.util.Properties;

public class Function
extends GeneralFunction {
    private static String[][] substitutes = new String[][]{{"_", ""}, {"key", ""}, {"cmd", ""}, {"num", ""}, {"cursor", ""}, {"arrow", ""}, {"toggle", ""}, {"return", "exit"}, {"back", "exit"}, {"-", "down"}, {"\\+", "up"}, {"enter", "ok"}, {">", "play"}, {"<", "reverse"}, {"\\|\\|", "pause"}, {"ffw", "fastforward"}, {"fwd", "forward"}, {"forward", "play"}, {"volume", "vol"}, {"channel", "ch"}, {"16/9", "aspectratio"}, {"epg", "guide"}, {"hdmi", "av"}, {"playpause", "play"}, {"\\s+", ""}};
    protected Integer gid = null;
    private Integer keyflags = null;
    private int rmirIndex = -1;
    public static final int defaultGID = 0;

    public Function() {
    }

    public Function(String name, Hex hex, String notes) {
        this.name = name;
        this.data = hex;
        this.notes = notes;
    }

    public Function(String name) {
        this.name = name;
    }

    public Function(Function base) {
        this.name = base.name;
        this.gid = base.gid;
        if (base.data != null) {
            this.data = new Hex(base.data);
        }
        this.notes = base.notes;
        this.upgrade = base.upgrade;
        this.serial = base.serial;
        this.keyflags = base.keyflags;
        this.users.addAll(base.getUsers());
        if (base.icon != null) {
            this.icon = base.icon;
        }
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isEmpty() {
        return this.name == null && this.data == null && this.notes == null;
    }

    public void store(PropertyWriter out, String prefix) {
        if (this.isEmpty()) {
            out.print(prefix + ".name", "");
        }
        if (this.name != null) {
            out.print(prefix + ".name", this.name);
        }
        if (this.gid != null && this.gid != 0) {
            out.print(prefix + ".index", Integer.toString(this.gid));
        }
        if (this.keyflags != null) {
            out.print(prefix + ".keyflags", Integer.toString(this.keyflags));
        }
        if (this.serial >= 0) {
            out.print(prefix + ".serial", Integer.toString(this.serial));
        }
        if (this.data != null) {
            out.print(prefix + ".hex", this.data.toString());
        }
        if (this.notes != null) {
            out.print(prefix + ".notes", this.notes);
        }
    }

    public Integer load(Properties props, String prefix) {
        Integer macroref = null;
        String str = props.getProperty(prefix + ".name");
        if (str != null) {
            this.setName(str);
        }
        if ((str = props.getProperty(prefix + ".index")) != null) {
            this.setGid(Integer.parseInt(str));
        }
        if ((str = props.getProperty(prefix + ".keyflags")) != null) {
            this.setKeyflags(Integer.parseInt(str));
        }
        if ((str = props.getProperty(prefix + ".serial")) != null) {
            this.setSerial(Integer.parseInt(str));
        }
        if ((str = props.getProperty(prefix + ".hex")) != null) {
            this.setHex(new Hex(str));
        }
        if ((str = props.getProperty(prefix + ".macroref")) != null) {
            macroref = Integer.parseInt(str);
        }
        if ((str = props.getProperty(prefix + ".notes")) != null) {
            this.setNotes(str);
        }
        return macroref;
    }

    public Integer getGid() {
        return this.gid;
    }

    public void setGid(Integer gid) {
        this.gid = gid;
    }

    public Function setNotes(String notes) {
        this.notes = notes;
        if (this.item != null) {
            this.item.setToolTipText(notes);
        }
        if (this.label != null) {
            this.label.updateToolTipText();
        }
        return this;
    }

    public Function setHex(Hex hex) {
        this.data = hex;
        return this;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Hex getHex() {
        return this.data;
    }

    public void addReference(Button b, int state) {
        GeneralFunction.User user = new GeneralFunction.User(b, state);
        if (!this.users.contains(user)) {
            this.users.add(user);
        }
        if (this.label != null) {
            this.label.showAssigned();
            this.label.updateToolTipText();
        }
    }

    public void removeReference(Button b, int state) {
        this.users.remove(new GeneralFunction.User(b, state));
        if (this.label != null) {
            if (this.users.isEmpty()) {
                this.label.showUnassigned();
            }
            this.label.updateToolTipText();
        }
    }

    public boolean isMacroBase() {
        if (this.data != null || this.users.isEmpty()) {
            return false;
        }
        for (GeneralFunction.User u : this.users) {
            RemoteConfiguration config = null;
            boolean hasMacro = false;
            if (u.db == null || u.db == DeviceButton.noButton || u.db.getUpgrade() == null || (config = u.db.getUpgrade().getRemoteConfig()) == null) {
                return false;
            }
            for (Macro macro : config.getMacros()) {
                for (GeneralFunction.User mu : macro.getUsers()) {
                    if (!mu.equals(u)) continue;
                    hasMacro = true;
                    break;
                }
                if (!hasMacro) continue;
                break;
            }
            if (hasMacro) continue;
            return false;
        }
        return true;
    }

    public Integer getKeyflags() {
        return this.keyflags;
    }

    public void setKeyflags(Integer keyflags) {
        this.keyflags = keyflags;
    }

    public boolean isEquivalent(Function f) {
        if (this.name == null || this.data == null || f.data == null) {
            return false;
        }
        return this.name.equals(f.name) && this.upgrade == f.upgrade && this.data.equals(f.data);
    }

    public Function getEquivalent(List<Function> list) {
        for (Function f : list) {
            if (!this.isEquivalent(f)) continue;
            return f;
        }
        return null;
    }

    public boolean accept() {
        return this.data != null;
    }

    boolean matchingName(Button b) {
        return this.matchingName(b.getName()) || this.matchingName(b.getStandardName());
    }

    private boolean matchingName(String candidate) {
        String nameLower = this.name.toLowerCase();
        String candidateLower = candidate.toLowerCase();
        return this.name.equals(candidateLower) || this.canonicalize(nameLower).equals(this.canonicalize(candidateLower));
    }

    private String canonicalize(String str) {
        String work = str;
        for (String[] substitute : substitutes) {
            String from = substitute[0];
            String to = substitute[1];
            work = work.replaceAll(from, to);
        }
        return work;
    }

    public int getRmirIndex() {
        return this.rmirIndex;
    }

    public void setRmirIndex(int rmirIndex) {
        this.rmirIndex = rmirIndex;
    }
}

