/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.JTableX;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FunctionImportDialog
extends JDialog
implements ActionListener {
    private List<SelectHolder> data = new ArrayList<SelectHolder>();
    private AbstractTableModel model = null;
    private JButton selectAll = null;
    private JButton selectNone = null;
    private JButton selectToggle = null;
    private JButton ok = null;
    private JButton cancel = null;
    private int userAction = 2;

    public FunctionImportDialog(JFrame owner, DeviceUpgrade upgrade) {
        super(owner, "Import Functions", true);
        this.setLocationRelativeTo(owner);
        Container contentPane = this.getContentPane();
        JLabel instructions = new JLabel("Select the functions to be imported.");
        contentPane.add((Component)instructions, "North");
        for (Function function : upgrade.getFunctions()) {
            if (function.getName() == null || function.getName().length() <= 0 || function.getHex() == null || function.getHex().length() <= 0) continue;
            this.data.add(new SelectHolder(function));
        }
        for (Function function : upgrade.getExternalFunctions()) {
            if (function.getName() == null || function.getName().length() <= 0 || function.getHex() == null || function.getHex().length() <= 0) continue;
            this.data.add(new SelectHolder(function));
        }
        this.model = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return " ";
                    }
                    case 1: {
                        return "Function";
                    }
                    case 2: {
                        return "Notes";
                    }
                    case 3: {
                        return "Hex";
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if (col == 0) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public int getRowCount() {
                return FunctionImportDialog.this.data.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public Object getValueAt(int row, int col) {
                SelectHolder h = (SelectHolder)FunctionImportDialog.this.data.get(row);
                if (col == 0) {
                    if (h.isSelected()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                Function f = h.getData();
                if (col == 1) {
                    return f.getName();
                }
                if (col == 2) {
                    return f.getNotes();
                }
                return f.getHex().toString();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                SelectHolder h = (SelectHolder)FunctionImportDialog.this.data.get(row);
                h.setSelected((Boolean)value);
            }
        };
        JTableX table = new JTableX(this.model);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setShowGrid(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn column = tableColumnModel.getColumn(0);
        JCheckBox box = new JCheckBox();
        box.setSelected(true);
        column.setMaxWidth(box.getPreferredSize().width);
        contentPane.add((Component)new JScrollPane(table), "Center");
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.selectAll = new JButton("Select All");
        this.selectAll.addActionListener(this);
        buttonPanel.add(this.selectAll);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.selectNone = new JButton("Select None");
        this.selectNone.addActionListener(this);
        buttonPanel.add(this.selectNone);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.selectToggle = new JButton("Toggle");
        this.selectToggle.addActionListener(this);
        buttonPanel.add(this.selectToggle);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.selectAll || source == this.selectNone) {
            boolean flag = source == this.selectAll;
            for (SelectHolder h : this.data) {
                h.setSelected(flag);
            }
            this.model.fireTableDataChanged();
        } else if (source == this.selectToggle) {
            for (SelectHolder h : this.data) {
                h.setSelected(!h.isSelected());
            }
            this.model.fireTableDataChanged();
        } else if (source == this.cancel) {
            this.userAction = 2;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.ok) {
            this.userAction = 0;
            this.setVisible(false);
            this.dispose();
        }
    }

    public List<Function> getSelectedFunctions() {
        ArrayList<Function> v = new ArrayList<Function>();
        for (SelectHolder h : this.data) {
            if (!h.isSelected()) continue;
            v.add(h.getData());
        }
        return v;
    }

    public int getUserAction() {
        return this.userAction;
    }

    public class SelectHolder {
        private boolean selected = false;
        private Function data = null;

        public SelectHolder(Function f) {
            this.data = f;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean flag) {
            this.selected = flag;
        }

        public Function getData() {
            return this.data;
        }
    }

    public class SelectionRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public SelectionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setText(value.toString());
            this.setSelected(isSelected);
            return this;
        }
    }
}

