/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LocalObjectTransferable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;

public class FunctionLabel
extends JLabel {
    private GeneralFunction function = null;
    private static MouseMotionAdapter ml = null;
    private static TransferHandler th = null;

    public FunctionLabel(GeneralFunction function) {
        if (function == null) {
            this.setText("- none -");
        } else {
            String text = function.getName();
            if (text.length() > 20) {
                text = text.substring(0, 17) + "...";
            }
            this.setText(function.getName());
            if (function.assigned()) {
                this.showAssigned();
            } else {
                this.showUnassigned();
            }
        }
        this.setHorizontalAlignment(0);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(2, 5, 3, 5));
        this.setBorder(border);
        if (th == null) {
            th = new TransferHandler(){

                @Override
                protected Transferable createTransferable(JComponent c) {
                    return new LocalObjectTransferable(((FunctionLabel)c).function);
                }

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }
            };
        }
        this.setTransferHandler(th);
        if (ml == null) {
            ml = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    JComponent c = (JComponent)e.getSource();
                    TransferHandler th = c.getTransferHandler();
                    th.exportAsDrag(c, e, 1);
                }
            };
        }
        this.addMouseMotionListener(ml);
        this.function = function;
        this.updateToolTipText();
    }

    public GeneralFunction getFunction() {
        return this.function;
    }

    public void updateToolTipText() {
        StringBuilder buff = new StringBuilder(400);
        JLabel lbl = new JLabel();
        int width = 0;
        if (this.function == null) {
            buff.append("&nbsp;Drag or double-click this function to<br>&nbsp;clear the function performed by a button.");
        } else {
            buff.append("&nbsp;Drag or double-click this function to<br>&nbsp;set the function performed by a button.");
            if (this.function.getNotes() != null) {
                buff.append("<br><hr>&nbsp;" + this.function.getNotes());
            }
            if (!this.function.getUsers().isEmpty()) {
                buff.append("<br><hr>&nbsp;" + this.function.getName() + " is assigned to: ");
            }
            lbl.setText("<html>" + buff.toString() + "</html>");
            width = lbl.getPreferredSize().width;
            boolean first = true;
            for (GeneralFunction.User user : this.function.getUsers()) {
                buff.append(first ? "" : ",");
                String s = buff.toString() + " " + user.getUserName();
                lbl.setText("<html>" + s + "</html>");
                buff.append(lbl.getPreferredSize().width > width ? "<br/>" : " ");
                buff.append(user.getUserName());
                lbl.setText("<html>" + buff.toString() + "</html>");
                width = lbl.getPreferredSize().width;
                first = false;
            }
        }
        String str = JTableX.getHtmlToolTip(buff.toString());
        this.setToolTipText(str);
    }

    public void showAssigned() {
        this.setForeground(Color.black);
    }

    public void showUnassigned() {
        this.setForeground(Color.red);
    }

    public void showAssigned(DeviceButton db) {
        if (this.function.assigned(db)) {
            this.showAssigned();
        } else {
            this.showUnassigned();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width > 180) {
            d.width = 180;
        }
        return d;
    }
}

