/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionTableModel;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.TablePanel;
import com.hifiremote.jp1.TableSorter;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;

public class FunctionPanel
extends TablePanel<Function> {
    private JLabel iconLabel = null;

    public FunctionPanel(DeviceUpgrade devUpgrade) {
        super("Functions", devUpgrade, new FunctionTableModel(devUpgrade));
        Remote remote = devUpgrade.getRemote();
        RemoteConfiguration remoteConfig = devUpgrade.getRemoteConfig();
        this.iconLabel = new JLabel("   ");
        this.iconLabel.setPreferredSize(new Dimension(100, 40));
        this.iconLabel.setHorizontalTextPosition(10);
        this.iconLabel.setVisible(remote.isSSD() && remoteConfig != null);
        this.buttonPanel.add(Box.createVerticalStrut(this.iconLabel.getPreferredSize().height));
        this.buttonPanel.add(this.iconLabel);
    }

    @Override
    public void setDeviceUpgrade(DeviceUpgrade deviceUpgrade) {
        ((FunctionTableModel)this.model).setDeviceUpgrade(deviceUpgrade);
        super.setDeviceUpgrade(deviceUpgrade);
        Remote remote = deviceUpgrade.getRemote();
        RemoteConfiguration config = deviceUpgrade.getRemoteConfig();
        this.iconLabel.setVisible(remote.isSSD() && config != null);
    }

    @Override
    public void update() {
        if (this.deviceUpgrade == null) {
            return;
        }
        Protocol p = this.deviceUpgrade.getProtocol();
        p.initializeParms();
        ((FunctionTableModel)this.model).setDeviceUpgrade(this.deviceUpgrade);
        this.initColumns();
        super.update();
    }

    @Override
    protected Function createRowObject() {
        Function f = new Function();
        f.setUpgrade(this.deviceUpgrade);
        if (this.deviceUpgrade.getRemote().usesEZRC()) {
            f.setGid(0);
        }
        if (this.deviceUpgrade.getRemote().isSSD()) {
            f.icon = new GeneralFunction.RMIcon(9);
        }
        return f;
    }

    @Override
    protected void delete(Function f) {
        ArrayList<GeneralFunction.User> users = new ArrayList<GeneralFunction.User>(f.getUsers());
        for (GeneralFunction.User user : users) {
            this.deviceUpgrade.setFunction(user.button, null, user.state);
        }
    }

    @Override
    protected boolean canDelete(Function f) {
        return Boolean.parseBoolean(JP1Frame.properties.getProperty("SuppressConfirmPrompts", "false")) || !f.assigned();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            if (this.table.getSelectedRowCount() == 1) {
                int row = this.table.getSelectedRow();
                TableSorter sorter = (TableSorter)this.table.getModel();
                row = sorter.modelIndex(row);
                FunctionTableModel model = (FunctionTableModel)sorter.getTableModel();
                Function f = (Function)model.getRow(row);
                GeneralFunction.RMIcon icon = f.icon;
                this.iconLabel.setIcon(icon == null ? null : icon.image);
            } else {
                this.iconLabel.setIcon(null);
            }
        }
    }
}

