/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class FunctionRenderer
extends DefaultTableCellRenderer {
    private DeviceUpgrade deviceUpgrade = null;

    public FunctionRenderer(DeviceUpgrade deviceUpgrade) {
        this.deviceUpgrade = deviceUpgrade;
        this.setToolTipText("Drag or double-click a function to set the functions for a button, or use the popup menu of available functions.");
    }

    public void setDeviceUpgrade(DeviceUpgrade deviceUpgrade) {
        this.deviceUpgrade = deviceUpgrade;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Button b = (Button)value;
        String temp = null;
        JTextField tf = new JTextField();
        if (this.deviceUpgrade == null) {
            return null;
        }
        DeviceType devType = this.deviceUpgrade.getDeviceType();
        ButtonMap map = devType.getButtonMap();
        if (col == 0) {
            boolean unassigned;
            boolean bl = unassigned = this.deviceUpgrade.getFunction(b, 0) == null && this.deviceUpgrade.getFunction(b, 1) == null && this.deviceUpgrade.getFunction(b, 2) == null;
            if (this.deviceUpgrade.getRemote().usesEZRC()) {
                short keyCode = b.getKeyCode();
                boolean bl2 = unassigned = unassigned && this.deviceUpgrade.getMacroMap().get(keyCode) == null && this.deviceUpgrade.getLearnedMap().get(keyCode) == null;
            }
            if (unassigned) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
            temp = b.getName();
            if (map == null || !map.isPresent(b)) {
                temp = temp + '*';
            }
        } else {
            Function f = null;
            if (col == 1) {
                f = this.deviceUpgrade.getFunction(b, 0);
                if (!b.allowsKeyMove() && !map.isPresent(b)) {
                    tf.setEditable(false);
                }
            } else if (col == 2) {
                f = this.deviceUpgrade.getFunction(b, 1);
                if (!b.allowsShiftedKeyMove()) {
                    tf.setEditable(false);
                }
            } else if (col == 3) {
                f = this.deviceUpgrade.getFunction(b, 2);
                if (!b.allowsXShiftedKeyMove()) {
                    tf.setEditable(false);
                }
            }
            if (f != null) {
                temp = f.getName();
            }
        }
        this.setBackground(tf.getBackground());
        JComponent c = (JComponent)super.getTableCellRendererComponent(table, temp, isSelected, hasFocus, row, col);
        return c;
    }
}

