/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.EFCEditor;
import com.hifiremote.jp1.EFCRenderer;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexEditor;
import com.hifiremote.jp1.HexRenderer;
import com.hifiremote.jp1.KMTableModel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.RowNumberRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class FunctionTableModel
extends KMTableModel<Function> {
    private Protocol protocol = null;
    private Remote remote = null;
    private RemoteConfiguration remoteConfig = null;
    private DeviceUpgrade deviceUpgrade = null;
    private static final int rowCol = 0;
    private static final int nameCol = 1;
    private int gidCol = -1;
    private int efcCol = 2;
    private int efc5col = -1;
    private int colOffset;
    private int hexCol = this.colOffset = this.efcCol + 1;
    private int notesCol = this.hexCol + 1;
    private int lastCell = 0;

    public FunctionTableModel(DeviceUpgrade deviceUpgrade) {
        if (deviceUpgrade != null) {
            this.setDeviceUpgrade(deviceUpgrade);
        }
    }

    public void setDeviceUpgrade(DeviceUpgrade deviceUpgrade) {
        if (deviceUpgrade == null || deviceUpgrade.getProtocol() == null) {
            return;
        }
        ArrayList<Function> list = new ArrayList<Function>();
        for (Function f : deviceUpgrade.getFunctions()) {
            if (f.isMacroBase()) continue;
            list.add(f);
        }
        this.setData(list);
        this.deviceUpgrade = deviceUpgrade;
        this.remoteConfig = deviceUpgrade.getRemoteConfig();
        this.setProtocol(deviceUpgrade.getProtocol(), deviceUpgrade.getRemote());
        this.functionsUpdated();
    }

    public void functionsUpdated() {
        this.fireTableStructureChanged();
    }

    public void setProtocol(Protocol protocol, Remote remote) {
        this.protocol = protocol;
        this.remote = remote;
        if (remote.usesEZRC() && RemoteMaster.admin) {
            this.gidCol = 2;
            this.efcCol = this.gidCol + 1;
        } else {
            this.gidCol = -1;
            this.efcCol = 2;
        }
        this.colOffset = this.efcCol + 1;
        if (remote != null && remote.getEFCDigits() == 5) {
            this.efc5col = this.efcCol;
            this.efcCol = this.colOffset++;
        } else {
            this.efc5col = -1;
        }
        this.hexCol = protocol.getColumnCount() + this.colOffset;
        this.notesCol = this.hexCol + 1;
        this.fireTableStructureChanged();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public int getColumnCount() {
        if (this.protocol == null) {
            return 0;
        }
        int rc = 5;
        if (this.remote != null && this.remote.getEFCDigits() == 5) {
            ++rc;
        }
        if (this.remote.usesEZRC() && RemoteMaster.admin) {
            ++rc;
        }
        if (this.protocol != null) {
            rc += this.protocol.getColumnCount();
        }
        return rc;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Function function = (Function)this.data.get(row);
        Hex hex = function.getHex();
        Object rc = "";
        if (col == 0) {
            rc = new Integer(row + 1);
        } else if (col == 1) {
            rc = function.getName();
        } else if (col == this.gidCol) {
            rc = String.format("%4X", function.getGid());
        } else if (col == this.efcCol) {
            if (hex == null) {
                return null;
            }
            rc = new EFC(hex, this.protocol.getCmdIndex());
        } else if (col == this.efc5col) {
            if (hex == null) {
                return null;
            }
            rc = new EFC5(hex);
        } else {
            rc = col == this.notesCol ? function.getNotes() : (col == this.hexCol ? hex : (hex == null ? null : this.protocol.getValueAt(col - this.colOffset, hex)));
        }
        return rc;
    }

    public void checkFunctionAssigned(Function f, Object value) throws IllegalArgumentException {
        if (value == null && f.assigned()) {
            String msg = "Function " + f.getName() + " is assigned to a button, and must not be cleared!";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Function function = (Function)this.data.get(row);
        if (col == 1) {
            String text = (String)value;
            if (text != null && text.length() == 0) {
                text = null;
            }
            this.checkFunctionAssigned(function, text);
            function.setName(text);
            if (function.getGid() != null && function.getGid() == 0) {
                function.setGid(this.deviceUpgrade.getGidForName(text));
                this.remoteConfig.addGid(function.name, function.getGid());
                this.deviceUpgrade.getKeyGidMap().put(function.getGid(), function);
            }
        } else if (col == this.efcCol) {
            this.checkFunctionAssigned(function, value);
            if (value == null) {
                function.setHex(null);
            } else {
                Hex hex = function.getHex();
                if (hex == null) {
                    hex = this.protocol.getDefaultCmd();
                }
                if (value.getClass() == String.class) {
                    EFC.toHex(Short.parseShort((String)value), hex, this.protocol.getCmdIndex());
                } else {
                    ((EFC)value).toHex(hex, this.protocol.getCmdIndex());
                }
                function.setHex(hex);
            }
        } else if (col == this.efc5col) {
            this.checkFunctionAssigned(function, value);
            if (value == null) {
                function.setHex(null);
            } else {
                Hex hex = function.getHex();
                if (hex == null) {
                    hex = this.protocol.getDefaultCmd();
                }
                if (value.getClass() == String.class) {
                    EFC5.toHex(Integer.parseInt((String)value), hex);
                } else {
                    ((EFC5)value).toHex(hex);
                }
                function.setHex(hex);
            }
        } else if (col == this.hexCol) {
            this.checkFunctionAssigned(function, value);
            if (value != null && value.getClass() == String.class) {
                value = new Hex((String)value);
            }
            Hex hex = (Hex)value;
            function.setHex(hex);
        } else if (col == this.notesCol) {
            function.setNotes((String)value);
        } else {
            CmdParameter[] cmdParms = this.protocol.getCommandParameters();
            int parmIndex = col - this.colOffset;
            DefaultValue defaultValue = cmdParms[parmIndex].getDefaultValue();
            System.err.println("FunctionTableModel.setValueAt(): defaultValue is " + defaultValue);
            if (defaultValue != null) {
                this.checkFunctionAssigned(function, value);
            }
            if (value == null && defaultValue != null) {
                value = defaultValue.value();
            }
            System.err.println("FunctionTableModel.setValueAt(): value is " + value);
            if (value == null && !cmdParms[parmIndex].isOptional()) {
                function.setHex(null);
            } else {
                Hex hex = function.getHex();
                if (hex == null) {
                    hex = this.protocol.getDefaultCmd();
                    function.setHex(hex);
                }
                this.protocol.setValueAt(parmIndex, hex, value);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int col) {
        String rc = null;
        rc = col == 0 ? "#" : (col == 1 ? "Name" : (col == this.gidCol ? "KeyGID" : (col == this.efcCol ? "EFC" : (col == this.efc5col ? "EFC5" : (col == this.hexCol ? "Hex" : (col == this.notesCol ? "Notes" : this.protocol.getColumnName(col - this.colOffset)))))));
        return rc;
    }

    @Override
    public String getColumnPrototypeName(int col) {
        String rc = null;
        rc = col == 0 ? "199" : (col == 1 ? "Function Name" : (col == this.gidCol ? "00000_" : (col == this.efcCol ? "CCC" : (col == this.efc5col ? "00000" : (col == this.hexCol ? "CC CC CC CC" : (col == this.notesCol ? "A reasonable length function comment" : this.protocol.getColumnName(col - this.colOffset)))))));
        if (rc.length() < 5) {
            rc = "XXXXX";
        }
        return rc;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Class rc = null;
        rc = col == 1 || col == this.notesCol || col == this.gidCol ? String.class : (col == 0 ? Integer.class : (col == this.efcCol ? EFC.class : (col == this.efc5col ? EFC5.class : (col == this.hexCol ? byte[].class : this.protocol.getColumnClass(col - this.colOffset)))));
        return rc;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean rc = false;
        rc = col == 0 || col == this.gidCol ? false : (col <= this.hexCol || col == this.notesCol ? true : this.protocol.isEditable(col - this.colOffset));
        return rc;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (this.remote == null || this.protocol == null || col == 0 || col == 1 || col == this.notesCol || col == this.gidCol) {
            return null;
        }
        if (col == this.efcCol) {
            return new EFCEditor(3);
        }
        if (col == this.efc5col) {
            return new EFCEditor(5);
        }
        if (col == this.hexCol) {
            return new HexEditor(this.protocol.getDefaultCmd());
        }
        return this.protocol.getColumnEditor(col - this.colOffset);
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        Object rc = null;
        rc = col == 0 ? new RowNumberRenderer() : (col == 1 || col == this.notesCol || col == this.gidCol ? null : (col == this.efcCol ? new EFCRenderer() : (col == this.efc5col ? new EFCRenderer() : (col == this.hexCol ? new HexRenderer() : this.protocol.getColumnRenderer(col - this.colOffset)))));
        return rc;
    }

    public void setRemoteConfig(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        if (col == 0 || col == 1 || col == this.notesCol || col == this.efcCol || col == this.efc5col || col == this.hexCol) {
            return super.isColumnWidthFixed(col);
        }
        if (col == this.gidCol) {
            return true;
        }
        return this.protocol.isColumnWidthFixed(col - this.colOffset);
    }

    @Override
    public String getToolTipText(int row, int col) {
        int thisCell = row + col * 256;
        if (thisCell == this.lastCell) {
            return null;
        }
        this.lastCell = thisCell;
        return null;
    }

    @Override
    public void moveRow(int from, int to) {
        Function fn1 = (Function)this.data.get(from);
        Function fn2 = (Function)this.data.get(to);
        List<Function> functions = this.deviceUpgrade.getFunctions();
        int ndx1 = functions.indexOf(fn1);
        int ndx2 = functions.indexOf(fn2);
        functions.remove(ndx1);
        functions.add(ndx2, fn1);
        super.moveRow(from, to);
    }

    @Override
    public void insertRow(int row, Function value) {
        Function fn = (Function)this.data.get(row);
        List<Function> functions = this.deviceUpgrade.getFunctions();
        int ndx = functions.indexOf(fn);
        functions.add(ndx, value);
        super.insertRow(row, value);
    }

    @Override
    public void addRow(Function value) {
        List<Function> functions = this.deviceUpgrade.getFunctions();
        functions.add(value);
        super.addRow(value);
    }

    @Override
    public void removeRow(int row) {
        Function fn = (Function)this.data.get(row);
        List<Function> functions = this.deviceUpgrade.getFunctions();
        int ndx = functions.indexOf(fn);
        functions.remove(ndx);
        super.removeRow(row);
    }
}

