/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.GeneralEditorPanel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class GeneralEditorNode
extends ProtocolEditorNode {
    private String name = null;
    private String oldNames = null;
    private Hex id = null;
    private Hex altId = null;
    private HashMap<String, Hex> codes = new HashMap(6);
    private static GeneralEditorPanel editorPanel = null;
    private static Hex nullHex = null;

    public GeneralEditorNode() {
        super("General Settings", false);
        if (nullHex == null) {
            nullHex = new Hex();
        }
        this.id = nullHex;
        this.altId = nullHex;
    }

    @Override
    public ProtocolEditorPanel getEditingPanel() {
        if (editorPanel == null) {
            editorPanel = new GeneralEditorPanel();
        }
        return editorPanel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public String getOldNames() {
        return this.oldNames;
    }

    public void setOldNames(String newNames) {
        this.oldNames = newNames;
    }

    public Hex getId() {
        return this.id;
    }

    public void setId(Hex newId) {
        if (newId == null) {
            newId = nullHex;
        }
        this.id = newId;
    }

    public Hex getAltId() {
        return this.altId;
    }

    public void setAltId(Hex newId) {
        if (newId == null) {
            newId = nullHex;
        }
        this.altId = newId;
    }

    public Set<String> getKeys() {
        return this.codes.keySet();
    }

    public void addCode(String processor, Hex code) {
        Hex oldCode = this.getCode(processor);
        this.codes.put(processor, code);
        this.firePropertyChange("Code", oldCode, code);
    }

    public Hex getCode(String processor) {
        return this.codes.get(processor);
    }

    public void removeCode(String processor) {
        if (this.codes.size() == 1 && this.codes.containsKey(processor)) {
            Hex oldValue = this.getCode(processor);
            this.codes.remove(processor);
            this.firePropertyChange("Code", oldValue, null);
        }
    }

    @Override
    public void print(PrintWriter pw) {
        pw.println("[" + this.name + "]");
        if (this.oldNames != null && !this.oldNames.equals("")) {
            pw.println("OldNames=" + this.oldNames);
        }
        pw.println("PID=" + this.id.toString());
        if (this.altId != null && this.altId.length() > 0) {
            pw.println("AlternatePID=" + this.altId.toString());
        }
        for (String key : this.getKeys()) {
            Hex hex = this.getCode(key);
            if (hex == null || hex.length() == 0) continue;
            pw.println("Code." + key + '=' + hex);
        }
    }
}

