/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.GeneralEditorNode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexEditor;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import com.hifiremote.jp1.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;

public class GeneralEditorPanel
extends ProtocolEditorPanel
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    private GeneralEditorNode node = null;
    private JTextField name = null;
    private JTextField oldNames = null;
    private JFormattedTextField id = null;
    private JFormattedTextField altId = null;
    private TableModel tableModel = null;
    private JButton importButton = null;
    private static String[] colNames = new String[]{"Processor", "Protocol Code"};
    private static Class<?>[] classes = new Class[]{String.class, Hex.class};
    private static String[] procNames = new String[]{"S3C80", "740", "6805-C9", "6805-RC16/18", "S3F80"};

    public GeneralEditorPanel() {
        super("General Settings");
        int i;
        JPanel contentPane = new JPanel(new BorderLayout());
        this.add((Component)contentPane, "Center");
        SpringLayout layout = new SpringLayout();
        JPanel formPanel = new JPanel(layout);
        contentPane.add((Component)formPanel, "North");
        this.name = new JTextField(20);
        this.oldNames = new JTextField();
        MaskFormatter f = null;
        try {
            f = new MaskFormatter("HH HH");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        f.setValueClass(Hex.class);
        this.id = new JFormattedTextField(f);
        this.id.addPropertyChangeListener("value", this);
        this.altId = new JFormattedTextField(f);
        this.altId.addPropertyChangeListener("value", this);
        String[] labels = new String[]{"Name", "Old names", "ID", "Alternate ID"};
        JTextField[] fields = new JTextField[]{this.name, this.oldNames, this.id, this.altId};
        String[] toolTipText = new String[]{"Enter the name of the protocol.  This is a required field.", "Enter the names, separated by commas, that have been used for this protocol, or have been used by KM.", "Enter the hex identifier for this protocol.  This is a required fields.", "Enter the alternate ID for this protocol."};
        int numPairs = labels.length;
        for (int i2 = 0; i2 < numPairs; ++i2) {
            JLabel l = new JLabel(labels[i2], 11);
            formPanel.add(l);
            JTextField textField = fields[i2];
            int height = textField.getPreferredSize().height;
            Dimension d = textField.getMaximumSize();
            d.height = height;
            textField.setMaximumSize(d);
            textField.getDocument().addDocumentListener(this);
            l.setLabelFor(textField);
            textField.setToolTipText(toolTipText[i2]);
            formPanel.add(textField);
        }
        SpringUtilities.makeCompactGrid(formPanel, numPairs, 2, 5, 5, 5, 5);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel tablePanel = new JPanel(new BorderLayout());
        panel.add((Component)tablePanel, "North");
        contentPane.add((Component)panel, "Center");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Protocol code"));
        this.tableModel = new TableModel();
        JTableX table = new JTableX(this.tableModel);
        DefaultTableCellRenderer r = (DefaultTableCellRenderer)table.getDefaultRenderer(String.class);
        r.setHorizontalAlignment(0);
        table.setDefaultEditor(Hex.class, new HexEditor());
        tablePanel.add((Component)table.getTableHeader(), "North");
        tablePanel.add((Component)table, "Center");
        JLabel l = new JLabel(colNames[0]);
        l.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        int width = l.getPreferredSize().width;
        for (i = 0; i < procNames.length; ++i) {
            l.setText(procNames[i]);
            width = Math.max(width, l.getPreferredSize().width);
        }
        for (i = 0; i < procNames.length; ++i) {
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setPreferredWidth(width);
        }
        table.doLayout();
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        tablePanel.add((Component)buttonPanel, "South");
        this.importButton = new JButton("Import from clipboard");
        this.importButton.addActionListener(this);
        this.importButton.setToolTipText("Import protocol code from the clipboard");
        buttonPanel.add(this.importButton);
        this.setText("Enter the requested information about the protocol.");
    }

    @Override
    public void commit() {
    }

    @Override
    public void update(ProtocolEditorNode newNode) {
        this.node = (GeneralEditorNode)newNode;
        this.name.setText(this.node.getName());
        this.oldNames.setText(this.node.getOldNames());
        this.id.setText(this.node.getId().toString());
        this.altId.setText(this.node.getAltId().toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.importButton) {
            System.err.println("importButton pressed");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(clipboard);
            if (clipData != null) {
                try {
                    if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                        System.err.println("text is " + s);
                        this.importProtocolCode(s);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    public void docChanged(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.name.getDocument()) {
            this.node.setName(this.name.getText());
        } else if (doc == this.oldNames.getDocument()) {
            this.node.setOldNames(this.oldNames.getText());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.id) {
            this.node.setId((Hex)this.id.getValue());
        } else if (source == this.altId) {
            this.node.setAltId((Hex)this.altId.getValue());
        }
    }

    private void importProtocolCode(String string) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        String text = null;
        String processor = null;
        while (st.hasMoreTokens()) {
            String temp;
            while (st.hasMoreTokens()) {
                text = st.nextToken().toUpperCase();
                System.err.println("got '" + text);
                if (!text.startsWith("UPGRADE PROTOCOL 0 =")) continue;
                StringTokenizer st2 = new StringTokenizer(text, "()=");
                st2.nextToken();
                String pidStr = st2.nextToken().trim();
                System.err.println("Imported pid is " + pidStr);
                processor = st2.nextToken().trim();
                System.err.println("processorName is " + processor);
                if (processor.startsWith("S3C8")) {
                    processor = "S3C80";
                }
                if (!st2.hasMoreTokens()) break;
                String importedName = st2.nextToken().trim();
                System.err.println("importedName is " + importedName);
                break;
            }
            if (!st.hasMoreTokens()) continue;
            text = st.nextToken();
            while (st.hasMoreTokens() && !(temp = st.nextToken()).equals("End")) {
                text = text + ' ' + temp;
            }
            System.err.println("getting processor with name " + processor);
            Processor p = ProcessorManager.getProcessor(processor);
            if (p != null) {
                processor = p.getFullName();
            }
            System.err.println("Adding code for processor " + processor);
            System.err.println("Code is " + text);
            this.node.addCode(processor, new Hex(text));
            for (int i = 0; i < procNames.length; ++i) {
                if (!procNames[i].equals(processor)) continue;
                this.tableModel.fireTableRowsUpdated(i, i);
            }
        }
    }

    public class TableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return procNames.length;
        }

        @Override
        public int getColumnCount() {
            return colNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return colNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return classes[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return procNames[row];
            }
            return GeneralEditorPanel.this.node.getCode(procNames[row]);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                if (value != null) {
                    GeneralEditorPanel.this.node.addCode(procNames[row], (Hex)value);
                } else {
                    GeneralEditorPanel.this.node.removeCode(procNames[row]);
                }
                GeneralEditorPanel.this.tableModel.fireTableRowsUpdated(row, row);
            }
        }
    }
}

