/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionItem;
import com.hifiremote.jp1.FunctionLabel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMSetter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class GeneralFunction {
    protected Hex data = null;
    protected String name = null;
    protected int deviceButtonIndex = -1;
    protected int keyCode = 0;
    protected int serial = -1;
    protected String notes = null;
    protected List<User> users = new ArrayList<User>();
    protected FunctionLabel label = null;
    protected FunctionItem item = null;
    protected DeviceUpgrade upgrade = null;
    protected RMIcon icon = null;

    public GeneralFunction() {
    }

    public GeneralFunction(String name) {
        this.name = name;
    }

    public GeneralFunction(Properties props) {
        this.name = props.getProperty("Name");
        this.notes = props.getProperty("Notes");
        String temp = props.getProperty("Data");
        if (temp != null) {
            this.data = new Hex(temp);
            this.notes = props.getProperty("Notes");
        }
    }

    public int getDeviceButtonIndex() {
        return this.deviceButtonIndex;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        if (this.keyCode != keyCode) {
            this.keyCode = keyCode;
        }
    }

    public void setDeviceButtonIndex(int deviceButtonIndex) {
        this.deviceButtonIndex = deviceButtonIndex;
    }

    public Hex getData() {
        return this.data;
    }

    public void setData(Hex hex) {
        this.data = hex;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName(Remote remote) {
        if (this instanceof Macro && !((Macro)this).isSystemMacro()) {
            return "Macro: " + this.name;
        }
        if (this instanceof LearnedSignal) {
            if (this.name != null) {
                return "Learn: " + this.name;
            }
            Button btn = remote.getButton(((LearnedSignal)this).getKeyCode());
            return "Learn: " + btn.getName();
        }
        return this.name;
    }

    public boolean assigned() {
        return !this.getUsers().isEmpty();
    }

    public boolean assigned(DeviceButton db) {
        DeviceUpgrade upg = null;
        if (db != null && db != DeviceButton.noButton && (upg = db.getUpgrade()) != null && upg.getRemote().usesEZRC()) {
            for (User u : this.users) {
                LinkedHashMap<Integer, LearnedSignal> learnedMap = db.getUpgrade().getLearnedMap();
                if (u.db != db || !(this instanceof LearnedSignal) && learnedMap.get(u.button.getKeyCode()) != null) continue;
                return true;
            }
            return false;
        }
        return this.assigned();
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void addReference(DeviceButton db, Button b) {
        this.addReference(db, b, db.getUpgrade());
    }

    public void addReference(DeviceButton db, Button b, DeviceUpgrade du) {
        User user;
        if (this instanceof Highlight) {
            GeneralFunction gf;
            if (this.users.size() == 0 && this.deviceButtonIndex == DeviceButton.noButton.getDeviceButtonIndex()) {
                this.deviceButtonIndex = db.getDeviceButtonIndex();
                this.keyCode = b.getKeyCode();
            }
            if (du != null && du.getMacroMap() != null && this instanceof Macro) {
                du.getMacroMap().put(Integer.valueOf(b.getKeyCode()), (Macro)this);
            }
            if (du != null && du.getLearnedMap() != null && this instanceof LearnedSignal) {
                du.getLearnedMap().put(Integer.valueOf(b.getKeyCode()), (LearnedSignal)this);
            }
            Macro m = null;
            if (this instanceof Macro && (m = (Macro)this).isSystemMacro() && m.getItems().size() > 0 && (gf = m.getItems().get((int)0).fn) != null) {
                gf.addReference(db, b, du);
            }
        }
        if (!this.users.contains(user = new User(db, b))) {
            this.users.add(user);
        }
        if (this.label != null) {
            this.label.showAssigned(db);
            this.label.updateToolTipText();
        }
    }

    public void resetAssignment() {
        if (this instanceof Macro) {
            if (this.users.size() > 0) {
                User u = this.users.get(0);
                this.setDeviceButtonIndex(u.db.getButtonIndex());
                this.setKeyCode(u.button.getKeyCode());
            } else {
                this.setDeviceButtonIndex(-1);
                this.setKeyCode(0);
            }
        }
    }

    public void removeReference(DeviceButton db, Button b) {
        this.removeReference(db, b, db.getUpgrade());
    }

    public void removeReference(DeviceButton db, Button b, DeviceUpgrade du) {
        this.users.remove(new User(db, b));
        if (this instanceof Highlight && this.deviceButtonIndex != -1) {
            GeneralFunction gf;
            if (this.users.size() > 0) {
                User u = this.users.get(0);
                this.setDeviceButtonIndex(u.db.getButtonIndex());
                this.setKeyCode(u.button.getKeyCode());
            } else {
                this.setDeviceButtonIndex(-1);
                this.setKeyCode(0);
            }
            if (du != null && du.getMacroMap() != null && this instanceof Macro) {
                du.getMacroMap().remove(b.getKeyCode());
            } else if (du != null && du.getLearnedMap() != null && this instanceof LearnedSignal) {
                du.getLearnedMap().remove(b.getKeyCode());
            }
            Macro m = null;
            if (this instanceof Macro && (m = (Macro)this).isSystemMacro() && m.getItems().size() > 0 && (gf = m.getItems().get((int)0).fn) != null) {
                gf.removeReference(db, b, du);
            }
        }
        if (this.label != null) {
            this.label.showAssigned(db);
            this.label.updateToolTipText();
        }
    }

    public void removeReferences() {
        this.users.clear();
        if (this.label != null) {
            this.label.showUnassigned();
            this.label.updateToolTipText();
        }
    }

    public FunctionLabel getLabel() {
        if (this.label == null) {
            this.label = new FunctionLabel(this);
            this.label.updateToolTipText();
            if (this.assigned()) {
                this.label.showAssigned();
            }
        }
        return this.label;
    }

    public FunctionItem getFunctionItem() {
        if (this.item == null) {
            this.item = new FunctionItem(this);
        }
        return this.item;
    }

    public boolean hasData() {
        if (this.data != null) {
            return true;
        }
        if (!(this instanceof AdvancedCode)) {
            return false;
        }
        AdvancedCode a = (AdvancedCode)this;
        return a.getItems() != null;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    public DeviceUpgrade getUpgrade(Remote remote) {
        if (this instanceof Function) {
            return this.upgrade;
        }
        DeviceButton db = remote.getDeviceButton(this.deviceButtonIndex);
        if (db == null) {
            return null;
        }
        return db.getUpgrade();
    }

    public void setUpgrade(DeviceUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public boolean accept(boolean includeActivities) {
        if (this instanceof Function) {
            Function f = (Function)this;
            return f.accept();
        }
        if (this instanceof Macro) {
            Macro m = (Macro)this;
            return !m.isSystemMacro() && (includeActivities || m.getActivity() == null);
        }
        return true;
    }

    public String toString() {
        if (this instanceof Function) {
            return this.name;
        }
        if (this instanceof Macro) {
            return "Macro: " + this.name;
        }
        if (this instanceof LearnedSignal) {
            return "Learn: " + this.name;
        }
        return "Button: " + this.name;
    }

    public void store(PropertyWriter pw) {
        if (this.name != null) {
            pw.print("Name", this.name);
        }
        if (this.data != null) {
            pw.print("Data", this.data);
        }
        if (this.notes != null && !this.notes.trim().isEmpty()) {
            pw.print("Notes", this.notes);
        }
        if (this.icon != null && this.icon.ref > 0) {
            pw.print("Iconref", this.icon.ref);
        }
    }

    protected User setReference(RemoteConfiguration remoteConfig) {
        User u = null;
        if (remoteConfig != null) {
            DeviceButton db = remoteConfig.getRemote().getDeviceButton(this.deviceButtonIndex);
            if (db == null) {
                return null;
            }
            DeviceUpgrade upg = db.getUpgrade();
            if (upg != null) {
                u = this.setReference(upg);
            }
        }
        return u;
    }

    protected User setReference(DeviceUpgrade upgrade) {
        User u = null;
        if (upgrade != null) {
            Remote remote = upgrade.getRemote();
            DeviceButton db = remote.getDeviceButton(this.deviceButtonIndex);
            Button b = remote.getButton(this.keyCode);
            u = new User(db, b);
            this.addReference(db, b);
        }
        return u;
    }

    public static class RMIcon {
        int type = 0;
        Hex intro = new Hex(new short[]{0, 0, 0, 0, 0, 0, 0, 0});
        ImageIcon image = null;
        int ref = 0;

        public RMIcon() {
        }

        public RMIcon(int type) {
            this.type = type;
        }

        public RMIcon(RMIcon icon) {
            this.copy(icon);
        }

        public void copy(RMIcon icon) {
            this.type = icon.type;
            this.intro = icon.intro == null ? null : new Hex(icon.intro);
            this.image = icon.image;
            this.ref = icon.ref;
        }

        public String toString() {
            return Integer.toString(this.ref);
        }
    }

    public static class User {
        public Button button;
        public int state;
        public DeviceButton db;

        public User(Button b, int state) {
            this.button = b;
            this.state = state;
            this.db = DeviceButton.noButton;
        }

        public User(DeviceButton db, Button button) {
            this.db = db != null ? db : DeviceButton.noButton;
            this.button = button;
            this.state = 0;
        }

        public User(User u) {
            this.button = u.button;
            this.state = u.state;
            this.db = u.db;
        }

        public boolean equals(Object o) {
            User u = (User)o;
            if (this.db != u.db) {
                return false;
            }
            return this.button.getKeyCode(this.state) == u.button.getKeyCode(u.state);
        }

        public String getUserName() {
            String name = "";
            if (this.db != null && this.db != DeviceButton.noButton && !(name = this.db.getName().trim()).isEmpty()) {
                name = name + "/";
            }
            if (this.state == 0) {
                name = name + this.button.getName();
            } else if (this.state == 1) {
                name = name + this.button.getShiftedName();
            } else if (this.state == 2) {
                name = name + this.button.getXShiftedName();
            }
            return name;
        }

        public static String getUserNames(List<User> users) {
            boolean first = true;
            if (users.isEmpty()) {
                return "<none>";
            }
            StringBuilder buff = new StringBuilder();
            for (User user : users) {
                if (first) {
                    first = false;
                } else {
                    buff.append(", ");
                }
                buff.append(user.getUserName());
            }
            return buff.toString();
        }
    }

    public static class IconPanel
    extends JPanel
    implements ActionListener,
    RMSetter<RMIcon> {
        private static final int COLS = 6;
        private RemoteConfiguration config = null;
        private RMIcon value = null;
        private JPanel iconPanel = null;
        private JScrollPane scrollPane = null;
        private boolean showAll = true;
        private JLabel selected = null;
        private JButton selectedButton = null;
        private LinkedHashMap<ImageIcon, RMIcon> map = null;
        private RMIcon nullIcon = null;
        private JButton importButton = null;
        private JButton exportButton = null;
        private JButton deleteButton = null;
        private JRadioButton showAllButton = null;
        private JRadioButton showUnusedButton = null;
        private List<ImageIcon> usedImages = null;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public IconPanel() {
            this.setLayout(new BorderLayout());
            this.showAllButton = new JRadioButton("Show all");
            this.showUnusedButton = new JRadioButton("Show unused");
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.showAllButton);
            grp.add(this.showUnusedButton);
            this.showAllButton.addActionListener(this);
            this.showAllButton.setSelected(true);
            this.showUnusedButton.addActionListener(this);
            this.showAllButton.setFocusable(false);
            this.showUnusedButton.setFocusable(false);
            this.selected = new JLabel();
            JPanel panel = new JPanel(new FlowLayout(1, 5, 0));
            panel.add(this.showAllButton);
            panel.add(this.showUnusedButton);
            panel.add(Box.createVerticalStrut(40));
            panel.add(Box.createHorizontalStrut(10));
            panel.add(new JLabel("Selected: "));
            panel.add(this.selected);
            this.add((Component)panel, "First");
            this.iconPanel = new JPanel(new GridLayout(0, 6, -1, -1));
            this.scrollPane = new JScrollPane(this.iconPanel);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)this.scrollPane, "Center");
            panel = new JPanel(new GridLayout(3, 1));
            this.importButton = new JButton("Import new icon from file");
            this.importButton.setToolTipText(JTableX.getHtmlToolTip("Import icon from .png file to icon set of the remote.<br>Import occurs even if you later press Cancel."));
            this.exportButton = new JButton("Export selected icon to file");
            this.exportButton.setToolTipText(JTableX.getHtmlToolTip("Export icon to .png file."));
            this.deleteButton = new JButton("Delete selected (unused) icon");
            this.deleteButton.setToolTipText(JTableX.getHtmlToolTip("Delete icon from icon set of the remote.  Deletion<br> occurs even if you later press Cancel"));
            this.importButton.addActionListener(this);
            this.exportButton.addActionListener(this);
            this.deleteButton.addActionListener(this);
            this.importButton.setFocusable(false);
            this.exportButton.setFocusable(false);
            this.deleteButton.setFocusable(false);
            panel.add(this.importButton);
            panel.add(this.exportButton);
            panel.add(this.deleteButton);
            this.add((Component)panel, "Last");
            this.setBorder(BorderFactory.createTitledBorder(" Icon selector: "));
            this.map = new LinkedHashMap();
            this.usedImages = new ArrayList<ImageIcon>();
            this.nullIcon = new RMIcon();
        }

        @Override
        public RMIcon getValue() {
            return this.value;
        }

        @Override
        public void setValue(RMIcon value) {
            this.value = value;
            ArrayList<RMIcon> list = new ArrayList<RMIcon>();
            this.iconPanel.removeAll();
            this.nullIcon.type = value.type;
            list.add(this.nullIcon);
            this.map.clear();
            if (value.type == 5) {
                this.showUnusedButton.setEnabled(false);
                this.showAllButton.setSelected(true);
                this.usedImages.clear();
            } else {
                this.showUnusedButton.setEnabled(true);
                this.setUsedImages();
            }
            for (RMIcon icon : this.config.getSysIcons().values()) {
                if (icon.type != value.type || !this.showAll && this.usedImages.contains(icon.image)) continue;
                list.add(icon);
                this.map.put(icon.image, icon);
            }
            for (RMIcon icon : this.config.getUserIcons().values()) {
                if (icon.type != value.type || !this.showAll && this.usedImages.contains(icon.image)) continue;
                list.add(icon);
                this.map.put(icon.image, icon);
            }
            for (RMIcon icon : list) {
                IconButton button = new IconButton(icon.image);
                if (icon.ref == 0 || icon.ref == value.ref) {
                    this.selectedButton = button;
                }
                button.addActionListener(this);
                this.iconPanel.add(button);
            }
            GridLayout grid = (GridLayout)this.iconPanel.getLayout();
            Dimension d = grid.preferredLayoutSize(this.iconPanel);
            d.width += (Integer)UIManager.get("ScrollBar.width") + 10;
            d.height += 10;
            this.scrollPane.setPreferredSize(d);
            this.selected.setIcon(value.image);
            this.selected.setText(value.image == null ? "<none>" : null);
            this.importButton.setEnabled(value.type > 5);
            this.deleteButton.setEnabled(false);
            if (this.selectedButton != null) {
                this.selectedButton.requestFocusInWindow();
            }
        }

        private void setUsedImages() {
            this.usedImages.clear();
            for (FavScan fav : this.config.getFavScans()) {
                if (fav.icon.image == null) continue;
                this.usedImages.add(fav.icon.image);
            }
            for (Activity activity : this.config.getRemote().getFavKey().getProfiles()) {
                if (activity.icon.image == null) continue;
                this.usedImages.add(activity.icon.image);
            }
            for (Iterator<Highlight> iterator : this.config.getRemote().getDeviceButtons()) {
                GeneralFunction gf = null;
                for (Button b : this.config.getRemote().getButtons()) {
                    gf = ((DeviceButton)((Object)iterator)).getGeneralFunction(b);
                    if (gf == null || gf.icon == null) continue;
                    this.usedImages.add(gf.icon.image);
                }
            }
        }

        @Override
        public void setRemoteConfiguration(RemoteConfiguration config) {
            this.config = config;
            this.propertyChangeSupport.addPropertyChangeListener(config.getOwner());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JRadioButton) {
                this.showAll = this.showAllButton.isSelected();
                RMIcon icon = this.value;
                this.setValue(icon);
                this.validate();
                this.repaint();
                return;
            }
            JButton b = (JButton)e.getSource();
            if (b == this.importButton) {
                this.load();
            } else if (b == this.exportButton) {
                this.save();
            } else if (b == this.deleteButton) {
                ImageIcon imageIcon = (ImageIcon)this.selectedButton.getIcon();
                RMIcon icon = this.map.get(imageIcon);
                this.config.getUserIcons().remove(icon.ref);
                this.propertyChangeSupport.firePropertyChange("icons", null, null);
                this.setValue(this.nullIcon);
                this.validate();
                this.repaint();
            } else {
                this.selectedButton = b;
                ImageIcon image = (ImageIcon)b.getIcon();
                RMIcon icon = null;
                if (image == null) {
                    this.selected.setIcon(null);
                    this.selected.setText("<none>");
                    icon = this.nullIcon;
                    this.deleteButton.setEnabled(false);
                } else {
                    this.selected.setIcon(image);
                    this.selected.setText(null);
                    icon = this.map.get(image);
                    this.deleteButton.setEnabled(icon.type > 5 && !this.usedImages.contains(image));
                }
                this.value = icon;
            }
        }

        public void load() {
            PropertyFile properties;
            File file;
            block7: {
                file = null;
                properties = RMIRSetup.getProperties();
                File dir = properties.getFileProperty("IconPath");
                if (dir == null) {
                    dir = properties.getFileProperty("IRPath");
                }
                RMFileChooser chooser = new RMFileChooser(dir);
                String[] endings = new String[]{".png"};
                EndingFileFilter filter = new EndingFileFilter("Graphics files (*.png)", endings);
                chooser.setFileFilter(filter);
                RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
                while (chooser.showOpenDialog(rm) == 0) {
                    file = chooser.getSelectedFile();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(rm, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
                        continue;
                    }
                    if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(rm, file.getName() + " is a directory.", "File doesn't exist.", 0);
                        continue;
                    }
                    break block7;
                }
                return;
            }
            properties.setProperty("IconPath", file.getParentFile());
            MediaTracker tracker = new MediaTracker(this);
            ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
            Image image = imageIcon.getImage();
            tracker.addImage(image, 1);
            try {
                tracker.waitForID(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int h = image.getHeight(null);
            int w = image.getWidth(null);
            if (h > 34) {
                w = (int)((double)w * 34.0 / (double)h + 0.5);
                h = 34;
            }
            BufferedImage bi = new BufferedImage(w, h, 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, 0, 0, w, h, null);
            imageIcon = new ImageIcon(bi);
            RMIcon icon = new RMIcon(this.value);
            icon.image = imageIcon;
            icon.ref = 257;
            this.config.getUserIcons().put(icon.ref, icon);
            this.map.put(imageIcon, icon);
            IconButton button = new IconButton(icon.image);
            button.addActionListener(this);
            this.iconPanel.add(button);
            this.iconPanel.validate();
            this.propertyChangeSupport.firePropertyChange("icons", null, null);
        }

        public void save() {
            PropertyFile properties = RMIRSetup.getProperties();
            File dir = properties.getFileProperty("IconPath");
            if (dir == null) {
                dir = properties.getFileProperty("IRPath");
            }
            RMFileChooser chooser = new RMFileChooser(dir);
            String[] endings = new String[]{".png"};
            chooser.setFileFilter(new EndingFileFilter("Graphics files (*.png)", endings));
            RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
            int returnVal = chooser.showSaveDialog(rm);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                properties.setProperty("IconPath", file.getParentFile());
                String name = file.getAbsolutePath();
                if (!name.toLowerCase().endsWith(".png")) {
                    name = name + ".png";
                }
                file = new File(name);
                int rc = 0;
                if (file.exists()) {
                    rc = JOptionPane.showConfirmDialog(rm, file.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
                }
                if (rc == 0) {
                    BufferedImage image = (BufferedImage)this.value.image.getImage();
                    try {
                        ImageIO.write((RenderedImage)image, "PNG", file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        private class IconButton
        extends JButton {
            public IconButton(ImageIcon image) {
                super(image);
                this.setContentAreaFilled(false);
                this.setOpaque(false);
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer {
        private static final JLabel label = new JLabel();
        private static final JCheckBox check = new JCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Color color = UIManager.getColor("Table.selectionBackground");
            check.setBackground(isSelected ? color : Color.WHITE);
            check.setHorizontalAlignment(0);
            RMIcon icon = (RMIcon)value;
            check.setSelected(icon != null && icon.image != null);
            return icon != null ? check : label;
        }
    }
}

