/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.DeviceUpgradePanel;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RFSelectorTableModel;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SettingsTableModel;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SoftDevices;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GeneralPanel
extends RMPanel
implements ListSelectionListener,
ActionListener,
DocumentListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RemoteConfiguration remoteConfig = null;
    private JSplitPane upperPane = null;
    private JSplitPane mainPane = null;
    private JPanel deviceButtonPanel = null;
    private JPanel rfSelectorPanel = null;
    private JPanel warningPanel = null;
    private JLabel warningLabel = null;
    private JTextArea messageArea = null;
    private JScrollPane deviceScrollPane = null;
    private JScrollPane settingsScrollPane = null;
    private JScrollPane notesScrollPane = null;
    private JScrollPane remoteNotesScrollPane = null;
    private JSplitPane notesPane = null;
    private JP1Table deviceButtonTable = null;
    private DeviceButtonTableModel deviceModel = new DeviceButtonTableModel();
    private JP1Table rfSelectorTable;
    private RFSelectorTableModel rfSelectorModel = new RFSelectorTableModel();
    private JP1Table settingTable = null;
    private SettingsTableModel settingModel = new SettingsTableModel();
    private JP1Table activeTable = null;
    private JTextArea notes = null;
    private JTextArea remoteNotes = null;
    private JButton editButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton createUpgradesButton = null;
    private JPanel buttonPanel = null;
    private DeviceUpgrade selectedUpgrade = null;
    private boolean setInProgress = false;
    private JLabel iconLabel = null;
    private DeviceUpgradeEditor editor;
    private JLabel selectedDeviceLabel = null;

    public GeneralPanel() {
        this.deviceButtonPanel = new JPanel(new BorderLayout());
        this.deviceButtonPanel.setBorder(BorderFactory.createTitledBorder("Device Buttons"));
        this.deviceButtonTable = new JP1Table(this.deviceModel);
        this.deviceButtonTable.setSelectionMode(1);
        this.deviceButtonTable.getSelectionModel().addListSelectionListener(this);
        this.deviceButtonTable.initColumns(this.deviceModel);
        this.deviceButtonTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = GeneralPanel.this.deviceButtonTable.getSelectedRow();
                int col = GeneralPanel.this.deviceButtonTable.getSelectedColumn();
                if (row == -1) {
                    return;
                }
                if (GeneralPanel.this.rfSelectorPanel.isVisible() && e.getClickCount() != 2) {
                    DeviceButton db = (DeviceButton)GeneralPanel.this.deviceModel.getRow(row);
                    GeneralPanel.this.rfSelectorModel.set(GeneralPanel.this.remoteConfig, db);
                    GeneralPanel.this.rfSelectorTable.initColumns();
                    GeneralPanel.this.selectedDeviceLabel.setText("Selector buttons for device: " + db);
                    GeneralPanel.this.adjustPreferredViewportSizes(db);
                    return;
                }
                if (GeneralPanel.this.deviceModel.getEffectiveColumn(col) == 14 && !((DeviceButton)GeneralPanel.this.deviceModel.getRow(row)).isColorEditable()) {
                    JOptionPane.showMessageDialog(null, "The color for this device is not editable.  The only editable color is that for the Streamer device.", "Ring Color", 1);
                }
                if (!GeneralPanel.this.deviceButtonTable.isCellEditable(row, GeneralPanel.this.deviceButtonTable.columnAtPoint(e.getPoint())) && e.getClickCount() == 2) {
                    GeneralPanel.this.editUpgradeInRow(row);
                }
            }
        });
        this.deviceButtonTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GeneralPanel.this.activeTable = GeneralPanel.this.deviceButtonTable;
                GeneralPanel.this.setHighlightAction(GeneralPanel.this.deviceButtonTable);
                int row = GeneralPanel.this.deviceButtonTable.getSelectedRow();
                if (row < 0) {
                    GeneralPanel.this.selectedDeviceLabel.setText("No device selected");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JP1Frame.clearMessage(GeneralPanel.this.deviceButtonTable);
            }
        });
        this.activeTable = this.deviceButtonTable;
        this.deviceScrollPane = new JScrollPane(this.deviceButtonTable);
        this.deviceButtonPanel.add((Component)this.deviceScrollPane, "Center");
        this.rfSelectorPanel = new JPanel(new BorderLayout());
        this.rfSelectorPanel.setBorder(BorderFactory.createTitledBorder("RF Selectors"));
        this.rfSelectorTable = new JP1Table(this.rfSelectorModel);
        this.rfSelectorTable.initColumns(this.rfSelectorModel);
        this.rfSelectorTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GeneralPanel.this.activeTable = GeneralPanel.this.rfSelectorTable;
            }
        });
        this.rfSelectorPanel.add((Component)new JScrollPane(this.rfSelectorTable), "Center");
        this.rfSelectorPanel.setVisible(false);
        Box rfBox = new Box(3);
        rfBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.selectedDeviceLabel = new JLabel("No device selected");
        JPanel devPanel = new JPanel(new FlowLayout(0));
        devPanel.add(this.selectedDeviceLabel);
        rfBox.add(devPanel);
        String text = "Use this panel to set permitted IR and RF setup code pairs for an RF-enabled device.  After uploading, press and hold Setup and the appropriate selector button together for 3 seconds to set the new values in the remote. RF setup codes cannot be set directly in the Device Buttons panel above, as this would omit necessary side effects in the remote.  The Code Selector on the toolbar can be used to set both codes and to ensure the set values are valid.";
        rfBox.add(new ProtocolDataPanel.DisplayArea(text, null));
        this.rfSelectorPanel.add((Component)rfBox, "First");
        this.messageArea = new JTextArea();
        JLabel label = new JLabel();
        this.messageArea.setFont(label.getFont());
        this.messageArea.setBackground(label.getBackground());
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setEditable(false);
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        this.messageArea.setVisible(false);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BoxLayout(editPanel, 3));
        editPanel.add(this.messageArea);
        this.buttonPanel = new JPanel(new WrapLayout(1, 5, 0));
        this.editButton = new JButton("Edit Device");
        this.editButton.setEnabled(false);
        this.deviceModel.setEditButton(this.editButton);
        this.moveUpButton = new JButton("Move Up");
        this.moveUpButton.setVisible(false);
        this.moveDownButton = new JButton("Move Down");
        this.moveDownButton.setVisible(false);
        this.createUpgradesButton = new JButton("Create missing upgrades");
        this.createUpgradesButton.setVisible(false);
        this.iconLabel = new JLabel("   ");
        this.iconLabel.setPreferredSize(new Dimension(100, 40));
        this.iconLabel.setHorizontalTextPosition(10);
        this.iconLabel.setVisible(false);
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(this.moveUpButton);
        this.buttonPanel.add(this.moveDownButton);
        this.buttonPanel.add(this.createUpgradesButton);
        this.buttonPanel.add(Box.createVerticalStrut(this.iconLabel.getPreferredSize().height));
        this.buttonPanel.add(this.iconLabel);
        editPanel.add(this.buttonPanel);
        this.editButton.addActionListener(this);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.createUpgradesButton.addActionListener(this);
        this.deviceButtonPanel.add((Component)editPanel, "Last");
        this.settingTable = new JP1Table(this.settingModel);
        this.settingTable.setCellEditorModel(this.settingModel);
        this.settingTable.setSelectionMode(1);
        this.settingTable.initColumns(this.settingModel);
        this.settingTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GeneralPanel.this.activeTable = GeneralPanel.this.settingTable;
                GeneralPanel.this.setHighlightAction(GeneralPanel.this.settingTable);
            }
        });
        this.settingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !GeneralPanel.this.setInProgress) {
                    GeneralPanel.this.setHighlightAction(GeneralPanel.this.settingTable);
                }
            }
        });
        this.settingsScrollPane = new JScrollPane(this.settingTable);
        this.settingsScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Other Settings"), this.settingsScrollPane.getBorder()));
        JPanel deviceDataPanel = new JPanel(new BorderLayout());
        deviceDataPanel.add((Component)this.deviceButtonPanel, "Center");
        deviceDataPanel.add((Component)this.rfSelectorPanel, "Last");
        this.upperPane = new JSplitPane(1, deviceDataPanel, this.settingsScrollPane);
        this.upperPane.setResizeWeight(0.5);
        this.notes = new JTextArea(6, 20);
        new TextPopupMenu(this.notes);
        this.notes.setLineWrap(true);
        this.notes.setWrapStyleWord(true);
        this.notes.getDocument().addDocumentListener(this);
        this.notesScrollPane = new JScrollPane(this.notes);
        this.notesScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("User Notes"), this.notesScrollPane.getBorder()));
        this.remoteNotes = new JTextArea(6, 20);
        this.remoteNotes.setLineWrap(true);
        this.remoteNotes.setWrapStyleWord(true);
        this.remoteNotes.setEditable(false);
        this.remoteNotesScrollPane = new JScrollPane(this.remoteNotes);
        this.remoteNotesScrollPane.setVisible(false);
        this.remoteNotesScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Notes"), this.remoteNotesScrollPane.getBorder()));
        JPanel lowerPanel = new JPanel(new BorderLayout());
        this.warningPanel = new JPanel(new FlowLayout(1));
        this.warningPanel.setBackground(Color.RED);
        this.warningPanel.setVisible(false);
        this.warningLabel = new JLabel();
        Font font = this.warningLabel.getFont();
        Font font2 = font.deriveFont(1, 12.0f);
        this.warningLabel.setFont(font2);
        this.warningLabel.setForeground(Color.YELLOW);
        this.notesPane = new JSplitPane(1, this.remoteNotesScrollPane, this.notesScrollPane);
        this.notesPane.setResizeWeight(0.4);
        this.warningPanel.add(this.warningLabel);
        lowerPanel.add((Component)this.notesPane, "Center");
        lowerPanel.add((Component)this.warningPanel, "Last");
        this.mainPane = new JSplitPane(0, this.upperPane, lowerPanel);
        this.mainPane.setResizeWeight(0.7);
        this.add((Component)this.mainPane, "Center");
        this.adjustPreferredViewportSizes(null);
    }

    private void adjustPreferredViewportSizes(DeviceButton devBtn) {
        int rows = 8;
        if (this.remoteConfig != null) {
            rows = Math.min(8, this.remoteConfig.getRemote().getDeviceButtons().length);
        }
        Dimension dd = this.deviceButtonTable.getPreferredSize();
        dd.height = this.deviceButtonTable.getRowHeight() * rows;
        this.deviceButtonTable.setPreferredScrollableViewportSize(dd);
        rows = 10;
        if (this.remoteConfig != null) {
            rows = Math.min(12, this.remoteConfig.getRemote().getSettings().length);
        }
        Dimension ds = this.settingTable.getPreferredSize();
        ds.height = rows * this.settingTable.getRowHeight();
        this.settingTable.setPreferredScrollableViewportSize(ds);
        if (this.rfSelectorPanel.isVisible()) {
            rows = 2;
            if (devBtn != null && devBtn.getRfSelectors() != null) {
                rows = Math.max(2, Math.min(5, devBtn.getRfSelectors().length));
            } else {
                this.rfSelectorModel.set(this.remoteConfig, null);
            }
            Dimension dr = this.rfSelectorTable.getPreferredSize();
            dr.height = rows * this.rfSelectorTable.getRowHeight();
            this.rfSelectorTable.setPreferredScrollableViewportSize(dr);
        }
        this.upperPane.resetToPreferredSizes();
        this.upperPane.setDividerLocation((double)dd.width / (double)(dd.width + ds.width));
        this.notesPane.resetToPreferredSizes();
        this.mainPane.resetToPreferredSizes();
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.setInProgress = true;
        this.remoteConfig = remoteConfig;
        this.deviceModel.set(remoteConfig);
        this.deviceButtonTable.initColumns(this.deviceModel);
        SoftDevices softDevices = remoteConfig.getRemote().getSoftDevices();
        Remote remote = remoteConfig.getRemote();
        String message1 = "Devices on this remote are selected by scrolling through a fixed list and a device with an unset setup code is skipped.  A blank entry in the setup column denotes an unset setup code.";
        String message2 = "Devices on this remote are selected by scrolling through a list of those devices that have been set up.  To set up an unset device, you must first set a value in the Type column.  To delete a set device, edit the Type value and select the blank entry at the bottom of the list.";
        String message3 = "Note 1:  All devices in this remote have a corresponding device upgrade.  To add a new built-in device, use the Settings facility of the remote as this also creates the required upgrade.  To load or create an upgrade for a new device, use the New button on the Device Upgrades tab.  Creating the upgrade will automatically assign it as a new device.  To delete a device, use the Device Upgrades tab to delete the corresponding device upgrade, which will also delete the device.\n\nNote 2:  Use this Device Buttons table to edit device names, brands etc, to reorder devices or set locks.";
        String message4 = "Devices on this remote that are set up up with simpleset.com all have a corresponding device upgrade.  This enables one to see the functions of the device and to customise them as desired.  Devices set up through the remote itself or with RMIR do not initally have such an upgrade.  If you have loaded a .bin file rather than a .rmir file, you may create any missing upgrades by pressing the \"Create missing upgrades\"  button.  If this button is present but disabled (grayed out), it means that there are no missing upgrades.";
        String message5 = "This remote supports more than one device but has no means of device selection.  The device controlled by any button is determined by a fixed internal algorithm dependent on which devices have assigned setup codes.";
        String message6 = "This remote supports only one device.  The <Internal> entry represents a setup selected through a Power button search, the TV entry represents a device upgrade.  An editable checkbox marks which one is active.";
        String text = remote.needsDeviceSelectionMessage() ? message5 : (remote.usesSimpleset() ? message4 : (remote.usesEZRC() ? message3 : (softDevices != null && softDevices.isSetupCodesOnly() ? "Note:  " + message1 : "Note:  " + message2)));
        this.messageArea.setText(text);
        this.messageArea.setVisible(softDevices != null);
        if (remote.hasSettings()) {
            this.settingModel.set(remoteConfig);
            this.settingTable.initColumns(this.settingModel);
            this.settingsScrollPane.setVisible(true);
        } else {
            this.settingsScrollPane.setVisible(false);
        }
        this.rfSelectorPanel.setVisible(remote.hasRf4ceSupport());
        this.editButton.setEnabled(false);
        this.iconLabel.setVisible(remote.isSSD());
        this.iconLabel.setIcon(null);
        this.moveUpButton.setVisible(remote.usesEZRC());
        this.moveDownButton.setVisible(remote.usesEZRC());
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.createUpgradesButton.setVisible(remote.usesSimpleset());
        this.createUpgradesButton.setEnabled(remoteConfig.getCreatableMissingCodes() != null);
        this.remoteNotesScrollPane.setVisible(remote.getNotes() != null);
        this.remoteNotes.setText(remote.getNotes());
        this.remoteNotes.setCaretPosition(0);
        text = remoteConfig.getNotes();
        if (text == null) {
            text = "";
        }
        this.notes.setText(text);
        this.notes.setCaretPosition(0);
        this.setWarning();
        this.validate();
        this.adjustPreferredViewportSizes(null);
        this.setInProgress = false;
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            if (this.deviceModel != null) {
                this.deviceModel.addPropertyChangeListener(listener);
            }
            if (this.settingModel != null) {
                this.settingModel.addPropertyChangeListener(listener);
            }
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && !this.setInProgress) {
            if (this.deviceButtonTable.getSelectedRowCount() == 1) {
                int selectedRow = this.deviceButtonTable.getSelectedRow();
                Remote remote = this.remoteConfig.getRemote();
                DeviceButton deviceButton = null;
                deviceButton = remote.usesEZRC() ? this.remoteConfig.getDeviceButtonList().get(selectedRow) : remote.getDeviceButtons()[selectedRow];
                this.deviceModel.setEditButtonState(deviceButton);
                GeneralFunction.RMIcon icon = deviceButton.icon;
                this.iconLabel.setIcon(icon == null ? null : icon.image);
                this.moveUpButton.setEnabled(remote.usesEZRC() && selectedRow > 0);
                this.moveDownButton.setEnabled(remote.usesEZRC() && selectedRow < this.deviceButtonTable.getRowCount() - 1);
            } else {
                this.editButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.iconLabel.setIcon(null);
            }
            this.deviceButtonPanel.repaint();
            this.setHighlightAction(this.deviceButtonTable);
        }
    }

    private void setHighlightAction(JP1Table table) {
        this.remoteConfig.getOwner().highlightAction.setEnabled(table.getSelectedRowCount() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int row = this.deviceButtonTable.getSelectedRow();
        if (source == this.editButton) {
            DeviceButton db = (DeviceButton)this.deviceModel.getRow(row);
            short[] data = this.deviceModel.getData(row);
            this.selectedUpgrade = this.remoteConfig.getAssignedDeviceUpgrade(db);
            DeviceUpgrade convertedUpgrade = db.getConvertedUpgrade();
            if (this.selectedUpgrade != null) {
                this.editUpgradeInRow(row);
            } else if (convertedUpgrade != null) {
                String message = "The selected device is built-in.  To edit, it must be converted to a device upgrade,\nwhich takes precedence over the built-in device.  Do you want this conversion?";
                String title = "Edit built-in device";
                int reply1 = JOptionPane.showConfirmDialog(this, message, title, 0);
                ArrayList<KeyMove> keyMoveList = new ArrayList<KeyMove>();
                if (reply1 != 0) {
                    this.deviceButtonTable.requestFocusInWindow();
                } else {
                    short setupCode = db.getSetupCode(data);
                    int group = db.getDeviceGroup(data);
                    Remote remote = this.remoteConfig.getRemote();
                    DeviceType deviceType = remote.getDeviceTypeByIndexAndGroup(this.deviceModel.getExtendedTypeIndex(row), group);
                    convertedUpgrade.setSelectedSetupCode(String.format("%04d", setupCode));
                    convertedUpgrade.setSelectedDeviceIndex(deviceType.getNumber());
                    for (KeyMove km : this.remoteConfig.getKeyMoves()) {
                        if (remote.getDeviceButton(km.getDeviceButtonIndex()) != db || km.getSetupCode() != setupCode || remote.getDeviceTypeByIndex(km.getDeviceType()) != deviceType) continue;
                        keyMoveList.add(km);
                    }
                    KeyMapMaster.createUpgrade(convertedUpgrade, this.remoteConfig.getRemote(), null);
                    String currentNote = this.remoteConfig.getDeviceButtonNotes()[row];
                    if (currentNote != null) {
                        convertedUpgrade.setDescription(currentNote);
                    }
                    int reply2 = 1;
                    if (keyMoveList.size() > 0) {
                        message = "There are " + keyMoveList.size() + " key moves that change the data sent by\n keys on this device.  Do you want those changes to be applied to the\nconverted upgrade?";
                        reply2 = JOptionPane.showConfirmDialog(this, message, title, 0);
                    }
                    if (reply2 == 0) {
                        Protocol p = convertedUpgrade.getProtocol();
                        int cmdSize = p.getDefaultCmdLength();
                        ArrayList<String> fnNames = new ArrayList<String>();
                        for (Function f : convertedUpgrade.getFunctions()) {
                            fnNames.add(f.getName());
                        }
                        for (KeyMove km : keyMoveList) {
                            Remote.ButtonSplit split = remote.getButtonSplit(km.getKeyCode());
                            String bName = remote.getButtonName(km.getKeyCode());
                            Function btnFn = convertedUpgrade.getFunction(split.base, split.state);
                            if (btnFn != null) {
                                String newNote = "was on button " + bName;
                                if (btnFn.getNotes() != null) {
                                    newNote = newNote + "; " + btnFn.getNotes();
                                }
                                btnFn.setNotes(newNote);
                            }
                            Hex hex = km.getCmd();
                            if (km instanceof KeyMoveKey) {
                                Remote.ButtonSplit bs = remote.getButtonSplit(hex.getData()[0]);
                                Function ff = convertedUpgrade.getFunction(bs.base, bs.state);
                                hex = ff.getData();
                            }
                            if (hex.length() != cmdSize) {
                                hex = new Hex(hex, 0, cmdSize);
                            }
                            String newFnName = null;
                            int n = 2;
                            while (fnNames.contains(newFnName = bName + n++)) {
                            }
                            fnNames.add(newFnName);
                            Function f = new Function(newFnName, hex, km.getNotes());
                            this.remoteConfig.getKeyMoves().remove(km);
                            f.setUpgrade(convertedUpgrade);
                            convertedUpgrade.setFunction(split.base, f, split.state);
                            convertedUpgrade.getFunctions().add(f);
                        }
                    }
                    this.remoteConfig.getDeviceUpgrades().add(convertedUpgrade);
                    this.remoteConfig.setUpgradeKeyMoves();
                    this.remoteConfig.updateAdvancedCodes();
                    this.selectedUpgrade = convertedUpgrade;
                    this.remoteConfig.getOwner().getDeviceUpgradePanel().model.fireTableDataChanged();
                    message = "The new upgrade " + convertedUpgrade.getDeviceTypeAliasName() + "/" + String.format("%04d", convertedUpgrade.getSetupCode()) + " is now available on the Devices tab.  Do you want to open\nit for editing now?";
                    if (JOptionPane.showConfirmDialog(this, message, title, 0) == 0) {
                        this.editUpgradeInRow(row);
                    }
                    this.deviceModel.fireTableRowsUpdated(row, row);
                }
            }
            this.deviceButtonTable.requestFocusInWindow();
        } else if (source == this.moveUpButton) {
            this.deviceModel.moveRow(row - 1, row);
            this.deviceButtonTable.setRowSelectionInterval(row - 1, row - 1);
        } else if (source == this.moveDownButton) {
            this.deviceModel.moveRow(row, row + 1);
            this.deviceButtonTable.setRowSelectionInterval(row + 1, row + 1);
        } else if (source == this.createUpgradesButton) {
            this.remoteConfig.createMissingUpgrades();
            this.propertyChangeSupport.firePropertyChange("data", null, null);
        }
    }

    public void editUpgradeInRow(int row) {
        DeviceButton deviceButton;
        if (row == -1) {
            return;
        }
        Remote remote = this.remoteConfig.getRemote();
        DeviceButton deviceButton2 = remote.usesEZRC() ? this.remoteConfig.getDeviceButtonList().get(row) : (deviceButton = row < remote.getDeviceButtons().length ? remote.getDeviceButtons()[row] : null);
        if (deviceButton == null) {
            return;
        }
        DeviceUpgrade oldUpgrade = this.remoteConfig.getAssignedDeviceUpgrade(deviceButton);
        DeviceUpgradePanel dup = this.remoteConfig.getOwner().getDeviceUpgradePanel();
        int dupRow = dup.getRow(oldUpgrade);
        dup.editRowObject(dupRow);
    }

    public boolean setWarning() {
        int warn = this.deviceModel.hasInvalidCodes();
        String warningText = "WARNING:";
        if ((warn & 3) > 0) {
            warningText = warningText + "  Setup Codes shown in RED";
            warningText = warningText + ((warn & 1) > 0 ? "  are invalid" : "");
            warningText = warningText + (warn == 3 ? " or" : "");
            warningText = warningText + ((warn & 2) > 0 ? " exceed maximum value of " + SetupCode.getMax() : "");
            warningText = warningText + ".";
        }
        if ((warn & 4) > 0) {
            warningText = warningText + "  Names shown in RED have no assigned upgrade.";
        }
        this.warningLabel.setText(warningText);
        this.warningPanel.setVisible(warn > 0);
        return warn > 0;
    }

    public DeviceButtonTableModel getDeviceButtonTableModel() {
        return this.deviceModel;
    }

    public JP1Table getDeviceButtonTable() {
        return this.deviceButtonTable;
    }

    public JP1Table getRfSelectorTable() {
        return this.rfSelectorTable;
    }

    public JP1Table getSettingTable() {
        return this.settingTable;
    }

    public SettingsTableModel getSettingModel() {
        return this.settingModel;
    }

    public DeviceUpgradeEditor getDeviceUpgradeEditor() {
        return this.editor;
    }

    public JP1Table getActiveTable() {
        return this.activeTable;
    }

    public JButton getCreateUpgradesButton() {
        return this.createUpgradesButton;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    private void documentUpdated(DocumentEvent event) {
        if (!this.setInProgress) {
            String text = this.notes.getText();
            this.remoteConfig.setNotes(text);
            this.propertyChangeSupport.firePropertyChange("notes", null, text);
        }
    }

    public void finishEditing() {
        if (this.deviceButtonTable.getCellEditor() != null) {
            this.deviceButtonTable.getCellEditor().stopCellEditing();
        }
        if (this.settingTable.getCellEditor() != null) {
            this.settingTable.getCellEditor().stopCellEditing();
        }
    }
}

