/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.util.Properties;

public class GlobalPT
extends Highlight {
    private Hex activeBtnCodes = null;
    private Hex activeDevCodes = null;

    public GlobalPT(int deviceButtonIndex, Hex activeBtnCodes, Hex activeDevCodes, String notes) {
        this.deviceButtonIndex = deviceButtonIndex;
        this.activeBtnCodes = activeBtnCodes;
        this.activeDevCodes = activeDevCodes;
        this.notes = notes;
    }

    public GlobalPT(Properties props) {
        super(props);
        this.deviceButtonIndex = Integer.parseInt(props.getProperty("DeviceButtonIndex"));
        this.activeBtnCodes = new Hex(props.getProperty("ActiveButtonCodes"));
        this.activeDevCodes = new Hex(props.getProperty("ActiveDeviceCodes"));
    }

    public DeviceButton getDeviceButton(RemoteConfiguration config) {
        return config.getRemote().getDeviceButton(this.deviceButtonIndex);
    }

    public Hex getActiveBtnCodes() {
        return this.activeBtnCodes;
    }

    public Hex getActiveDevCodes() {
        return this.activeDevCodes;
    }

    public static String getValueString(Hex hex, ActiveType type, RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] data = hex.getData();
        for (int i = 0; i < hex.length(); ++i) {
            if (i != 0) {
                buff.append(';');
            }
            int code = data[i] & 0xFF;
            String name = type == ActiveType.BTN ? remote.getButtonName(code) : remote.getDeviceButton(code).getName();
            buff.append(name);
        }
        return buff.toString();
    }

    public String getActiveBtnString(RemoteConfiguration remoteConfig) {
        return GlobalPT.getValueString(this.activeBtnCodes, ActiveType.BTN, remoteConfig);
    }

    public String getActiveDevString(RemoteConfiguration remoteConfig) {
        return GlobalPT.getValueString(this.activeDevCodes, ActiveType.DEV, remoteConfig);
    }

    @Override
    public void store(PropertyWriter pw) {
        pw.print("DeviceButtonIndex", this.deviceButtonIndex);
        pw.print("ActiveButtonCodes", this.activeBtnCodes);
        pw.print("ActiveDeviceCodes", this.activeDevCodes);
        super.store(pw);
    }

    private static enum ActiveType {
        BTN,
        DEV;

    }
}

