/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GlobalPT;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class GlobalPTDialog
extends JDialog
implements ActionListener,
ButtonEnabler {
    private static GlobalPTDialog dialog = null;
    private GlobalPT globalPT = null;
    private RemoteConfiguration config = null;
    private JPanel upperPanel = null;
    private JComboBox<DeviceButton> sourceDeviceBox = null;
    private MacroDefinitionBox macroBox = null;
    private JPanel destinationPanel = null;
    private HashMap<Integer, JCheckBox> deviceMap = null;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JTextArea notes = null;

    public static GlobalPT showDialog(Component locationComp, GlobalPT globalPT, RemoteConfiguration config) {
        if (dialog == null || config != GlobalPTDialog.dialog.config) {
            dialog = new GlobalPTDialog(locationComp);
        }
        dialog.setRemoteConfiguration(config);
        dialog.setGlobalPT(globalPT);
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        dialog.setVisible(true);
        return GlobalPTDialog.dialog.globalPT;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private GlobalPTDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Global Punchthrough");
        this.setModal(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.upperPanel = new JPanel(new BorderLayout());
        this.upperPanel.setBorder(BorderFactory.createTitledBorder(" Source device "));
        this.sourceDeviceBox = new JComboBox();
        this.upperPanel.add(this.sourceDeviceBox);
        contentPane.add((Component)this.upperPanel, "North");
        this.macroBox = new MacroDefinitionBox(false);
        this.macroBox.setButtonEnabler(this);
        ((TitledBorder)this.macroBox.getBorder()).setTitle(" Source keys ");
        this.macroBox.keysBoxLabel.setText("Selected keys:");
        this.macroBox.availableButtons.setToolTipText(JTableX.getHtmlToolTip("Double-click to add/insert.<br>Shift/double-click to add/insert shifted.<br>This will insert if a key is selected, add otherwise.<br>Right-click (either box) to clear key selection."));
        contentPane.add((Component)this.macroBox, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "South");
        this.deviceMap = new HashMap();
        this.destinationPanel = new JPanel(new GridLayout(0, 4));
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(" Destination devices "));
        bottomPanel.add((Component)this.destinationPanel, "North");
        JPanel footPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)footPanel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes = new JTextArea(2, 10);
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        footPanel.add((Component)panel, "North");
        panel = new JPanel(new FlowLayout(2));
        footPanel.add((Component)panel, "South");
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        if (this.config == config) {
            return;
        }
        this.config = config;
        Remote remote = config.getRemote();
        DeviceButton[] devBtns = remote.getDeviceButtons();
        DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(devBtns);
        this.sourceDeviceBox.setModel(comboModel);
        this.sourceDeviceBox.setSelectedIndex(0);
        this.deviceMap.clear();
        for (DeviceButton dev : devBtns) {
            JCheckBox chkBox = new JCheckBox(dev.getName());
            this.deviceMap.put(dev.getButtonIndex(), chkBox);
            this.destinationPanel.add(chkBox);
        }
        this.macroBox.setRemoteConfiguration(config);
    }

    private void setGlobalPT(GlobalPT globalPT) {
        this.globalPT = globalPT;
        for (JCheckBox chkBox : this.deviceMap.values()) {
            chkBox.setSelected(false);
        }
        this.macroBox.availableButtons.setSelectedIndex(0);
        if (globalPT == null) {
            this.sourceDeviceBox.setSelectedIndex(0);
            this.macroBox.setValue((Object)null);
        } else {
            this.sourceDeviceBox.setSelectedItem(globalPT.getDeviceButton(this.config));
            this.macroBox.setValue(globalPT.getActiveBtnCodes());
            for (Object code : (Object)globalPT.getActiveDevCodes().getData()) {
                this.deviceMap.get((int)code).setSelected(true);
            }
        }
        this.macroBox.enableButtons();
    }

    @Override
    public void enableButtons(Button b, MacroDefinitionBox box) {
        int limit = 48;
        boolean canAdd = b != null && this.macroBox.isMoreRoom(limit);
        this.macroBox.add.setEnabled(canAdd && b.canAssignToMacro());
        this.macroBox.insert.setEnabled(canAdd && b.canAssignToMacro());
        this.macroBox.addShift.setVisible(true);
        this.macroBox.addXShift.setVisible(true);
        this.macroBox.insertShift.setVisible(true);
        this.macroBox.insertXShift.setVisible(true);
        boolean shiftEnabled = this.config.getRemote().getShiftEnabled();
        this.macroBox.addShift.setEnabled(shiftEnabled && canAdd && b.canAssignShiftedToMacro());
        this.macroBox.insertShift.setEnabled(shiftEnabled && canAdd && b.canAssignShiftedToMacro());
        boolean xShiftEnabled = this.config.getRemote().getXShiftEnabled();
        this.macroBox.addXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
        this.macroBox.insertXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
    }

    @Override
    public boolean isAvailable(Button b) {
        Remote remote = this.config.getRemote();
        return remote.getDistinctButtons().contains(b) && (b.canAssignToMacro() || b.canAssignShiftedToMacro() || b.canAssignXShiftedToMacro()) && remote.getDeviceButton(b.getKeyCode()) == null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            if (this.macroBox.isEmpty()) {
                this.showWarning("You haven't included any source keys!");
                return;
            }
            ArrayList<Short> destDevCodes = new ArrayList<Short>();
            for (int code : this.deviceMap.keySet()) {
                if (!this.deviceMap.get(code).isSelected()) continue;
                destDevCodes.add((short)code);
            }
            if (destDevCodes.size() == 0) {
                this.showWarning("You haven't included any destination devices!");
                return;
            }
            DeviceButton sourceDev = (DeviceButton)this.sourceDeviceBox.getSelectedItem();
            Hex activeBtnCodes = (Hex)this.macroBox.getValue();
            Hex activeDevCodes = new Hex(destDevCodes.size());
            for (int i = 0; i < destDevCodes.size(); ++i) {
                activeDevCodes.set((Short)destDevCodes.get(i), i);
            }
            String notesStr = this.notes.getText();
            GlobalPT newGlobalPT = new GlobalPT(sourceDev.getButtonIndex(), activeBtnCodes, activeDevCodes, notesStr);
            newGlobalPT.setSegmentFlags(this.globalPT == null ? 255 : this.globalPT.getSegmentFlags());
            this.globalPT = newGlobalPT;
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.globalPT = null;
            this.setVisible(false);
        }
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Missing Information", 0);
    }
}

