/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GlobalPT;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import java.awt.Color;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class GlobalPTTableModel
extends JP1TableModel<GlobalPT> {
    private static final String[] colNames = new String[]{"#", "Source device", "Source keys", "Destination devices", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Source device__", "Source keys_________", "Destination devices_____", "A reasonable length note for a global punchthru", "Color__"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, DeviceButton.class, String.class, String.class, String.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col < 2 || col == 5;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        GlobalPT globalPT = (GlobalPT)this.getRow(row);
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return globalPT.getDeviceButton(this.remoteConfig);
            }
            case 2: {
                return globalPT.getActiveBtnString(this.remoteConfig);
            }
            case 3: {
                return globalPT.getActiveDevString(this.remoteConfig);
            }
            case 4: {
                return globalPT.getNotes();
            }
            case 5: {
                return globalPT.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        GlobalPT globalPT = (GlobalPT)this.getRow(row);
        if (col == 4) {
            globalPT.notes = (String)value;
        } else if (col == 5) {
            globalPT.setHighlight((Color)value);
        }
        this.propertyChangeSupport.firePropertyChange(col == 5 ? "highlight" : "data", null, null);
    }

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.setData(remoteConfig.getGlobalPTs());
        }
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (col == 5) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 5) {
            return this.colorRenderer;
        }
        return null;
    }
}

