/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Hex
implements Cloneable,
Comparable<Hex> {
    private short[] data = null;
    public static short NO_MATCH = (short)256;
    public static short ADD_OFFSET = (short)512;

    public Hex() {
        this.data = new short[0];
    }

    public Hex(int length) {
        this.data = new short[length];
    }

    public Hex(String text) {
        this.data = Hex.parseHex(text);
    }

    public Hex(short[] data) {
        this.data = data;
    }

    public Hex(Short[] dataShort) {
        this.data = new short[dataShort.length];
        for (int i = 0; i < dataShort.length; ++i) {
            this.data[i] = dataShort[i];
        }
    }

    public Hex(byte[] ba) {
        this.data = new short[ba.length];
        for (int i = 0; i < ba.length; ++i) {
            this.data[i] = (short)(ba[i] & 0xFF);
        }
    }

    public Hex(short[] newData, int offset, int length) {
        this.data = new short[length];
        System.arraycopy(newData, offset, this.data, 0, length);
    }

    public Hex(Hex h) {
        this.data = new short[h.data.length];
        System.arraycopy(h.data, 0, this.data, 0, this.data.length);
    }

    public Hex(Hex h, int offset, int length) {
        this.data = new short[length];
        System.arraycopy(h.data, offset, this.data, 0, Math.min(length, h.length() - offset));
        if (h.length() - offset < length) {
            Arrays.fill(this.data, h.length() - offset, length, (short)0);
        }
    }

    public Hex(String s, int size) {
        char[] ch = s.toCharArray();
        if (size == 8) {
            this.data = new short[ch.length];
            for (int i = 0; i < ch.length; ++i) {
                this.data[i] = (short)ch[i];
            }
        } else if (size == 16) {
            this.data = new short[2 * ch.length];
            for (int i = 0; i < ch.length; ++i) {
                this.data[2 * i] = (short)(ch[i] & 0xFF);
                this.data[2 * i + 1] = (short)(ch[i] >> 8 & 0xFF);
            }
        } else {
            this.data = new short[0];
        }
    }

    public byte[] toByteArray() {
        byte[] ba = new byte[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            ba[i] = (byte)(this.data[i] & 0xFF);
        }
        return ba;
    }

    public int length() {
        return this.data.length;
    }

    public short[] getData() {
        return this.data;
    }

    public void set(short[] data) {
        this.data = data;
    }

    public void set(String text) {
        this.data = Hex.parseHex(text);
    }

    public int get(int offset) {
        return Hex.get(this.data, offset);
    }

    public static int get(short[] data, int offset) {
        return data[offset] << 8 | data[offset + 1];
    }

    public static Integer get(Short[] data, int offset) {
        if (data[offset] == null || data[offset + 1] == null) {
            return null;
        }
        return data[offset] << 8 | data[offset + 1];
    }

    public void put(int value, int offset) {
        Hex.put(value, this.data, offset);
    }

    public static void put(int value, short[] data, int offset) {
        data[offset] = (short)(value >> 8 & 0xFF);
        data[offset + 1] = (short)(value & 0xFF);
    }

    public static void put(Integer value, Short[] data, int offset) {
        if (value == null) {
            data[offset] = null;
            data[offset + 1] = null;
        } else {
            data[offset] = (short)(value >> 8 & 0xFF);
            data[offset + 1] = (short)(value & 0xFF);
        }
    }

    public static void semiPut(Integer value, Short[] data, int offset, int half) {
        if (value == null) {
            data[offset + 1 + half] = null;
            if (data[offset + 2 - half] == null) {
                data[offset] = null;
            }
        } else {
            int shift = 4 * half;
            if (data[offset] == null) {
                data[offset] = 0;
            }
            data[offset] = (short)(data[offset] & 15 << shift | (value & 0xF00) >> shift + 4);
            data[offset + 1 + half] = (short)(value & 0xFF);
        }
    }

    public static Integer semiGet(Short[] data, int offset, int half) {
        if (data[offset] == null || data[offset + 1 + half] == null) {
            return null;
        }
        int shift = 4 * half;
        return data[offset] << shift + 4 & 0xF00 | data[offset + 1 + half];
    }

    public void set(short value, int offset) {
        this.data[offset] = value;
    }

    public void put(Hex src) {
        this.put(src, 0);
    }

    public void put(Hex src, int index) {
        this.put(src.data, index);
    }

    public void put(short[] src, int index) {
        Hex.put(src, this.data, index);
    }

    public static void put(Hex src, short[] dest, int index) {
        Hex.put(src.data, dest, index);
    }

    public static void put(short[] src, short[] dest, int index) {
        int length = src.length;
        if (index + length > dest.length) {
            length = dest.length - index;
        }
        System.arraycopy(src, 0, dest, index, length);
    }

    public static short[] parseHex(String text) {
        boolean hexmark;
        short[] rc = null;
        int length = 0;
        int space = text.indexOf(32);
        boolean bl = hexmark = text.indexOf(104) >= 0 || text.indexOf(36) >= 0;
        if (space == -1 && !hexmark && text.length() > 2) {
            if ((text.length() & 1) == 1) {
                text = "0" + text;
            }
            length = text.length() / 2;
            rc = new short[length];
            for (int i = 0; i < length; ++i) {
                int offset = i * 2;
                String temp = text.substring(offset, offset + 2);
                rc[i] = Short.parseShort(temp, 16);
            }
        } else {
            StringTokenizer st = new StringTokenizer(text, " _.$h\n\r\t");
            length = st.countTokens();
            rc = new short[length];
            Hex.parseHex(text, rc, 0);
        }
        return rc;
    }

    public static void parseHex(String text, short[] data, int offset) {
        StringTokenizer st = new StringTokenizer(text, " _.$h\n\r\t", true);
        short value = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("$") || token.equals("h") || token.equals("\n") || token.equals("\r") || token.equals("\t")) {
                value = 0;
                continue;
            }
            if (token.equals("_")) {
                value = ADD_OFFSET;
                continue;
            }
            if (token.equals(".")) {
                value = NO_MATCH;
                continue;
            }
            int temp = Integer.parseInt(token, 16);
            if (temp > Short.MAX_VALUE) {
                temp -= 65536;
            }
            data[offset++] = (short)(value | temp);
        }
    }

    public static String asString(int value) {
        StringBuilder buff = new StringBuilder(2);
        String str = Integer.toHexString(value & 0xFF);
        if (str.length() < 2) {
            buff.append('0');
        }
        buff.append(str);
        return buff.toString().toUpperCase();
    }

    public String toRawString() {
        if (this.data == null) {
            return null;
        }
        StringBuilder rc = new StringBuilder(3 * this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            short val = this.data[i];
            int masked = val & 0xFF;
            if (i > 0) {
                char sep = ' ';
                int flag = val & 0xFF00;
                if (flag == NO_MATCH) {
                    sep = ',';
                } else if (flag == ADD_OFFSET) {
                    sep = '_';
                }
                rc.append(sep);
            }
            String str = Integer.toHexString(masked);
            if (masked < 16) {
                rc.append('0');
            }
            rc.append(str);
        }
        return rc.toString().toUpperCase();
    }

    public static String toString(byte[] data, int breakAt, int offset, int length) {
        int size = Math.min(length, data.length - offset);
        short[] buffer = new short[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = (short)(data[offset + i] & 0xFF);
        }
        return Hex.toString(buffer, breakAt);
    }

    public static String toString(short[] data) {
        return Hex.toString(data, -1);
    }

    public static String toString(short[] data, int breakAt) {
        return Hex.toString(data, breakAt, 0, data.length);
    }

    public static String toString(short[] data, int breakAt, int offset, int length) {
        if (data == null) {
            return "null";
        }
        StringBuilder rc = new StringBuilder(4 * data.length);
        int breakCount = breakAt;
        int last = offset + length;
        for (int i = offset; i < last; ++i) {
            if (breakCount == 0) {
                rc.append('\n');
                breakCount = breakAt;
            } else if (i > offset) {
                rc.append(' ');
            }
            --breakCount;
            String str = Integer.toHexString(data[i] & 0xFF);
            if (str.length() < 2) {
                rc.append('0');
            }
            rc.append(str);
        }
        return rc.toString().toUpperCase();
    }

    public static String toString(int[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder rc = new StringBuilder(4 * data.length);
        for (int i = 0; i < data.length; ++i) {
            String str;
            if (i > 0) {
                rc.append(' ');
            }
            if ((str = Integer.toHexString(data[i])).length() < 2) {
                rc.append('0');
            }
            rc.append(str);
        }
        return rc.toString().toUpperCase();
    }

    public static String getRemoteSignature(short[] data) {
        short val;
        int i;
        int sigStart;
        int len = data.length;
        if (len < 2) {
            return null;
        }
        int n = sigStart = data[0] + data[1] == 255 ? 2 : 0;
        if (len < sigStart + 8) {
            return null;
        }
        char[] sig = new char[8];
        for (i = 0; i < 8 && (val = data[sigStart + i]) >= 32 && val < 128; ++i) {
            sig[i] = (char)val;
        }
        while (i < 8) {
            sig[i] = 95;
            ++i;
        }
        return new String(sig);
    }

    public String toString() {
        return Hex.toString(this.data);
    }

    public String toString(int breakAt) {
        return Hex.toString(this.data, breakAt);
    }

    public String toString(int offset, int length) {
        return Hex.toString(this.data, -1, offset, length);
    }

    public static String toString(short[] data, int offset, int length) {
        return Hex.toString(data, -1, offset, length);
    }

    public void print(PrintWriter pw) throws IOException {
        this.print(pw, 0);
    }

    public void print(PrintWriter pw, int base) throws IOException {
        Hex.print(pw, this.data, base);
    }

    public static void print(PrintWriter pw, short[] data) throws IOException {
        Hex.print(pw, data, 0);
    }

    public static void print(PrintWriter pw, short[] data, int base) throws IOException {
        for (int i = 0; i < data.length; i += 16) {
            pw.printf("%04X:", i + base);
            for (int j = 0; j < 16 && i + j < data.length; ++j) {
                pw.printf("  %02X", data[i + j] & 0xFF);
            }
            pw.println();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Hex aHex = (Hex)obj;
        if (this == aHex) {
            return true;
        }
        if (this.data.length != aHex.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if ((this.data[i] & 0xFF) == (aHex.data[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if ((a[i] & 0xFF) == (b[i] & 0xFF)) continue;
            System.err.println(String.format("%04X: %X != %X", i, a[i], b[i]));
            return false;
        }
        return true;
    }

    public int hashCode() {
        int rc = 0;
        if (this.data.length == 0) {
            return 0;
        }
        int multiplier = (int)Math.pow(31.0, this.data.length - 1);
        for (int i = 0; i < this.data.length; ++i) {
            rc += (this.data[i] & 0xFF) * multiplier;
            multiplier /= 31;
        }
        return rc;
    }

    @Override
    public int compareTo(Hex o) {
        int rc;
        int compareLen;
        short[] otherData = o.data;
        if (this.data.length < otherData.length) {
            compareLen = this.data.length;
            rc = -1;
        } else if (this.data.length == otherData.length) {
            compareLen = this.data.length;
            rc = 0;
        } else {
            compareLen = otherData.length;
            rc = 1;
        }
        for (int i = 0; i < compareLen; ++i) {
            int v1 = this.data[i] & 0xFF;
            int v2 = otherData[i] & 0xFF;
            if (v1 < v2) {
                rc = -1;
                break;
            }
            if (v1 <= v2) continue;
            rc = 1;
            break;
        }
        return rc;
    }

    public int indexOf(Hex needle) {
        return this.indexOf(needle.data);
    }

    public int indexOf(Hex needle, int start) {
        return this.indexOf(needle.data, start);
    }

    public int indexOf(short[] needle) {
        return this.indexOf(needle, 0);
    }

    public int indexOf(short[] needle, int start) {
        int last = this.data.length - needle.length;
        for (int index = start; index <= last; ++index) {
            boolean match = true;
            for (int i = 0; i < needle.length; ++i) {
                if (needle[i] == this.data[index + i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return index;
        }
        return -1;
    }

    public Hex subHex(int index) {
        return this.subHex(index, this.data.length - index);
    }

    public Hex subHex(int index, int len) {
        return Hex.subHex(this.data, index, len);
    }

    public String subString(int index, int len) {
        char[] c = new char[len];
        for (int i = 0; i < Math.min(len, this.length() - index); ++i) {
            c[i] = (char)this.data[index + i];
        }
        return new String(c);
    }

    public static Hex subHex(short[] src, int index, int len) {
        if (index + len > src.length) {
            return null;
        }
        short[] dest = new short[len];
        System.arraycopy(src, index, dest, 0, len);
        return new Hex(dest);
    }

    public Hex applyMask(Hex mask) {
        if (this.data.length != mask.data.length) {
            throw new IllegalArgumentException("Mask length doesn't equal data length");
        }
        short[] result = new short[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            result[i] = (short)(this.data[i] & mask.data[i]);
        }
        return new Hex(result);
    }

    protected Object clone() throws CloneNotSupportedException {
        Hex rc = (Hex)super.clone();
        rc.data = (short[])this.data.clone();
        return rc;
    }
}

