/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;

public class HexCodeEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener,
UndoableEditListener,
FocusListener {
    private JButton button;
    private Hex hex = new Hex();
    private JDialog dialog = null;
    private JTextArea textArea = new JTextArea();
    private int preferredWidth = 0;

    private void showDialog(Component c, String text) {
        Component root = SwingUtilities.getRoot(c);
        if (root instanceof JFrame) {
            this.dialog = new JDialog((JFrame)root);
        } else if (root instanceof JDialog) {
            this.dialog = new JDialog((JDialog)root);
        }
        this.preferredWidth = c.getWidth();
        this.dialog.setUndecorated(true);
        this.dialog.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(c.getFont());
        this.textArea.setText(text);
        this.textArea.getDocument().addUndoableEditListener(this);
        this.textArea.addFocusListener(this);
        new TextPopupMenu(this.textArea);
        Dimension size = this.textArea.getPreferredSize();
        size.width = this.preferredWidth;
        this.textArea.setPreferredSize(size);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.dialog.getRootPane().registerKeyboardAction(this, "CANCEL", stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 2);
        this.textArea.registerKeyboardAction(this, "STOP", stroke, 2);
        stroke = KeyStroke.getKeyStroke(9, 0);
        this.textArea.registerKeyboardAction(this, "STOP", stroke, 2);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(c);
        Point p = this.dialog.getLocation();
        int h = this.dialog.getHeight();
        int ch = c.getHeight();
        p.translate(0, (h - ch) / 2);
        this.dialog.setLocation(p);
        this.dialog.setVisible(true);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.update();
    }

    private void update() {
        this.textArea.setPreferredSize(null);
        Dimension d = this.textArea.getPreferredSize();
        if (d.width < this.preferredWidth) {
            d.width = this.preferredWidth;
        }
        this.textArea.setPreferredSize(d);
        this.dialog.pack();
    }

    public HexCodeEditor() {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.button = new JButton();
        this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.button.setHorizontalAlignment(10);
        this.button.setActionCommand("EDIT");
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        System.err.println("command=" + command);
        if ("EDIT".equals(command)) {
            this.showDialog(this.button, this.hex.toString(16));
        } else if ("CANCEL".equals(command)) {
            this.cancelCellEditing();
        } else {
            this.stopCellEditing();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.hex;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.hex = (Hex)value;
        if (this.hex == null) {
            this.hex = new Hex();
        }
        this.button.setText(this.hex.toString());
        return this.button;
    }

    @Override
    public boolean stopCellEditing() {
        System.err.println("stopCellEditing()");
        try {
            this.hex = new Hex(this.textArea.getText());
            this.dialog.setVisible(false);
            return super.stopCellEditing();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void cancelCellEditing() {
        System.err.println("cancelCellEditing()");
        this.dialog.setVisible(false);
        super.cancelCellEditing();
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Component c = event.getOppositeComponent();
        System.err.println("focusLost to " + c.getClass().getName());
        if (c.getClass() != JRootPane.class) {
            this.stopCellEditing();
        }
    }
}

