/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;

public class HexEditor
extends SelectAllCellEditor {
    Hex defaultHex = null;

    public HexEditor() {
        this((Hex)null);
    }

    public HexEditor(Hex defaultHex) {
        this.defaultHex = defaultHex;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        JTextField tf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, col);
        if (value == null) {
            tf.setText("");
        } else {
            tf.setText(((Hex)value).toString());
        }
        return tf;
    }

    @Override
    public Object getCellEditorValue() throws NumberFormatException {
        Hex rc = null;
        JTextField tf = (JTextField)this.getComponent();
        String str = tf.getText().trim();
        if (str != null && str.length() != 0) {
            Hex temp = new Hex(str);
            if (this.defaultHex == null) {
                rc = temp;
            } else {
                if (temp.length() != this.defaultHex.length()) {
                    String msg = "The hex command must contain exactly " + this.defaultHex.length() + " bytes.";
                    KeyMapMaster.showMessage(msg, tf);
                    throw new NumberFormatException(msg);
                }
                KeyMapMaster.clearMessage(tf);
                rc = temp;
            }
        }
        return rc;
    }

    public void setDefaultHex(Hex defaultHex) {
        this.defaultHex = defaultHex;
    }
}

