/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexParmEditorNode;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.TranslatorEditorNode;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public abstract class HexEditorNode
extends ProtocolEditorNode {
    private Hex hex = null;
    private static Hex nullHex = null;
    private String hexName = null;
    private String parmsName = null;
    private String translatorName = null;

    public HexEditorNode(String name, Hex defaultHex, String hexName, String parmsName, String translatorName) {
        super(name, true);
        this.hex = defaultHex;
        if (nullHex == null) {
            nullHex = new Hex(0);
        }
        if (this.hex == null) {
            this.hex = nullHex;
        }
        this.hexName = hexName;
        this.parmsName = parmsName;
        this.translatorName = translatorName;
    }

    public Hex getHex() {
        return this.hex;
    }

    public void setHex(Hex newHex) {
        if (newHex == null) {
            newHex = nullHex;
        }
        Hex oldHex = this.hex;
        this.hex = newHex;
        this.firePropertyChange("Hex", oldHex, newHex);
    }

    @Override
    public void print(PrintWriter pw) {
        Enumeration<TreeNode> children;
        if (this.hex != nullHex) {
            pw.println(this.hexName + this.hex.toString());
        }
        if (!(children = this.children()).hasMoreElements()) {
            return;
        }
        pw.print(this.parmsName);
        while (children.hasMoreElements()) {
            HexParmEditorNode node = (HexParmEditorNode)children.nextElement();
            node.print(pw);
            if (!children.hasMoreElements()) continue;
            pw.print(',');
        }
        pw.println();
        pw.print(this.translatorName);
        children = this.children();
        int parmNumber = 0;
        while (children.hasMoreElements()) {
            HexParmEditorNode devNode = (HexParmEditorNode)children.nextElement();
            Enumeration<TreeNode> xlators = devNode.children();
            while (xlators.hasMoreElements()) {
                TranslatorEditorNode xlator = (TranslatorEditorNode)xlators.nextElement();
                pw.print("Translator(" + parmNumber + ',');
                xlator.print(pw);
                pw.print(')');
                if (!xlators.hasMoreElements()) continue;
                pw.print(' ');
            }
            if (children.hasMoreElements()) {
                pw.print(' ');
            }
            ++parmNumber;
        }
        pw.println();
    }

    @Override
    public boolean canAddChildren() {
        return this.hex != nullHex && this.hex.length() > 0;
    }
}

