/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexEditorNode;
import com.hifiremote.jp1.HexFormatter;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import com.hifiremote.jp1.SpringUtilities;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class HexEditorPanel
extends ProtocolEditorPanel
implements PropertyChangeListener {
    private HexEditorNode node = null;
    private HexFormatter hexFormatter = null;
    private JFormattedTextField hex = null;

    public HexEditorPanel(String title, String name, String toolTipText, String directions, int length) {
        super(title);
        SpringLayout layout = new SpringLayout();
        JPanel panel = new JPanel(layout);
        this.add((Component)panel, "Center");
        JLabel label = new JLabel(name);
        this.hexFormatter = new HexFormatter(length);
        this.hex = new JFormattedTextField(this.hexFormatter);
        this.hex.setFocusLostBehavior(1);
        this.hex.setToolTipText(toolTipText);
        this.hex.addPropertyChangeListener(this);
        Dimension d = this.hex.getMaximumSize();
        d.height = this.hex.getPreferredSize().height;
        this.hex.setMaximumSize(d);
        this.hex.setAlignmentY(0.0f);
        new TextPopupMenu(this.hex);
        label.setLabelFor(this.hex);
        panel.add(label);
        panel.add(this.hex);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 5, 5, 5, 5);
        this.setText(directions);
    }

    @Override
    public void commit() {
    }

    @Override
    public void update(ProtocolEditorNode newNode) {
        this.node = (HexEditorNode)newNode;
        this.hex.removePropertyChangeListener(this);
        this.hex.setValue(this.node.getHex());
        this.hex.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.hex && this.node != null) {
            this.node.setHex((Hex)this.hex.getValue());
        }
    }

    public void setLength(int length) {
        Hex current = (Hex)this.hex.getValue();
        Hex newHex = new Hex(length);
        if (current != null) {
            short[] currentData = current.getData();
            short[] newData = newHex.getData();
            int len = Math.min(currentData.length, newData.length);
            for (int i = 0; i < len; ++i) {
                newData[i] = currentData[i];
            }
        }
        this.hexFormatter.setLength(length);
        this.hex.setValue(newHex);
    }
}

