/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class HexFormat
extends Format {
    private int minLength;
    private int maxLength;

    public HexFormat() {
        this(-1, -1);
    }

    public HexFormat(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer buff, FieldPosition pos) {
        if (obj instanceof Hex) {
            buff.append(((Hex)obj).toString());
        }
        return buff;
    }

    @Override
    public Object parseObject(String text) throws ParseException {
        try {
            Hex hex = new Hex(text);
            int len = hex.length();
            if (this.minLength != -1 && len < this.minLength) {
                throw new ParseException("Too short", 0);
            }
            if (this.maxLength != -1 && len > this.maxLength) {
                throw new ParseException("Too long", text.length());
            }
            return hex;
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public Object parseObject(String text, ParsePosition pos) {
        int index = pos.getIndex();
        int i = 0;
        for (i = index; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.digit(ch, 16) != -1) continue;
            pos.setErrorIndex(i);
            return null;
        }
        pos.setIndex(i);
        return new Hex(text.substring(index));
    }
}

