/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RegexFormatter;

public class HexFormatter
extends RegexFormatter {
    HexFormatter(int length) {
        this.setValueClass(Hex.class);
        this.setAllowsInvalid(true);
        this.setOverwriteMode(true);
        this.setCommitsOnValidEdit(false);
        this.setLength(length);
    }

    public void setLength(int length) {
        if (length > 0) {
            StringBuilder buff = new StringBuilder();
            buff.append("\\p{XDigit}{2}");
            if (length > 1) {
                buff.append("( +\\p{XDigit}{2}){" + (length - 1) + "}");
            }
            this.setPattern(buff.toString());
        } else {
            this.setPattern("(\\p{XDigit}{2}( \\p{XDigit}{2})*)?");
        }
    }
}

