/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.TranslatorEditorNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class HexParmEditorNode
extends ProtocolEditorNode {
    private int bits = 8;
    private int type = 0;
    private int format = 0;
    private List<Integer> choices = new ArrayList<Integer>();
    private int defaultValue = -1;
    public static final int NUMBER = 0;
    public static final int CHOICE = 1;
    public static final int FLAG = 2;
    public static final int DECIMAL = 0;
    public static final int HEXADECIMAL = 1;

    public HexParmEditorNode() {
        super("Parameter", true);
        this.add(new TranslatorEditorNode());
    }

    @Override
    public ProtocolEditorNode createChild() {
        return new TranslatorEditorNode();
    }

    @Override
    public void print(PrintWriter pw) {
        pw.print(this.getName() + ':');
        if (this.format == 1) {
            pw.print('$');
        }
        if (this.type == 0) {
            pw.print(this.bits);
        } else if (this.type == 1) {
            boolean first = true;
            for (Integer choice : this.choices) {
                if (first) {
                    first = false;
                } else {
                    pw.print("|");
                }
                pw.print(choice);
            }
        } else if (this.type == 2) {
            pw.print("bool");
        }
        if (this.defaultValue != -1) {
            pw.print("=" + this.defaultValue);
        }
    }

    public void setDefaultValue(int value) {
        this.defaultValue = value;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public int getBits() {
        if (this.type == 0) {
            return this.bits;
        }
        if (this.type == 2) {
            return 1;
        }
        int numChoices = this.choices.size();
        int rc = 0;
        while (numChoices > 0) {
            numChoices /= 2;
            ++rc;
        }
        if (rc == 0) {
            rc = 1;
        }
        return rc;
    }

    public void setBits(int newBits) {
        this.bits = newBits;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int get_Type() {
        return this.type;
    }

    public void setFormat(int newFormat) {
        this.format = newFormat;
    }

    public int getFormat() {
        return this.format;
    }

    public List<Integer> getChoices() {
        return this.choices;
    }

    public void setChoices(List<Integer> newChoices) {
        this.choices = newChoices;
    }
}

