/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.FocusSelector;
import com.hifiremote.jp1.HexInteger;
import com.hifiremote.jp1.HexIntegerFormatter;
import com.hifiremote.jp1.HexParmEditorNode;
import com.hifiremote.jp1.IntegerFormatter;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;

public class HexParmEditorPanel
extends ProtocolEditorPanel
implements ChangeListener,
ActionListener,
PropertyChangeListener {
    private HexParmEditorNode node = null;
    private JTextField name = null;
    private JRadioButton numberButton = null;
    private JRadioButton choiceButton = null;
    private JRadioButton flagButton = null;
    private JRadioButton[] buttons = null;
    private JPanel card = null;
    private JComponent[] panels = null;
    private JSpinner bits = null;
    private JRadioButton decimal = null;
    private JRadioButton hex = null;
    private JFormattedTextField defaultValue = null;
    private HexIntegerFormatter hexFormatter = null;
    private IntegerFormatter decimalFormatter = null;

    public HexParmEditorPanel(String title) {
        super(title);
        Box outerBox = Box.createVerticalBox();
        outerBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)outerBox, "Center");
        JPanel panel = new JPanel(new FlowLayout(3));
        JLabel label = new JLabel("Name:", 4);
        outerBox.add(panel);
        panel.add(label);
        this.name = new JTextField(20);
        this.name.setToolTipText("Enter the name of the parameter.");
        FocusSelector.selectOnFocus(this.name);
        panel.add(this.name);
        label.setLabelFor(this.name);
        Dimension d = panel.getMaximumSize();
        d.height = panel.getPreferredSize().height;
        panel.setMaximumSize(d);
        panel = new JPanel(new FlowLayout(3));
        outerBox.add(panel);
        JLabel newLabel = new JLabel("Parameter Type:");
        panel.add(newLabel);
        Dimension labelSize = newLabel.getPreferredSize();
        label.setPreferredSize(labelSize);
        ButtonGroup group = new ButtonGroup();
        this.numberButton = this.createRadioButton("Numeric", 78, "Select this type if you want the user to enter a numeric value for this parameter.", panel, group);
        this.choiceButton = this.createRadioButton("List", 76, "Select this type if you want the user to pick from a list of predefined choices.", panel, group);
        this.flagButton = this.createRadioButton("Check box", 67, "Select this type if you want the paremter presented as a check box.", panel, group);
        d = panel.getMaximumSize();
        d.height = panel.getPreferredSize().height;
        panel.setMaximumSize(d);
        this.buttons = new JRadioButton[3];
        this.buttons[0] = this.numberButton;
        this.buttons[1] = this.choiceButton;
        this.buttons[2] = this.flagButton;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setActionCommand(Integer.toString(i));
        }
        this.card = new JPanel(new CardLayout());
        outerBox.add(this.card);
        this.panels = new JComponent[3];
        Box panelBox = Box.createVerticalBox();
        this.panels[0] = panelBox;
        JPanel boxPanel = new JPanel(new FlowLayout(0));
        panelBox.add(boxPanel);
        this.panels[1] = new JPanel();
        this.panels[1].add(new JLabel("Panel for choice parameters"));
        this.panels[2] = new JPanel();
        this.panels[2].add(new JLabel("Panel for flag parameters"));
        for (int i = 0; i < this.panels.length; ++i) {
            this.card.add((Component)this.panels[i], Integer.toString(i));
        }
        outerBox.add(Box.createVerticalGlue());
        label = new JLabel("Bits:", 4);
        label.setPreferredSize(labelSize);
        boxPanel.add(label);
        this.bits = new JSpinner(new SpinnerNumberModel(8, 0, 16, 1));
        boxPanel.add(this.bits);
        HexParmEditorPanel.limitHeight(boxPanel);
        label.setLabelFor(this.bits);
        this.bits.addChangeListener(this);
        boxPanel = new JPanel(new FlowLayout(0));
        panelBox.add(boxPanel);
        label = new JLabel("Format:", 4);
        boxPanel.add(label);
        label.setPreferredSize(labelSize);
        group = new ButtonGroup();
        this.decimal = new JRadioButton("Decimal");
        boxPanel.add(this.decimal);
        group.add(this.decimal);
        this.hex = new JRadioButton("Hexadecimal");
        boxPanel.add(this.hex);
        group.add(this.hex);
        HexParmEditorPanel.limitHeight(boxPanel);
        boxPanel = new JPanel(new FlowLayout(0));
        panelBox.add(boxPanel);
        label = new JLabel("Default value:", 4);
        boxPanel.add(label);
        label.setPreferredSize(labelSize);
        this.decimalFormatter = new IntegerFormatter(8);
        this.hexFormatter = new HexIntegerFormatter(8);
        this.defaultValue = new JFormattedTextField();
        this.defaultValue.setPreferredSize(this.name.getPreferredSize());
        boxPanel.add(this.defaultValue);
        HexParmEditorPanel.limitHeight(boxPanel);
        this.setText("Enter the requested information about the parameter.\n\nEach parameter can have one or more translators associated with it.");
        this.addListeners();
    }

    private static void limitHeight(JComponent c) {
        Dimension d = c.getMaximumSize();
        d.height = c.getPreferredSize().height;
        c.setMaximumSize(d);
    }

    private JRadioButton createRadioButton(String name, int mnemonic, String tip, JPanel panel, ButtonGroup group) {
        JRadioButton button = new JRadioButton(name);
        button.setMnemonic(mnemonic);
        button.setToolTipText(tip);
        panel.add(button);
        group.add(button);
        return button;
    }

    @Override
    public void update(ProtocolEditorNode newNode) {
        this.node = (HexParmEditorNode)newNode;
        this.removeListeners();
        this.name.setText(this.node.getName());
        int type = this.node.get_Type();
        this.buttons[type].setSelected(true);
        ((CardLayout)this.card.getLayout()).show(this.card, Integer.toString(type));
        if (this.numberButton.isSelected()) {
            int numBits = this.node.getBits();
            this.bits.setValue(new Integer(numBits));
            this.decimalFormatter.setBits(numBits);
            this.hexFormatter.setBits(numBits);
            if (this.node.getFormat() == 0) {
                this.decimal.setSelected(true);
                this.defaultValue.setFormatterFactory(new DefaultFormatterFactory(this.decimalFormatter));
            } else {
                this.hex.setSelected(true);
                this.defaultValue.setFormatterFactory(new DefaultFormatterFactory(this.hexFormatter));
            }
            int val = this.node.getDefaultValue();
            if (val == -1) {
                this.defaultValue.setValue(null);
            } else {
                this.defaultValue.setValue(new Integer(val));
            }
        }
        this.addListeners();
    }

    private void removeListeners() {
        this.name.removeActionListener(this);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].removeActionListener(this);
        }
        this.bits.removeChangeListener(this);
        this.decimal.removeActionListener(this);
        this.hex.removeActionListener(this);
        this.defaultValue.removePropertyChangeListener("value", this);
    }

    private void addListeners() {
        this.name.addActionListener(this);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].addActionListener(this);
        }
        this.bits.addChangeListener(this);
        this.decimal.addActionListener(this);
        this.hex.addActionListener(this);
        this.defaultValue.addPropertyChangeListener("value", this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.bits) {
            int numBits = (Integer)this.bits.getValue();
            System.err.println("numBits=" + numBits);
            this.node.setBits(numBits);
            this.hexFormatter.setBits(numBits);
            this.decimalFormatter.setBits(numBits);
            int mask = (2 << numBits - 1) - 1;
            System.err.println("Mask is " + mask);
            int val = this.node.getDefaultValue();
            if (val > mask) {
                val &= mask;
                if (this.decimal.isSelected()) {
                    this.defaultValue.setValue(new Integer(val));
                } else {
                    this.defaultValue.setValue(new HexInteger(val));
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String command = e.getActionCommand();
        if (source == this.name) {
            String text = this.name.getText();
            if (!text.equals(this.node.getName())) {
                this.node.setName(text);
            }
        } else if (source == this.decimal) {
            this.removeListeners();
            Object value = this.defaultValue.getValue();
            System.err.println("got value " + value);
            this.defaultValue.setValue(null);
            this.defaultValue.setFormatterFactory(new DefaultFormatterFactory(this.decimalFormatter));
            this.defaultValue.setValue(value);
            this.addListeners();
            this.node.setFormat(0);
        } else if (source == this.hex) {
            this.removeListeners();
            Object value = this.defaultValue.getValue();
            System.err.println("got value " + value);
            this.defaultValue.setValue(null);
            this.defaultValue.setFormatterFactory(new DefaultFormatterFactory(this.hexFormatter));
            this.defaultValue.setValue(value);
            this.addListeners();
            this.node.setFormat(1);
        } else if (command != null) {
            int i = Integer.parseInt(command);
            this.node.setType(i);
            ((CardLayout)this.card.getLayout()).show(this.card, command);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        String propertyName = e.getPropertyName();
        if (!propertyName.equals("value")) {
            return;
        }
        System.err.println("propertyChange( " + e.getPropertyName() + " )");
        if (source == this.defaultValue) {
            Number val = (Number)e.getNewValue();
            System.err.println("value=" + val);
            if (val == null) {
                this.node.setDefaultValue(-1);
            } else {
                this.node.setDefaultValue(val.intValue());
            }
        }
    }
}

