/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Segment;
import java.awt.Color;
import java.util.List;
import java.util.Properties;

public class Highlight
extends GeneralFunction {
    private int memoryUsage = 0;
    private Color highlight = Color.WHITE;
    private Segment segment = null;
    private int segmentFlags = 0;
    private int index = 0;
    private UploadStatus uploadStatus = UploadStatus.NO;
    private List<Integer> userItems = null;

    public Highlight() {
    }

    public Highlight(Properties props) {
        super(props);
        String temp = props.getProperty("SegmentFlags");
        this.segmentFlags = temp == null ? 0 : Integer.parseInt(temp);
    }

    public UploadStatus getUploadStatus() {
        return this.uploadStatus;
    }

    public void setUploadStatus(UploadStatus uploadStatus) {
        this.uploadStatus = uploadStatus;
    }

    public List<Integer> getUserItems() {
        return this.userItems;
    }

    public void setUserItems(List<Integer> userItems) {
        this.userItems = userItems;
    }

    protected boolean forUpload() {
        return this.getUploadStatus() == UploadStatus.YES || this.getUploadStatus() == UploadStatus.WARN || this.getUploadStatus() == UploadStatus.INFO;
    }

    public Color getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Color highlight) {
        this.highlight = highlight;
    }

    public void setHighlight(Highlight hl) {
        this.highlight = hl.highlight;
        this.segmentFlags = hl.segmentFlags;
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public void clearMemoryUsage() {
        this.memoryUsage = 0;
    }

    public void setMemoryUsage(int memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public void addMemoryUsage(int memoryUsage) {
        this.memoryUsage += memoryUsage;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }

    public void setSegment(Segment segment, int index) {
        this.segment = segment;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSegmentFlags() {
        return this.segmentFlags;
    }

    public void setSegmentFlags(int segmentFlags) {
        this.segmentFlags = segmentFlags;
    }

    @Override
    public void store(PropertyWriter pw) {
        super.store(pw);
        if (this.segmentFlags > 0) {
            pw.print("SegmentFlags", this.segmentFlags);
        }
    }

    protected static enum UploadStatus {
        YES,
        NO,
        WARN,
        INFO,
        TEST;

    }
}

