/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ActivityFunctionTableModel;
import com.hifiremote.jp1.ActivityGroupTableModel;
import com.hifiremote.jp1.ActivityPanel;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeTableModel;
import com.hifiremote.jp1.FavScanTableModel;
import com.hifiremote.jp1.FavoritesPanel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.KeyCodeRenderer;
import com.hifiremote.jp1.KeyMoveTableModel;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.Setting;
import com.hifiremote.jp1.SettingsTableModel;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;

public class HtmlGenerator {
    String prefix = "";
    String pfxIncr = "  ";
    RemoteConfiguration remoteConfig = null;

    public HtmlGenerator(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public static String getHtmlString(String name) {
        String s = name.trim();
        if (s.isEmpty()) {
            return "";
        }
        if (s.startsWith("<html>")) {
            s = s.replaceAll("\\</?html\\>", "");
            s = s.replace("<br>", "<br/>");
            Pattern p = Pattern.compile("\\&.*?(\\<|;|\\s)");
            Matcher m = null;
            int n = 0;
            while ((m = p.matcher(s)).find(n)) {
                n = m.end();
                if (s.charAt(n - 1) == ';') continue;
                s = s.substring(0, n - 1) + ";" + s.substring(n - 1);
                ++n;
            }
        } else {
            s = s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
        }
        return s;
    }

    private String getTableRow(RMIRSetup.SummarySection ss, int row) {
        Remote remote = this.remoteConfig.getRemote();
        JP1TableModel<?> model = ss.model;
        String ls = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix + "<tr>" + ls);
        this.prefix = this.prefix + this.pfxIncr;
        for (int col = 0; col < model.getColumnCount(); ++col) {
            int xcol = ss.table != null ? ss.table.convertColumnIndexToModel(col) : col;
            Object val = model.getValueAt(row, xcol);
            String suffix = "";
            if (val == null) {
                val = "";
            }
            if (model.getColumnClass(xcol) == Color.class) {
                Object item = model.getRow(row);
                if (!(item instanceof Highlight)) continue;
                int mem = ((Highlight)item).getMemoryUsage();
                val = Math.abs(mem);
                if (model instanceof SettingsTableModel) {
                    suffix = mem == -1 ? " bit" : (mem < 0 ? " bits" : (mem == 1 ? " byte" : "bytes"));
                }
            } else if (model.getColumnRenderer(xcol) instanceof KeyCodeRenderer) {
                val = remote.getButtonName((Integer)val);
            }
            if (model instanceof DeviceUpgradeTableModel) {
                DeviceUpgradeTableModel dutm = (DeviceUpgradeTableModel)model;
                DeviceUpgrade du = (DeviceUpgrade)dutm.getRow(row);
                switch (dutm.getEffectiveColumn(xcol)) {
                    case 5: {
                        val = du.getSetupCode() < 0 ? "" : du.getStarredID();
                        break;
                    }
                    case 6: {
                        Protocol protocol = du.getSetupCode() < 0 ? null : (Protocol)val;
                        val = protocol == null ? "" : protocol.getVariantDisplayName(remote.getProcessor());
                        break;
                    }
                    case 10: {
                        val = du.getProtocolMemoryUsage();
                    }
                }
            } else if (model instanceof ActivityFunctionTableModel) {
                ActivityFunctionTableModel aftm = (ActivityFunctionTableModel)model;
                if (aftm.getColumnClass(col) == List.class) {
                    val = val instanceof List ? Macro.getValueString((List)val) : (val instanceof Hex ? Macro.getValueString((Hex)val, this.remoteConfig) : "");
                }
            } else if (model instanceof KeyMoveTableModel && model.getColumnRenderer(xcol) instanceof RowNumberRenderer && row >= this.remoteConfig.getKeyMoves().size()) {
                val = val.toString() + "*";
            }
            String valStr = HtmlGenerator.getHtmlString(val.toString());
            sb.append(this.prefix + "<td>");
            sb.append(valStr + suffix);
            sb.append("</td>" + ls);
        }
        this.prefix = this.prefix.substring(this.pfxIncr.length());
        sb.append(this.prefix + "</tr>" + ls);
        return sb.toString();
    }

    public boolean makeHtml(List<RMIRSetup.SummarySection> ssList) {
        if (ssList == null) {
            return false;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(RMIRSetup.getSummaryFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        PrintWriter pw = new PrintWriter(fw);
        pw.println("<html>");
        this.prefix = this.pfxIncr;
        pw.println(this.prefix + "<head>");
        this.prefix = this.prefix + this.pfxIncr;
        pw.println(this.prefix + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        pw.println(this.prefix + "<style>");
        pw.println(this.prefix + "  table, th, td {");
        pw.println(this.prefix + "    border: 1px solid black;");
        pw.println(this.prefix + "    border-collapse: collapse;");
        pw.println(this.prefix + "  }");
        pw.println(this.prefix + "</style>");
        this.prefix = this.prefix.substring(this.pfxIncr.length());
        pw.println(this.prefix + "</head>");
        pw.println(this.prefix + "<body>");
        this.prefix = this.prefix + this.pfxIncr;
        int currentActivityIndex = -1;
        ActivityPanel ap = this.remoteConfig.getOwner().getActivityPanel();
        FavoritesPanel fp = this.remoteConfig.getOwner().getFavoritesPanel();
        Remote remote = this.remoteConfig.getRemote();
        pw.println(this.prefix + "<h2>" + remote.getName() + "</h2>");
        File file = this.remoteConfig.getOwner().file;
        if (file != null) {
            pw.println(this.prefix + "<p>File: " + file.getAbsolutePath() + "</p>");
        }
        for (RMIRSetup.SummarySection ss : ssList) {
            JP1TableModel<?> model = ss.model;
            if (ss.activity != null) {
                currentActivityIndex = ap.getTabbedPane().getSelectedIndex();
                Button btn = ss.activity.getButton();
                if (model instanceof ActivityFunctionTableModel) {
                    ActivityFunctionTableModel aftm = (ActivityFunctionTableModel)model;
                    aftm.set(btn, this.remoteConfig);
                } else if (model instanceof ActivityGroupTableModel) {
                    ActivityGroupTableModel agtm = (ActivityGroupTableModel)model;
                    agtm.set(btn, this.remoteConfig, null);
                }
            }
            pw.println(this.prefix + "<h3>" + (ss.title == null ? "" : ss.title) + "</h3>");
            if (ss.subtitle != null && !ss.subtitle.trim().isEmpty()) {
                pw.println(this.prefix + "<h4>" + ss.subtitle + "</h4>");
            }
            if (ss.model instanceof FavScanTableModel) {
                DeviceButton favDb = this.remoteConfig.getFavKeyDevButton();
                if (remote.hasFavorites()) {
                    Button favFinalKey = favDb.getFavFinalKey();
                    pw.println(this.prefix + "<p>");
                    pw.println(this.prefix + "  Channel change device: " + HtmlGenerator.getHtmlString(favDb.toString()) + "<br/>");
                    String pause = String.format("%2.1f sec", (double)this.remoteConfig.getRemote().getFavKey().getFavPause() / 10.0);
                    pw.println(this.prefix + "  Interdigit pause: " + pause + "<br/>");
                    pw.println(this.prefix + "  Digits: " + (favDb == null || favDb == DeviceButton.noButton ? 0 : favDb.getFavoriteWidth()) + "<br/>");
                    pw.println(this.prefix + "  Send final key? " + (favFinalKey == null ? "no" : "yes<br/>Key: " + favFinalKey));
                    pw.println(this.prefix + "</p>");
                } else {
                    pw.println(this.prefix + "<p>  Scan device: " + HtmlGenerator.getHtmlString(favDb.toString()) + "</p>");
                }
            } else if (ss.model instanceof KeyMoveTableModel) {
                String note = "In the KeyMove table, a * against a row number indicates that the key move is attached to a device upgrade.";
                pw.println(this.prefix + "<p>" + note + "</p>");
            } else if (ss.model instanceof SettingsTableModel) {
                SettingsTableModel stm = (SettingsTableModel)ss.model;
                boolean started = false;
                Pattern p = Pattern.compile(".*?shift.*?key.*");
                for (int row = 0; row < stm.getRowCount(); ++row) {
                    Setting setting = remote.getSettings()[row];
                    String title = setting.getTitle().toLowerCase();
                    Matcher m = p.matcher(title);
                    if (!m.matches()) continue;
                    if (started) {
                        pw.println("<br/>");
                        pw.print(this.prefix);
                    } else {
                        pw.print(this.prefix + "<p>");
                        started = true;
                    }
                    String btnName = remote.getButtonName(setting.getValue());
                    int ndx = title.indexOf("key");
                    String settingName = setting.getTitle().substring(0, ndx += title.replaceAll("\\s", "").contains("shiftkey") ? 3 : 0).trim();
                    pw.print(settingName + " is " + btnName);
                }
                if (started) {
                    pw.println("</p>");
                }
            }
            pw.println(this.prefix + "<table>");
            this.prefix = this.prefix + this.pfxIncr;
            pw.print(this.getTableHead(ss));
            if (model != fp.getActivityGroupModel() || fp.getFavModel().getRowCount() > 0) {
                for (int row = 0; row < model.getRowCount(); ++row) {
                    int modelRow = ss.sorter != null ? ss.sorter.modelIndex(row) : row;
                    pw.print(this.getTableRow(ss, modelRow));
                }
            }
            this.prefix = this.prefix.substring(this.pfxIncr.length());
            pw.println(this.prefix + "</table>");
        }
        if (currentActivityIndex >= 0) {
            ap.getTabbedPane().setSelectedIndex(currentActivityIndex);
            ChangeEvent e = new ChangeEvent(ap.getTabbedPane());
            ap.stateChanged(e);
        }
        pw.println(this.prefix + "<p>RDFs loaded from " + JP1Frame.getProperties().getProperty("RDFPath") + "</p>");
        this.prefix = this.prefix.substring(this.pfxIncr.length());
        pw.println(this.prefix + "</body>");
        this.prefix = this.prefix.substring(this.pfxIncr.length());
        pw.println(this.prefix + "</html>");
        pw.close();
        try {
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String getTableHead(RMIRSetup.SummarySection ss) {
        JP1TableModel<?> model = ss.model;
        String ls = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix + "<tr>" + ls);
        this.prefix = this.prefix + this.pfxIncr;
        for (int col = 0; col < model.getColumnCount(); ++col) {
            int xcol = ss.table != null ? ss.table.convertColumnIndexToModel(col) : col;
            String colHead = HtmlGenerator.getHtmlString(model.getColumnName(xcol));
            sb.append(this.prefix + "<th>" + colHead + "</th>" + ls);
        }
        this.prefix = this.prefix.substring(this.pfxIncr.length());
        sb.append(this.prefix + "</tr>" + ls);
        return sb.toString();
    }
}

