/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonShape;
import com.hifiremote.jp1.Remote;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ImageMap {
    private File mapFile;
    private File imageFile;
    private List<ButtonShape> shapes = new ArrayList<ButtonShape>();

    public ImageMap(File mapFile) {
        this.mapFile = mapFile;
    }

    public void parse(Remote remote) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(this.mapFile));
        String line = in.readLine();
        if (line.startsWith("#$")) {
            while ((line = in.readLine()) != null) {
                double h;
                double w;
                double y2;
                StringTokenizer st;
                String type;
                if (line.startsWith("#$GIF:")) {
                    this.imageFile = new File(this.mapFile.getParentFile(), line.substring(6));
                    continue;
                }
                if (line.startsWith("#") || (type = (st = new StringTokenizer(line, " ,")).nextToken()).equals("default")) continue;
                String displayName = null;
                String keyCodeText = null;
                String buttonName = st.nextToken();
                int pos = buttonName.indexOf(58);
                if (pos != -1) {
                    keyCodeText = buttonName.substring(0, pos);
                    buttonName = buttonName.substring(pos + 1);
                }
                if ((pos = buttonName.indexOf(61)) != -1) {
                    displayName = buttonName.substring(0, pos);
                    buttonName = buttonName.substring(pos + 1);
                }
                Button button = null;
                if (keyCodeText != null) {
                    int keyCode = keyCodeText.charAt(0) == '$' ? Integer.parseInt(keyCodeText.substring(1), 16) : Integer.parseInt(keyCodeText);
                    button = remote.getButton(keyCode);
                } else {
                    button = remote.getButton(buttonName);
                }
                Shape shape = null;
                if (button == null) {
                    if (Remote.prelimLoad) continue;
                    System.err.println("Warning: Shape defined for unknown button " + buttonName);
                    continue;
                }
                if (type.equals("rect")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    double x2 = Double.parseDouble(st.nextToken());
                    y2 = Double.parseDouble(st.nextToken());
                    w = x2 - x;
                    h = y2 - y;
                    shape = new Rectangle2D.Double(x, y, w, h);
                } else if (type.equals("circle")) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    double x2 = Double.parseDouble(st.nextToken());
                    y2 = Double.parseDouble(st.nextToken());
                    w = x2 - x;
                    h = y2 - y;
                    if (w == 0.0) {
                        w = h;
                    }
                    x -= w;
                    w += w;
                    y -= h;
                    h += h;
                    shape = new Ellipse2D.Double(x, y, w, h);
                } else if (type.equals("poly")) {
                    GeneralPath path = new GeneralPath(0, st.countTokens() / 2);
                    float x1 = Float.parseFloat(st.nextToken());
                    float y1 = Float.parseFloat(st.nextToken());
                    path.moveTo(x1, y1);
                    while (st.hasMoreTokens()) {
                        float x = Float.parseFloat(st.nextToken());
                        float y = Float.parseFloat(st.nextToken());
                        if (x == x1 && y == y1) break;
                        path.lineTo(x, y);
                    }
                    path.closePath();
                    shape = path;
                }
                ButtonShape buttonShape = new ButtonShape(shape, button);
                button.setHasShape(true);
                if (displayName != null) {
                    buttonShape.setName(displayName);
                }
                this.shapes.add(buttonShape);
            }
        }
        in.close();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public File getMapFile() {
        return this.mapFile;
    }

    public List<ButtonShape> getShapes() {
        return this.shapes;
    }
}

