/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.SetupCodeFilter;
import com.hifiremote.jp1.TextPopupMenu;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class ImportRawUpgradeDialog
extends JDialog
implements ActionListener,
DocumentListener,
ItemListener {
    private DeviceUpgrade deviceUpgrade = null;
    private JComboBox remoteList = null;
    private Remote remote = null;
    private JTextField setupCode = null;
    private int originalSetupCode = 0;
    private String originalDeviceTypeName = null;
    private int confirm = 0;
    private String description = null;
    private boolean restrictRemote = false;
    private JComboBox<String> sortOrderList = null;
    private RemoteManager mgr = RemoteManager.getRemoteManager();
    private JComboBox deviceTypeList = null;
    private JCheckBox protocolGreaterThanFF = null;
    private JTextArea upgradeCode = null;
    private JScrollPane upgradeScroll = null;
    private JLabel protocolLabel = null;
    private JTextArea protocolCode = null;
    private String extractProcessor = null;
    private Hex uCode = null;
    private Hex pid = null;
    private Hex pCode = null;
    private List<ImportedKeyMove> keyMoves = null;
    private JButton ok = null;
    private JButton reset = null;
    private JButton cancel = null;

    public ImportRawUpgradeDialog(JFrame owner, DeviceUpgrade deviceUpgrade, boolean restrictRemote) {
        super(owner, "Import Raw Upgrade", true);
        this.createGui(owner, deviceUpgrade, restrictRemote);
    }

    public ImportRawUpgradeDialog(JDialog owner, DeviceUpgrade deviceUpgrade, boolean restrictRemote) {
        super(owner, "Import Raw Upgrade", true);
        this.createGui(owner, deviceUpgrade, restrictRemote);
    }

    private void prefillFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(clipboard);
        if (clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                this.loadUpgrade(s);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private void createGui(Component owner, DeviceUpgrade deviceUpgrade, boolean restrictRemote) {
        this.deviceUpgrade = deviceUpgrade;
        this.restrictRemote = restrictRemote;
        this.setLocationRelativeTo(owner);
        Container contentPane = this.getContentPane();
        double b = 5.0;
        double c = 10.0;
        double d = 40.0;
        double pr = -2.0;
        double[][] size = new double[][]{{b, pr, c, pr, b}, {b, pr, b, pr, b, pr, b, pr, b, pr, b, pr, pr, c, pr, pr, b, pr, d}};
        TableLayout tl = new TableLayout(size);
        JPanel mainPanel = new JPanel(tl);
        contentPane.add((Component)mainPanel, "Center");
        JLabel label = new JLabel("Remote:");
        mainPanel.add((Component)label, "1, 1");
        this.remoteList = restrictRemote ? this.mgr.getRemotesBox(deviceUpgrade.getRemote(), 0) : this.mgr.getRemotesBox(null, 0);
        label.setLabelFor(this.remoteList);
        this.remoteList.setSelectedItem(deviceUpgrade.getRemote());
        this.remoteList.addItemListener(this);
        mainPanel.add((Component)this.remoteList, "3, 1");
        label = new JLabel("Sort by:");
        mainPanel.add((Component)label, "1, 3");
        this.sortOrderList = new JComboBox<String>(new String[]{"Name", "Signature"});
        this.sortOrderList.addItemListener(this);
        mainPanel.add(this.sortOrderList, "3, 3");
        label = new JLabel("Setup code:");
        mainPanel.add((Component)label, "1, 5");
        this.setupCode = new JTextField();
        label.setLabelFor(this.setupCode);
        SetupCodeFilter filter = new SetupCodeFilter(this.setupCode);
        ((AbstractDocument)this.setupCode.getDocument()).setDocumentFilter(filter);
        mainPanel.add((Component)this.setupCode, "3, 5");
        label = new JLabel("Device Type:");
        mainPanel.add((Component)label, "1, 7");
        String[] aliasNames = deviceUpgrade.getRemote().getDeviceTypeAliasNames();
        String alias = deviceUpgrade.getDeviceTypeAliasName();
        this.deviceTypeList = new JComboBox<String>(aliasNames);
        label.setLabelFor(this.deviceTypeList);
        this.deviceTypeList.setMaximumRowCount(aliasNames.length);
        this.deviceTypeList.setSelectedItem(alias);
        mainPanel.add((Component)this.deviceTypeList, "3, 7");
        this.protocolGreaterThanFF = new JCheckBox("Protocol > FF");
        this.protocolGreaterThanFF.addItemListener(this);
        mainPanel.add((Component)this.protocolGreaterThanFF, "3, 9");
        this.protocolGreaterThanFF.setVisible(!deviceUpgrade.getRemote().usesTwoBytePID());
        label = new JLabel("Upgrade Code:");
        mainPanel.add((Component)label, "1, 11, 3, 11");
        this.upgradeCode = new JTextArea(10, 50);
        this.upgradeCode.setWrapStyleWord(true);
        this.upgradeCode.setLineWrap(true);
        this.upgradeCode.getDocument().addDocumentListener(this);
        new TextPopupMenu(this.upgradeCode);
        label.setLabelFor(this.upgradeCode);
        this.upgradeScroll = new JScrollPane(this.upgradeCode);
        mainPanel.add((Component)this.upgradeScroll, "1, 12, 3, 12");
        this.protocolLabel = new JLabel("Protocol Code:");
        mainPanel.add((Component)this.protocolLabel, "1, 14, 3, 14");
        this.protocolCode = new JTextArea(10, 50);
        this.protocolCode.setWrapStyleWord(true);
        this.protocolCode.setLineWrap(true);
        this.protocolCode.getDocument().addDocumentListener(this);
        this.protocolCode.setEnabled(false);
        new TextPopupMenu(this.protocolCode);
        this.protocolLabel.setLabelFor(this.protocolCode);
        mainPanel.add((Component)new JScrollPane(this.protocolCode), "1, 15, 3, 15");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 15, 0));
        this.ok = new JButton("OK");
        this.ok.setEnabled(false);
        this.ok.setMnemonic(79);
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        this.reset = new JButton("Reset");
        this.reset.setMnemonic(82);
        this.reset.addActionListener(this);
        buttonPanel.add(this.reset);
        this.cancel = new JButton("Cancel");
        this.cancel.setMnemonic(67);
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        mainPanel.add((Component)buttonPanel, "1, 17, 3, 17");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
        this.prefillFromClipboard();
    }

    public void setRemote(Remote remote) {
        this.remoteList.setSelectedItem(remote);
    }

    private boolean loadUpgrade(String text) {
        boolean rc;
        block19: {
            rc = false;
            try {
                String[] tokens;
                BufferedReader rdr = new BufferedReader(new StringReader(text));
                String line = "";
                while (line != null && line.equals("")) {
                    line = rdr.readLine();
                }
                if (line.toUpperCase().startsWith("UPGRADE CODE")) {
                    String deviceTypeName;
                    rc = true;
                    tokens = line.split("[=(/)]");
                    this.originalDeviceTypeName = deviceTypeName = tokens[2];
                    this.deviceTypeList.setSelectedItem(deviceTypeName);
                    this.setupCode.setText(tokens[3]);
                    this.originalSetupCode = Integer.parseInt(tokens[3]);
                    int descStart = line.indexOf(41) + 1;
                    int descEnd = line.lastIndexOf(40);
                    String string = this.description = descEnd > descStart ? line.substring(descStart, descEnd).trim() : "";
                    if (this.description.isEmpty()) {
                        this.description = null;
                    }
                    StringBuilder sb = new StringBuilder();
                    while ((line = rdr.readLine()) != null && !line.trim().equalsIgnoreCase("End")) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(line);
                    }
                    SwingUtilities.invokeLater(new TextUpdater(this.upgradeCode, sb.toString()));
                    line = rdr.readLine();
                    while (line != null && line.equals("")) {
                        line = rdr.readLine();
                    }
                }
                if (line != null && line.toUpperCase().startsWith("UPGRADE PROTOCOL") && this.protocolCode.isEnabled()) {
                    rc = true;
                    tokens = line.split("[=()]");
                    Hex pid = new Hex(tokens[1]);
                    this.protocolGreaterThanFF.setSelected(pid.get(0) > 255);
                    StringBuilder sb = new StringBuilder();
                    while ((line = rdr.readLine()) != null && !line.trim().equalsIgnoreCase("End")) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(line);
                    }
                    SwingUtilities.invokeLater(new TextUpdater(this.protocolCode, sb.toString()));
                }
                if (line != null && line.contains(",")) {
                    tokens = line.split(",");
                    if (tokens.length < 5) {
                        return false;
                    }
                    String extractSignature = tokens[0];
                    List<Remote> remotes = this.mgr.findRemoteBySignature(extractSignature);
                    if (remotes.size() == 0) {
                        return false;
                    }
                    this.remote = remotes.get(0);
                    this.remote.load();
                    this.extractProcessor = null;
                    if (!this.restrictRemote) {
                        this.remoteList.setSelectedItem(this.remote);
                    }
                    int mode = Integer.parseInt(tokens[1]);
                    DeviceType deviceType = this.remote.getDeviceTypeByIndex(mode);
                    String aliasName = this.remote.getDeviceTypeAlias(deviceType);
                    DefaultComboBoxModel<String> aliasModel = new DefaultComboBoxModel<String>(new String[]{aliasName});
                    this.deviceTypeList.setModel(aliasModel);
                    this.deviceTypeList.setSelectedItem(aliasName);
                    this.setupCode.setText(tokens[2]);
                    this.pid = new Hex(tokens[3]);
                    this.protocolGreaterThanFF.setSelected(this.pid.getData()[0] > 0);
                    String uString = tokens[4];
                    if (tokens.length > 9) {
                        this.extractProcessor = this.remote.getProcessor().getEquivalentName();
                        if (this.restrictRemote) {
                            Remote currentRemote = (Remote)this.remoteList.getSelectedItem();
                            String remoteProcessor = currentRemote.getProcessor().getEquivalentName();
                            if (!this.extractProcessor.equals(remoteProcessor)) {
                                String message = "This upgrade requires a " + this.extractProcessor + " processor and so is\nnot compatible with the current remote.";
                                String title = "Upgrade incompatibility";
                                JOptionPane.showMessageDialog(this, message, title, 1);
                            }
                        } else {
                            String pString = tokens[9];
                            SwingUtilities.invokeLater(new TextUpdater(this.protocolCode, pString));
                        }
                    }
                    SwingUtilities.invokeLater(new TextUpdater(this.upgradeCode, uString));
                    rc = true;
                }
            }
            catch (Exception ex) {
                if (!rc) break block19;
                String message = "Import data is not valid";
                JOptionPane.showMessageDialog(this, message, "Error parsing import data", 0);
                rc = false;
            }
        }
        return rc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.ok) {
            if (this.confirm > 0) {
                String title = "Protocol Code";
                String message = null;
                switch (this.confirm) {
                    case 1: {
                        message = "This upgrade will use custom protocol code already present\nin this configuration.\n\nDo you want to continue?";
                        break;
                    }
                    case 2: {
                        message = "This upgrade will set custom protocol code for the built-in\nprotocol with pid = " + this.pid + " that will be used by all upgrades that\nuse this pid.\n\nDo you want to continue?";
                        break;
                    }
                    default: {
                        message = "There is a problem with this upgrade.  Do you want to continue?";
                    }
                }
                if (JOptionPane.showConfirmDialog(this, message, title, 0, 1) == 1) {
                    return;
                }
            }
            this.setVisible(false);
            try {
                Remote remote = (Remote)this.remoteList.getSelectedItem();
                this.deviceUpgrade.importRawUpgrade(this.uCode, remote, (String)this.deviceTypeList.getSelectedItem(), this.pid, this.pCode);
                this.deviceUpgrade.setDescription(this.description);
                if (!this.setupCode.getText().equals("")) {
                    try {
                        this.deviceUpgrade.setSetupCode(Integer.parseInt(this.setupCode.getText()));
                    }
                    catch (NumberFormatException message) {
                        // empty catch block
                    }
                }
                if (this.keyMoves != null) {
                    int devType = remote.getDeviceTypeByAliasName(this.originalDeviceTypeName).getNumber();
                    for (ImportedKeyMove km : this.keyMoves) {
                        Function f;
                        String name = km.getName();
                        if (name.isEmpty()) {
                            name = remote.getButtonName(km.getKeyCode());
                        }
                        int btnState = 0;
                        Button b = remote.getButton(km.getKeyCode());
                        if (b == null) {
                            btnState = 1;
                            b = remote.getButton(km.getKeyCode() & ~remote.getShiftMask());
                        }
                        if (b == null) {
                            btnState = 2;
                            b = remote.getButton(km.getKeyCode() & ~remote.getXShiftMask());
                        }
                        if (km.getDeviceType() == devType && km.getSetupCode() == this.originalSetupCode) {
                            f = new Function(name, km.getCmd(remote), km.getNotes());
                            f.setUpgrade(this.deviceUpgrade);
                            Function equiv = f.getEquivalent(this.deviceUpgrade.getFunctions());
                            if (equiv != null) {
                                f = equiv;
                            } else {
                                this.deviceUpgrade.getFunctions().add(f);
                            }
                            this.deviceUpgrade.getAssignments().assign(b, f, btnState);
                            continue;
                        }
                        f = new ExternalFunction();
                        f.setName(name);
                        f.setHex(km.getCmd(remote));
                        f.setNotes(km.getNotes());
                        ((ExternalFunction)f).setSetupCode(km.getSetupCode());
                        DeviceType dt = remote.getDeviceTypeByIndex(km.getDeviceType());
                        ((ExternalFunction)f).setDeviceTypeAliasName(remote.getDeviceTypeAlias(dt));
                        ((ExternalFunction)f).setType(1);
                        f.setUpgrade(this.deviceUpgrade);
                        ExternalFunction equiv = null;
                        for (ExternalFunction ef : this.deviceUpgrade.getExternalFunctions()) {
                            if (!ef.isEquivalent(f) || !ef.getDeviceTypeAliasName().equals(((ExternalFunction)f).getDeviceTypeAliasName()) || ef.getSetupCode() != ((ExternalFunction)f).getSetupCode()) continue;
                            equiv = ef;
                            break;
                        }
                        if (equiv != null) {
                            f = equiv;
                        } else {
                            this.deviceUpgrade.getExternalFunctions().add((ExternalFunction)f);
                        }
                        this.deviceUpgrade.getAssignments().assign(b, f, btnState);
                    }
                }
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(this, pe.getMessage(), "Import Error", 0);
            }
            this.dispose();
        } else if (source == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (source == this.reset) {
            this.remoteList.setSelectedItem(this.deviceUpgrade.getRemote());
            this.setupCode.setText("");
            this.protocolGreaterThanFF.setSelected(false);
            this.upgradeCode.setText("");
            this.protocolCode.setText("");
            this.validateInput();
        }
    }

    private void validateInput() {
        this.confirm = 0;
        if (this.uCode == null) {
            this.ok.setEnabled(false);
            this.protocolCode.setEnabled(false);
            this.protocolLabel.setEnabled(false);
            this.protocolLabel.setText("Protocol Code:");
            return;
        }
        this.protocolCode.setEnabled(true);
        this.protocolLabel.setEnabled(true);
        if (this.remote == null) {
            this.remote = (Remote)this.remoteList.getSelectedItem();
        }
        if (this.remote.usesTwoBytePID()) {
            this.pid = new Hex(this.uCode, 0, 2);
        } else {
            short[] temp = new short[]{(short)(this.protocolGreaterThanFF.isSelected() ? 1 : 0), this.uCode.getData()[0]};
            this.pid = new Hex(temp);
        }
        ProtocolManager pm = ProtocolManager.getProtocolManager();
        Protocol p = pm.findProtocolForRemote(this.remote, this.pid);
        if (p != null) {
            this.protocolLabel.setText("Protocol Code:");
            Processor pr = this.remote.getProcessor();
            if (p.getCustomCode(pr) != null && this.pCode == null) {
                this.pCode = p.getCustomCode(pr);
                this.confirm = 1;
            } else if (this.pCode != null && this.pCode.length() > 0 && pm.getBuiltinProtocolsForRemote(this.remote, this.pid).contains(p)) {
                this.confirm = 2;
            }
            this.ok.setEnabled(true);
            return;
        }
        this.protocolLabel.setText("Protocol Code for Unknown PID " + this.pid + " ** Required **");
        this.protocolLabel.setEnabled(true);
        this.protocolCode.setEnabled(true);
        if (this.pCode == null) {
            this.ok.setEnabled(false);
            return;
        }
        this.ok.setEnabled(true);
    }

    /*
     * Unable to fully structure code
     */
    public void documentChanged(DocumentEvent e) {
        doc = e.getDocument();
        if (doc == this.upgradeCode.getDocument()) {
            text = this.upgradeCode.getText().trim();
            if (text == null || text.length() == 0) {
                this.uCode = null;
            } else if (!this.loadUpgrade(text)) {
                pos = text.toUpperCase().indexOf("KEYMOVES");
                codeText = pos >= 0 ? text.substring(0, pos) : text;
                keyMoveText = pos >= 0 ? text.substring(pos + 9) : null;
                try {
                    this.uCode = new Hex(codeText);
                    if (keyMoveText == null) ** GOTO lbl43
                    keyMoveText = keyMoveText.replaceAll("\\n", "");
                    this.keyMoves = new ArrayList<ImportedKeyMove>();
                    st = new StringTokenizer(keyMoveText, "\u00a6");
                    while (st.hasMoreTokens()) {
                        token = st.nextToken().trim();
                        pos = token.indexOf(171);
                        hexText = pos >= 0 ? token.substring(0, pos) : token;
                        kmText = pos >= 0 ? token.substring(pos + 1, token.length() - 1) : "";
                        this.keyMoves.add(new ImportedKeyMove(new Hex(hexText), kmText));
                    }
                }
                catch (Exception ex) {
                    this.uCode = null;
                    this.keyMoves = null;
                }
            }
        } else if (doc == this.protocolCode.getDocument()) {
            text = this.protocolCode.getText().trim();
            if (text == null || text.length() == 0) {
                this.pCode = null;
            } else if (!this.loadUpgrade(text)) {
                try {
                    this.pCode = new Hex(text);
                    if (this.pCode.length() < 3) {
                        this.pCode = null;
                    }
                }
                catch (Exception ex) {
                    this.pCode = null;
                }
            }
        }
lbl43:
        // 11 sources

        this.validateInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.remoteList) {
            try {
                if (e.getStateChange() == 1) {
                    Remote oldRemote = this.remote;
                    Remote remote = (Remote)e.getItem();
                    remote.load();
                    String newProcessor = remote.getProcessor().getEquivalentName();
                    if (this.extractProcessor != null && !newProcessor.equals(this.extractProcessor)) {
                        String message = "This upgrade requires a " + this.extractProcessor + " processor and so is\nnot compatible with the selected remote.";
                        String title = "Upgrade incompatibility";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                        this.remoteList.setSelectedItem(oldRemote);
                        return;
                    }
                    String[] aliasNames = remote.getDeviceTypeAliasNames();
                    String alias = this.deviceUpgrade.getDeviceTypeAliasName();
                    this.deviceTypeList.setModel(new DefaultComboBoxModel<String>(aliasNames));
                    this.deviceTypeList.setMaximumRowCount(aliasNames.length);
                    this.deviceTypeList.setSelectedItem(alias);
                    this.protocolGreaterThanFF.setVisible(!remote.usesTwoBytePID());
                    this.validateInput();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (e.getSource() == this.sortOrderList) {
            Remote r = this.restrictRemote ? this.deviceUpgrade.getRemote() : null;
            JComboBox<Remote> box = this.mgr.getRemotesBox(r, this.sortOrderList.getSelectedIndex());
            Remote rr = (Remote)this.remoteList.getSelectedItem();
            this.remoteList.setModel(box.getModel());
            this.remoteList.setRenderer(box.getRenderer());
            this.remoteList.setSelectedItem(rr);
        } else {
            this.validateInput();
        }
    }

    public class TextUpdater
    implements Runnable {
        private JTextArea component;
        private String text;

        public TextUpdater(JTextArea component, String text) {
            this.component = component;
            this.text = text;
        }

        @Override
        public void run() {
            this.component.setText(this.text);
        }
    }

    private class ImportedKeyMove {
        int keyCode = 0;
        int setupValue = 0;
        Hex hex = null;
        String text = null;

        public ImportedKeyMove(Hex hexData, String text) {
            short[] data = hexData.getData();
            this.keyCode = data[0];
            int dataIndex = data[1] == 240 ? 3 : 2;
            this.setupValue = Hex.get(data, dataIndex);
            this.hex = hexData.subHex(dataIndex + 2);
            this.text = text;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getDeviceType() {
            return this.setupValue >> 12;
        }

        public int getSetupCode() {
            return this.setupValue & 0xFFF;
        }

        public String getName() {
            int pos = this.text.indexOf(58);
            return (pos >= 0 ? this.text.substring(0, pos) : this.text).trim();
        }

        public String getNotes() {
            int pos = this.text.indexOf(58);
            return pos >= 0 ? this.text.substring(pos + 1).trim() : null;
        }

        public Hex getCmd(Remote remote) {
            Hex cmd = null;
            int cmdLen = 1;
            try {
                cmdLen = ImportRawUpgradeDialog.this.deviceUpgrade.getProtocol().getDefaultCmdLength();
            }
            catch (Exception ex) {
                System.err.println("ImportRawUpgrade: Unable to determine default command length");
            }
            short[] data = this.hex.getData();
            if (remote.getAdvCodeFormat() == AdvancedCode.Format.EFC) {
                if (this.hex.length() == 2) {
                    cmd = EFC.toHex(this.hex.get(0));
                } else if (this.hex.length() == 3) {
                    int val = this.hex.get(1) | data[0] << 16;
                    cmd = EFC5.toHex(val);
                }
            } else {
                cmd = remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG && data[1] == EFC.parseHex(data[0]) && cmdLen == 1 ? this.hex.subHex(0, 1) : this.hex;
            }
            return cmd;
        }
    }
}

