/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;

public class IntOrNullFormatter
extends DefaultFormatter {
    private int minVal = 0;
    private int maxVal = 0;
    private DocumentFilter docFilter = null;

    public IntOrNullFormatter(int min, int max) {
        this.minVal = min;
        this.maxVal = max;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        if (this.docFilter == null) {
            this.docFilter = new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attrs) throws BadLocationException {
                    try {
                        char[] chars = string.toCharArray();
                        for (int i = 0; i < chars.length; ++i) {
                            if (Character.isDigit(chars[i])) continue;
                            IntOrNullFormatter.this.invalidEdit();
                            return;
                        }
                        String text = IntOrNullFormatter.this.getFormattedTextField().getText();
                        StringBuilder buff = new StringBuilder(chars.length + string.length());
                        buff.append(text.substring(0, offset));
                        buff.append(string);
                        buff.append(text.substring(offset));
                        int temp = Integer.parseInt(buff.toString());
                        if (temp < IntOrNullFormatter.this.minVal || temp > IntOrNullFormatter.this.maxVal) {
                            IntOrNullFormatter.this.invalidEdit();
                        } else {
                            fb.insertString(offset, string, attrs);
                        }
                    }
                    catch (NumberFormatException e) {
                        IntOrNullFormatter.this.invalidEdit();
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attrs) throws BadLocationException {
                    try {
                        char[] chars = string.toCharArray();
                        for (int i = 0; i < chars.length; ++i) {
                            if (Character.isDigit(chars[i])) continue;
                            IntOrNullFormatter.this.invalidEdit();
                            return;
                        }
                        String text = IntOrNullFormatter.this.getFormattedTextField().getText();
                        StringBuilder buff = new StringBuilder();
                        buff.append(text.substring(0, offset));
                        buff.append(string);
                        buff.append(text.substring(offset + length));
                        int temp = Integer.parseInt(buff.toString());
                        if (temp < IntOrNullFormatter.this.minVal || temp > IntOrNullFormatter.this.maxVal) {
                            IntOrNullFormatter.this.invalidEdit();
                        } else {
                            fb.insertString(offset, string, attrs);
                        }
                    }
                    catch (Exception e) {
                        IntOrNullFormatter.this.invalidEdit();
                    }
                }
            };
        }
        return this.docFilter;
    }

    @Override
    public Class<?> getValueClass() {
        return Integer.class;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(string);
    }
}

