/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.KeyMapMaster;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class IntVerifier
extends InputVerifier {
    private int min = 0;
    private int max = 0;
    private int base = 10;
    private boolean allowNull = false;

    public IntVerifier(int min, int max) {
        this(min, max, false);
    }

    public IntVerifier(int min, int max, boolean allowNull) {
        this.min = min;
        this.max = max;
        this.allowNull = allowNull;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextComponent tc = (JTextComponent)input;
        String text = tc.getText();
        if (text == null || text.length() == 0) {
            return this.allowNull;
        }
        try {
            int value = Integer.parseInt(text, this.base);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean shouldYieldFocus(JComponent c) {
        boolean rc = this.verify(c);
        if (!rc) {
            String minStr = Integer.toString(this.min, this.base);
            String maxStr = Integer.toString(this.max, this.base);
            KeyMapMaster.showMessage("The value must be between " + minStr + " and " + maxStr, c);
        } else {
            KeyMapMaster.clearMessage(c);
        }
        return rc;
    }
}

