/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Preferences;
import com.hifiremote.jp1.PropertyFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JP1Frame
extends JFrame
implements HyperlinkListener {
    private static final String XDG_COMMAND = "xdg-open";
    private static final String XDG_COMMAND_TEST_OPTION = "--version";
    private static Desktop desktop = null;
    private static boolean useXdgOpen = false;
    private JLabel messageArea = new JLabel("");
    private JPanel newContentPane = new JPanel(new BorderLayout());
    protected static PropertyFile properties;
    protected static Preferences preferences;

    public JP1Frame(String title, PropertyFile properties) {
        super(title);
        JP1Frame.properties = properties;
        Container contentPane = super.getContentPane();
        contentPane.add((Component)this.newContentPane, "Center");
        this.messageArea.setForeground(Color.red);
        contentPane.add((Component)this.messageArea, "South");
        preferences = new Preferences(properties);
    }

    public static PropertyFile getProperties() {
        return properties;
    }

    public static Preferences getPreferences() {
        return preferences;
    }

    @Override
    public Container getContentPane() {
        return this.newContentPane;
    }

    public void showMessage(String message) {
        this.messageArea.setText(message);
        Toolkit.getDefaultToolkit().beep();
    }

    public static void showMessage(String message, Component c) {
        JP1Frame frame = (JP1Frame)SwingUtilities.getAncestorOfClass(JP1Frame.class, c);
        if (frame != null) {
            frame.showMessage(message);
        }
    }

    public void clearMessage() {
        this.messageArea.setText("");
    }

    public static void clearMessage(Component c) {
        JP1Frame frame = (JP1Frame)SwingUtilities.getAncestorOfClass(JP1Frame.class, c);
        if (frame != null) {
            frame.clearMessage();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (desktop != null) {
            try {
                desktop.browse(event.getURL().toURI());
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            catch (URISyntaxException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    protected static void browse(URI uri) throws URISyntaxException, IOException {
        JP1Frame.browse(uri.toURL());
    }

    protected static void browse(URL url) throws URISyntaxException, IOException {
        if (useXdgOpen) {
            new ProcessBuilder(XDG_COMMAND, url.toString()).start();
        } else if (desktop != null) {
            desktop.browse(url.toURI());
        }
    }

    protected static boolean desktopUsable() {
        return desktop != null || useXdgOpen;
    }

    static {
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(XDG_COMMAND, XDG_COMMAND_TEST_OPTION);
            Process process = processBuilder.start();
            process.waitFor(1L, TimeUnit.SECONDS);
            int exit = process.exitValue();
            useXdgOpen = exit == 0;
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        properties = null;
        preferences = null;
    }
}

