/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.KeyCodeRenderer;
import com.hifiremote.jp1.KeyMoveTableModel;
import com.hifiremote.jp1.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class JP1TableModel<E>
extends AbstractTableModel {
    protected KeyCodeRenderer highlightKeyRenderer = new KeyCodeRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            TableSorter ts = (TableSorter)table.getModel();
            int modelRow = ts.modelIndex(row);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, modelRow, col);
            Object obj = JP1TableModel.this.getRow(modelRow);
            if (obj instanceof Highlight) {
                Highlight hl = (Highlight)obj;
                Color bgColor = null;
                if (isSelected) {
                    bgColor = hl.getUploadStatus() == Highlight.UploadStatus.YES ? null : (hl.getUploadStatus() == Highlight.UploadStatus.WARN ? warnSelectedBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.TEST ? testSelectedBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.INFO ? infoSelectedBGColor : noUploadSelectedBGColor)));
                } else {
                    Color color = hl.getUploadStatus() == Highlight.UploadStatus.YES ? normalBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.WARN ? warnBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.TEST ? testBGColor : (bgColor = hl.getUploadStatus() == Highlight.UploadStatus.INFO ? infoBGColor : noUploadBGColor)));
                }
                if (bgColor != null) {
                    c.setBackground(bgColor);
                }
                if (isSelected && hl.getUploadStatus() != Highlight.UploadStatus.YES) {
                    c.setForeground(Color.white);
                } else if (!isSelected) {
                    c.setForeground(normalFGColor);
                }
            }
            return c;
        }
    };
    protected DefaultTableCellRenderer highlightRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Object obj;
            TableSorter ts = (TableSorter)table.getModel();
            int modelRow = ts.modelIndex(row);
            boolean isDeviceCol = table.getColumnName(col).equals("<html>Device<br>Button</html>");
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, modelRow, col);
            boolean isNormal = true;
            if (JP1TableModel.this instanceof KeyMoveTableModel) {
                boolean bl = isNormal = modelRow < ((KeyMoveTableModel)JP1TableModel.this).getRemoteConfig().getKeyMoves().size();
            }
            if ((obj = JP1TableModel.this.getRow(modelRow)) instanceof Highlight) {
                Highlight hl = (Highlight)obj;
                Color bgColor = null;
                if (isSelected) {
                    bgColor = isDeviceCol ? (hl.getUploadStatus() == Highlight.UploadStatus.YES ? null : (hl.getUploadStatus() == Highlight.UploadStatus.WARN ? warnSelectedBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.TEST ? testSelectedBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.INFO ? infoSelectedBGColor : noUploadSelectedBGColor)))) : (isNormal ? null : attachedSelectedBGColor);
                } else {
                    Color color = isDeviceCol ? (hl.getUploadStatus() == Highlight.UploadStatus.YES ? normalBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.WARN ? warnBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.TEST ? testBGColor : (hl.getUploadStatus() == Highlight.UploadStatus.INFO ? infoBGColor : noUploadBGColor)))) : (bgColor = isNormal ? normalBGColor : attachedBGColor);
                }
                if (bgColor != null) {
                    c.setBackground(bgColor);
                }
                if (isSelected && (!isDeviceCol && !isNormal || isDeviceCol && hl.getUploadStatus() != Highlight.UploadStatus.YES)) {
                    c.setForeground(Color.white);
                } else if (!isSelected) {
                    c.setForeground(normalFGColor);
                }
            }
            return c;
        }
    };
    protected List<E> data = null;
    protected E[] array = null;
    protected SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);
    public static Color normalBGColor = Color.white;
    public static Color normalFGColor = Color.black;
    private static final Color warnBGColor = new Color(255, 200, 0);
    private static final Color warnSelectedBGColor = new Color(200, 160, 0);
    private static final Color testBGColor = new Color(255, 0, 255);
    private static final Color testSelectedBGColor = new Color(220, 0, 220);
    private static final Color infoBGColor = Color.green;
    private static final Color infoSelectedBGColor = new Color(0, 160, 0);
    private static final Color noUploadBGColor = Color.pink;
    private static final Color noUploadSelectedBGColor = Color.red;
    private static final Color attachedBGColor = Color.lightGray;
    private static final Color attachedSelectedBGColor = Color.darkGray;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public abstract String getColumnPrototypeName(int var1);

    public void setData(List<E> data) {
        this.data = data;
        this.array = null;
        this.fireTableStructureChanged();
    }

    public void setData(E[] array) {
        this.array = array;
        this.data = null;
        this.fireTableStructureChanged();
    }

    public List<E> getData() {
        return this.data;
    }

    public E[] getArray() {
        return this.array;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            if (this.array == null) {
                return 0;
            }
            return this.array.length;
        }
        return this.data.size();
    }

    public E getRow(int row) {
        if (this.data != null) {
            return this.data.get(row);
        }
        if (this.array != null) {
            return this.array[row];
        }
        return null;
    }

    public void setRow(int row, E value) {
        this.data.set(row, value);
        this.propertyChangeSupport.firePropertyChange("data", null, null);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.data.remove(row);
        this.propertyChangeSupport.firePropertyChange("size", null, null);
        this.fireTableRowsDeleted(row, row);
    }

    public void insertRow(int row, E value) {
        this.data.add(row, value);
        this.propertyChangeSupport.firePropertyChange("size", null, null);
        this.fireTableRowsInserted(row, row);
    }

    public void addRow(E value) {
        this.data.add(value);
        this.propertyChangeSupport.firePropertyChange("size", null, null);
        int row = this.data.size() - 1;
        this.fireTableRowsInserted(row, row);
    }

    public void moveRow(int from, int to) {
        E o = this.data.remove(from);
        this.data.add(to, o);
        this.propertyChangeSupport.firePropertyChange("order", null, null);
        this.fireTableRowsUpdated(from, to);
    }

    public boolean isColumnWidthFixed(int col) {
        return col == 0;
    }

    public TableCellEditor getColumnEditor(int col) {
        return null;
    }

    public TableCellRenderer getColumnRenderer(int col) {
        return null;
    }

    public String getToolTipText(int row, int col) {
        return null;
    }
}

